/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;

class TrivialResourceDefinition
extends SimpleResourceDefinition {
    private final String pathKey;
    private final RuntimeCapability<?> firstCapability;
    private final AttributeDefinition[] attributes;

    TrivialResourceDefinition(String pathKey, ResourceDescriptionResolver resourceDescriptionResolver, AbstractAddStepHandler add, AttributeDefinition[] attributes, RuntimeCapability<?> ... runtimeCapabilities) {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)pathKey), resourceDescriptionResolver).setAddHandler((OperationStepHandler)add).setRemoveHandler((OperationStepHandler)new TrivialCapabilityServiceRemoveHandler(add, runtimeCapabilities)).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(runtimeCapabilities));
        this.pathKey = pathKey;
        this.firstCapability = runtimeCapabilities[0];
        this.attributes = attributes;
    }

    TrivialResourceDefinition(String pathKey, AbstractAddStepHandler add, AttributeDefinition[] attributes, RuntimeCapability<?> ... runtimeCapabilities) {
        this(pathKey, (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver(pathKey), add, attributes, runtimeCapabilities);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        if (this.attributes != null && this.attributes.length > 0) {
            ElytronReloadRequiredWriteAttributeHandler writeHandler = new ElytronReloadRequiredWriteAttributeHandler(this.attributes);
            for (AttributeDefinition current : this.attributes) {
                resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)writeHandler);
            }
        }
    }
}

