/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.Provider;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.AggregateRealmDefinition;
import org.wildfly.extension.elytron.AuditResourceDefinitions;
import org.wildfly.extension.elytron.AuthenticationClientDefinitions;
import org.wildfly.extension.elytron.AuthenticationContextAssociationProcessor;
import org.wildfly.extension.elytron.AuthenticationContextDependencyProcessor;
import org.wildfly.extension.elytron.AuthenticationFactoryDefinitions;
import org.wildfly.extension.elytron.CachingRealmDefinition;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.CredentialStoreResourceDefinition;
import org.wildfly.extension.elytron.CustomComponentDefinition;
import org.wildfly.extension.elytron.DependencyProcessor;
import org.wildfly.extension.elytron.DirContextDefinition;
import org.wildfly.extension.elytron.DomainDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronOperationStepHandler;
import org.wildfly.extension.elytron.ElytronRemoveStepHandler;
import org.wildfly.extension.elytron.ElytronWriteAttributeHandler;
import org.wildfly.extension.elytron.FileSystemRealmDefinition;
import org.wildfly.extension.elytron.FilteringKeyStoreDefinition;
import org.wildfly.extension.elytron.HttpServerDefinitions;
import org.wildfly.extension.elytron.JdbcRealmDefinition;
import org.wildfly.extension.elytron.KerberosSecurityFactoryDefinition;
import org.wildfly.extension.elytron.KeyStoreDefinition;
import org.wildfly.extension.elytron.KeyStoreRealmDefinition;
import org.wildfly.extension.elytron.LdapKeyStoreDefinition;
import org.wildfly.extension.elytron.LdapRealmDefinition;
import org.wildfly.extension.elytron.ModifiableKeyStoreDecorator;
import org.wildfly.extension.elytron.PermissionMapperDefinitions;
import org.wildfly.extension.elytron.PolicyDefinitions;
import org.wildfly.extension.elytron.PrincipalDecoderDefinitions;
import org.wildfly.extension.elytron.PrincipalTransformerDefinitions;
import org.wildfly.extension.elytron.PropertiesRealmDefinition;
import org.wildfly.extension.elytron.ProviderDefinitions;
import org.wildfly.extension.elytron.ProviderRegistrationService;
import org.wildfly.extension.elytron.RealmDefinitions;
import org.wildfly.extension.elytron.RealmMapperDefinitions;
import org.wildfly.extension.elytron.RoleDecoderDefinitions;
import org.wildfly.extension.elytron.RoleMapperDefinitions;
import org.wildfly.extension.elytron.SSLDefinitions;
import org.wildfly.extension.elytron.SaslServerDefinitions;
import org.wildfly.extension.elytron.SecurityPropertyResourceDefinition;
import org.wildfly.extension.elytron.SecurityPropertyService;
import org.wildfly.extension.elytron.SecurityRealmResourceDecorator;
import org.wildfly.extension.elytron.TokenRealmDefinition;
import org.wildfly.extension.elytron.capabilities.CredentialSecurityFactory;
import org.wildfly.extension.elytron.capabilities.PrincipalTransformer;
import org.wildfly.security.Version;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.PermissionMapper;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.authz.RoleMapper;

class ElytronDefinition
extends SimpleResourceDefinition {
    private static final OperationContext.AttachmentKey<SecurityPropertyService> SECURITY_PROPERTY_SERVICE_KEY = OperationContext.AttachmentKey.create(SecurityPropertyService.class);
    private static final AuthenticationContextDependencyProcessor AUTHENITCATION_CONTEXT_PROCESSOR = new AuthenticationContextDependencyProcessor();
    static final SimpleAttributeDefinition DEFAULT_AUTHENTICATION_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-authentication-context", ModelType.STRING, true).setCapabilityReference("org.wildfly.security.authentication-context", Capabilities.ELYTRON_RUNTIME_CAPABILITY)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition INITIAL_PROVIDERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("initial-providers", ModelType.STRING, true).setCapabilityReference("org.wildfly.security.providers", Capabilities.ELYTRON_RUNTIME_CAPABILITY)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition FINAL_PROVIDERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("final-providers", ModelType.STRING, true).setCapabilityReference("org.wildfly.security.providers", Capabilities.ELYTRON_RUNTIME_CAPABILITY)).setRestartAllServices()).build();
    public static final ElytronDefinition INSTANCE = new ElytronDefinition();

    private ElytronDefinition() {
        super(new SimpleResourceDefinition.Parameters(ElytronExtension.SUBSYSTEM_PATH, (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver(new String[0])).setAddHandler((OperationStepHandler)new ElytronAdd()).setRemoveHandler((OperationStepHandler)new ElytronRemove()).setCapabilities(new RuntimeCapability[]{Capabilities.ELYTRON_RUNTIME_CAPABILITY}).addAccessConstraints(new AccessConstraintDefinition[]{new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("elytron", "elytron-security", true, true, true)), new ApplicationTypeAccessConstraintDefinition(new ApplicationTypeConfig("elytron", "elytron-security", false))}));
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new SecurityPropertyResourceDefinition());
        resourceRegistration.registerSubModel(ProviderDefinitions.getAggregateProvidersDefinition());
        resourceRegistration.registerSubModel(ProviderDefinitions.getProviderLoaderDefinition());
        resourceRegistration.registerSubModel(AuditResourceDefinitions.getAggregateSecurityEventListenerDefinition());
        resourceRegistration.registerSubModel(AuditResourceDefinitions.getFileAuditLogResourceDefinition());
        resourceRegistration.registerSubModel(AuditResourceDefinitions.getRotatingFileAuditLogResourceDefinition());
        resourceRegistration.registerSubModel(AuditResourceDefinitions.getSyslogAuditLogResourceDefinition());
        resourceRegistration.registerSubModel(AuthenticationFactoryDefinitions.getSaslAuthenticationFactory());
        resourceRegistration.registerSubModel(AuthenticationFactoryDefinitions.getHttpAuthenticationFactory());
        resourceRegistration.registerSubModel((ResourceDefinition)new DomainDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new AggregateRealmDefinition());
        resourceRegistration.registerSubModel(new CustomComponentDefinition<SecurityRealm>(SecurityRealm.class, "custom-realm", Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY));
        resourceRegistration.registerSubModel(SecurityRealmResourceDecorator.wrap(new CustomComponentDefinition<ModifiableSecurityRealm>(ModifiableSecurityRealm.class, "custom-modifiable-realm", Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY)));
        resourceRegistration.registerSubModel(RealmDefinitions.getIdentityRealmDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new JdbcRealmDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new KeyStoreRealmDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new PropertiesRealmDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new TokenRealmDefinition());
        resourceRegistration.registerSubModel(SecurityRealmResourceDecorator.wrap((ResourceDefinition)new LdapRealmDefinition()));
        resourceRegistration.registerSubModel(SecurityRealmResourceDecorator.wrap((ResourceDefinition)new FileSystemRealmDefinition()));
        resourceRegistration.registerSubModel((ResourceDefinition)new CachingRealmDefinition());
        resourceRegistration.registerSubModel(new CustomComponentDefinition<CredentialSecurityFactory>(CredentialSecurityFactory.class, "custom-credential-security-factory", Capabilities.SECURITY_FACTORY_CREDENTIAL_RUNTIME_CAPABILITY));
        resourceRegistration.registerSubModel(KerberosSecurityFactoryDefinition.getKerberosSecurityFactoryDefinition());
        resourceRegistration.registerSubModel(new CustomComponentDefinition<PermissionMapper>(PermissionMapper.class, "custom-permission-mapper", Capabilities.PERMISSION_MAPPER_RUNTIME_CAPABILITY));
        resourceRegistration.registerSubModel(PermissionMapperDefinitions.getLogicalPermissionMapper());
        resourceRegistration.registerSubModel(PermissionMapperDefinitions.getSimplePermissionMapper());
        resourceRegistration.registerSubModel(PermissionMapperDefinitions.getConstantPermissionMapper());
        resourceRegistration.registerSubModel(PrincipalDecoderDefinitions.getAggregatePrincipalDecoderDefinition());
        resourceRegistration.registerSubModel(PrincipalDecoderDefinitions.getConcatenatingPrincipalDecoder());
        resourceRegistration.registerSubModel(PrincipalDecoderDefinitions.getConstantPrincipalDecoder());
        resourceRegistration.registerSubModel(new CustomComponentDefinition<PrincipalDecoder>(PrincipalDecoder.class, "custom-principal-decoder", Capabilities.PRINCIPAL_DECODER_RUNTIME_CAPABILITY));
        resourceRegistration.registerSubModel(PrincipalDecoderDefinitions.getX500AttributePrincipalDecoder());
        resourceRegistration.registerSubModel(PrincipalTransformerDefinitions.getAggregatePrincipalTransformerDefinition());
        resourceRegistration.registerSubModel(PrincipalTransformerDefinitions.getChainedPrincipalTransformerDefinition());
        resourceRegistration.registerSubModel(PrincipalTransformerDefinitions.getConstantPrincipalTransformerDefinition());
        resourceRegistration.registerSubModel(new CustomComponentDefinition<PrincipalTransformer>(PrincipalTransformer.class, "custom-principal-transformer", Capabilities.PRINCIPAL_TRANSFORMER_RUNTIME_CAPABILITY));
        resourceRegistration.registerSubModel(PrincipalTransformerDefinitions.getRegexPrincipalTransformerDefinition());
        resourceRegistration.registerSubModel(PrincipalTransformerDefinitions.getRegexValidatingPrincipalTransformerDefinition());
        resourceRegistration.registerSubModel(RealmMapperDefinitions.getConstantRealmMapper());
        resourceRegistration.registerSubModel(new CustomComponentDefinition<RealmMapper>(RealmMapper.class, "custom-realm-mapper", Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY));
        resourceRegistration.registerSubModel(RealmMapperDefinitions.getMappedRegexRealmMapper());
        resourceRegistration.registerSubModel(RealmMapperDefinitions.getSimpleRegexRealmMapperDefinition());
        resourceRegistration.registerSubModel(new CustomComponentDefinition<RoleDecoder>(RoleDecoder.class, "custom-role-decoder", Capabilities.ROLE_DECODER_RUNTIME_CAPABILITY));
        resourceRegistration.registerSubModel(RoleDecoderDefinitions.getSimpleRoleDecoderDefinition());
        resourceRegistration.registerSubModel(RoleMapperDefinitions.getAddSuffixRoleMapperDefinition());
        resourceRegistration.registerSubModel(RoleMapperDefinitions.getAddPrefixRoleMapperDefinition());
        resourceRegistration.registerSubModel(RoleMapperDefinitions.getAggregateRoleMapperDefinition());
        resourceRegistration.registerSubModel(RoleMapperDefinitions.getConstantRoleMapperDefinition());
        resourceRegistration.registerSubModel(new CustomComponentDefinition<RoleMapper>(RoleMapper.class, "custom-role-mapper", Capabilities.ROLE_MAPPER_RUNTIME_CAPABILITY));
        resourceRegistration.registerSubModel(RoleMapperDefinitions.getLogicalRoleMapperDefinition());
        resourceRegistration.registerSubModel(HttpServerDefinitions.getAggregateHttpServerFactoryDefinition());
        resourceRegistration.registerSubModel(HttpServerDefinitions.getConfigurableHttpServerMechanismFactoryDefinition());
        resourceRegistration.registerSubModel(HttpServerDefinitions.getProviderHttpServerMechanismFactoryDefinition());
        resourceRegistration.registerSubModel(HttpServerDefinitions.getServiceLoaderServerMechanismFactoryDefinition());
        resourceRegistration.registerSubModel(SaslServerDefinitions.getAggregateSaslServerFactoryDefinition());
        resourceRegistration.registerSubModel(SaslServerDefinitions.getConfigurableSaslServerFactoryDefinition());
        resourceRegistration.registerSubModel(SaslServerDefinitions.getMechanismProviderFilteringSaslServerFactory());
        resourceRegistration.registerSubModel(SaslServerDefinitions.getProviderSaslServerFactoryDefinition());
        resourceRegistration.registerSubModel(SaslServerDefinitions.getServiceLoaderSaslServerFactoryDefinition());
        resourceRegistration.registerSubModel(ModifiableKeyStoreDecorator.wrap((ResourceDefinition)new KeyStoreDefinition()));
        resourceRegistration.registerSubModel(ModifiableKeyStoreDecorator.wrap((ResourceDefinition)new LdapKeyStoreDefinition()));
        resourceRegistration.registerSubModel(ModifiableKeyStoreDecorator.wrap((ResourceDefinition)new FilteringKeyStoreDefinition()));
        resourceRegistration.registerSubModel(SSLDefinitions.getKeyManagerDefinition());
        resourceRegistration.registerSubModel(SSLDefinitions.getTrustManagerDefinition());
        resourceRegistration.registerSubModel(SSLDefinitions.getServerSSLContextDefinition());
        resourceRegistration.registerSubModel(SSLDefinitions.getClientSSLContextDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new CredentialStoreResourceDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new DirContextDefinition());
        resourceRegistration.registerSubModel(AuthenticationClientDefinitions.getAuthenticationClientDefinition());
        resourceRegistration.registerSubModel(AuthenticationClientDefinitions.getAuthenticationContextDefinition());
        resourceRegistration.registerSubModel(PolicyDefinitions.getPolicy());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{INITIAL_PROVIDERS, FINAL_PROVIDERS});
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)INITIAL_PROVIDERS, null, (OperationStepHandler)writeHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)FINAL_PROVIDERS, null, (OperationStepHandler)writeHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)DEFAULT_AUTHENTICATION_CONTEXT, null, (OperationStepHandler)new ElytronWriteAttributeHandler<Void>(new AttributeDefinition[]{DEFAULT_AUTHENTICATION_CONTEXT}){

            protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
                AUTHENITCATION_CONTEXT_PROCESSOR.setDefaultAuthenticationContext(resolvedValue.isDefined() ? resolvedValue.asString() : null);
                return !context.isBooting();
            }

            protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
                AUTHENITCATION_CONTEXT_PROCESSOR.setDefaultAuthenticationContext(valueToRestore.isDefined() ? valueToRestore.asString() : null);
            }
        });
    }

    static <T> ServiceBuilder<T> commonDependencies(ServiceBuilder<T> serviceBuilder) {
        return ElytronDefinition.commonDependencies(serviceBuilder, true, true);
    }

    static <T> ServiceBuilder<T> commonDependencies(ServiceBuilder<T> serviceBuilder, boolean dependOnProperties, boolean dependOnProviderRegistration) {
        if (dependOnProperties) {
            serviceBuilder.addDependencies(new ServiceName[]{SecurityPropertyService.SERVICE_NAME});
        }
        if (dependOnProviderRegistration) {
            serviceBuilder.addDependencies(new ServiceName[]{ProviderRegistrationService.SERVICE_NAME});
        }
        return serviceBuilder;
    }

    private static void installService(ServiceName serviceName, Service<?> service, ServiceTarget serviceTarget) {
        serviceTarget.addService(serviceName, service).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private static SecurityPropertyService uninstallSecurityPropertyService(OperationContext context) {
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        ServiceController service = serviceRegistry.getService(SecurityPropertyService.SERVICE_NAME);
        if (service != null) {
            Service serviceImplementation = service.getService();
            context.removeService(service);
            if (serviceImplementation != null && serviceImplementation instanceof SecurityPropertyService) {
                return (SecurityPropertyService)serviceImplementation;
            }
        }
        return null;
    }

    private static class ElytronRemove
    extends ElytronRemoveStepHandler {
        private ElytronRemove() {
            super(Capabilities.ELYTRON_RUNTIME_CAPABILITY);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            if (context.isResourceServiceRestartAllowed()) {
                SecurityPropertyService securityPropertyService = ElytronDefinition.uninstallSecurityPropertyService(context);
                if (securityPropertyService != null) {
                    context.attach(SECURITY_PROPERTY_SERVICE_KEY, (Object)securityPropertyService);
                }
                context.removeService(ProviderRegistrationService.SERVICE_NAME);
            } else {
                context.reloadRequired();
            }
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget target = context.getServiceTarget();
            SecurityPropertyService securityPropertyService = (SecurityPropertyService)context.getAttachment(SECURITY_PROPERTY_SERVICE_KEY);
            if (securityPropertyService != null) {
                ElytronDefinition.installService(SecurityPropertyService.SERVICE_NAME, securityPropertyService, target);
            }
            ElytronDefinition.installService(ProviderRegistrationService.SERVICE_NAME, new ProviderRegistrationService(), target);
        }
    }

    private static class ElytronAdd
    extends AbstractBoottimeAddStepHandler
    implements ElytronOperationStepHandler {
        private ElytronAdd() {
            super(Capabilities.ELYTRON_RUNTIME_CAPABILITY, new AttributeDefinition[]{DEFAULT_AUTHENTICATION_CONTEXT, INITIAL_PROVIDERS, FINAL_PROVIDERS});
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            Version.getVersion();
            super.populateModel(operation, model);
        }

        protected void performBoottime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            String finalProviders;
            ModelNode model = resource.getModel();
            ModelNode defaultAuthenticationContext = DEFAULT_AUTHENTICATION_CONTEXT.resolveModelAttribute(context, model);
            AUTHENITCATION_CONTEXT_PROCESSOR.setDefaultAuthenticationContext(defaultAuthenticationContext.isDefined() ? defaultAuthenticationContext.asString() : null);
            ServiceTarget target = context.getServiceTarget();
            ElytronDefinition.installService(SecurityPropertyService.SERVICE_NAME, new SecurityPropertyService(), target);
            ProviderRegistrationService prs = new ProviderRegistrationService();
            ServiceBuilder builder = target.addService(ProviderRegistrationService.SERVICE_NAME, (Service)prs).setInitialMode(ServiceController.Mode.ACTIVE);
            String initialProviders = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)INITIAL_PROVIDERS, model);
            if (initialProviders != null) {
                builder.addDependency(context.getCapabilityServiceName("org.wildfly.security.providers", initialProviders, Provider[].class), Provider[].class, prs.getInitialProivders());
            }
            if ((finalProviders = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)FINAL_PROVIDERS, model)) != null) {
                builder.addDependency(context.getCapabilityServiceName("org.wildfly.security.providers", finalProviders, Provider[].class), Provider[].class, prs.getFinalProviders());
            }
            builder.install();
            if (context.isNormalServer()) {
                context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

                    protected void execute(DeploymentProcessorTarget processorTarget) {
                        processorTarget.addDeploymentProcessor("elytron", Phase.DEPENDENCIES, 3153, (DeploymentUnitProcessor)new DependencyProcessor());
                        processorTarget.addDeploymentProcessor("elytron", Phase.CONFIGURE_MODULE, 1280, (DeploymentUnitProcessor)AUTHENITCATION_CONTEXT_PROCESSOR);
                        processorTarget.addDeploymentProcessor("elytron", Phase.FIRST_MODULE_USE, 1536, (DeploymentUnitProcessor)new AuthenticationContextAssociationProcessor());
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
            ElytronDefinition.uninstallSecurityPropertyService(context);
            context.removeService(ProviderRegistrationService.SERVICE_NAME);
            AUTHENITCATION_CONTEXT_PROCESSOR.setDefaultAuthenticationContext(null);
        }

        protected boolean requiresRuntime(OperationContext context) {
            return this.isServerOrHostController(context);
        }
    }
}

