/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.Provider;
import java.util.HashMap;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartException;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.CredentialStoreAliasDefinition;
import org.wildfly.extension.elytron.CredentialStoreResource;
import org.wildfly.extension.elytron.CredentialStoreService;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronRuntimeOnlyHandler;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.ServiceStateDefinition;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;

final class CredentialStoreResourceDefinition
extends SimpleResourceDefinition {
    static final ServiceUtil<CredentialStore> CREDENTIAL_STORE_UTIL = ServiceUtil.newInstance(Capabilities.CREDENTIAL_STORE_RUNTIME_CAPABILITY, "credential-store", CredentialStore.class);
    static final SimpleAttributeDefinition LOCATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("location", ModelType.STRING, true).setAttributeGroup("implementation")).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MODIFIABLE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("modifiable", ModelType.BOOLEAN, true).setAttributeGroup("implementation")).setDefaultValue(new ModelNode(true))).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition CREATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("create", ModelType.BOOLEAN, true).setAttributeGroup("implementation")).setAllowExpression(false)).setDefaultValue(new ModelNode(false))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleMapAttributeDefinition IMPLEMENTATION_PROPERTIES = ((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("implementation-properties", ModelType.STRING, true).setAttributeGroup("implementation")).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final ObjectTypeAttributeDefinition CREDENTIAL_REFERENCE = CredentialReference.getAttributeDefinition((boolean)true);
    static final SimpleAttributeDefinition TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("type", ModelType.STRING, true).setAttributeGroup("implementation")).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition PROVIDER_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("provider-name", ModelType.STRING, true).setAttributeGroup("implementation")).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition PROVIDERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("providers", ModelType.STRING, true).setAttributeGroup("implementation")).setAllowExpression(false)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.credential-store", true)).build();
    static final SimpleAttributeDefinition OTHER_PROVIDERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("other-providers", ModelType.STRING, true).setAttributeGroup("implementation")).setAllowExpression(false)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.credential-store", true)).build();
    static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", ModelType.STRING, true).setAllowExpression(false)).setMinSize(1)).setAttributeGroup("file")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition CASE_SENSITIVE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("case-sensitive", ModelType.BOOLEAN, true).setAttributeGroup("implementation")).setAllowExpression(false)).setDefaultValue(new ModelNode(false))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final StandardResourceDescriptionResolver RESOURCE_RESOLVER = ElytronExtension.getResourceDescriptionResolver("credential-store");
    static final SimpleOperationDefinition RELOAD = new SimpleOperationDefinitionBuilder("reload", (ResourceDescriptionResolver)RESOURCE_RESOLVER).build();
    private static final AttributeDefinition[] CONFIG_ATTRIBUTES = new AttributeDefinition[]{LOCATION, CREATE, MODIFIABLE, IMPLEMENTATION_PROPERTIES, CREDENTIAL_REFERENCE, TYPE, PROVIDER_NAME, PROVIDERS, OTHER_PROVIDERS, RELATIVE_TO, CASE_SENSITIVE};
    private static final CredentialStoreAddHandler ADD = new CredentialStoreAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.CREDENTIAL_STORE_RUNTIME_CAPABILITY);
    private static final WriteAttributeHandler WRITE = new WriteAttributeHandler();

    CredentialStoreResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"credential-store"), (ResourceDescriptionResolver)RESOURCE_RESOLVER).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_NONE).setRemoveRestartLevel(OperationEntry.Flag.RESTART_NONE).setCapabilities(new RuntimeCapability[]{Capabilities.CREDENTIAL_STORE_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition current : CONFIG_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)WRITE);
        }
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ServiceStateDefinition.STATE, (OperationStepHandler)new ElytronRuntimeOnlyHandler(){

            protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceName credentialStoreClientServiceName = CREDENTIAL_STORE_UTIL.serviceName(operation);
                ServiceController serviceController = context.getServiceRegistry(false).getRequiredService(credentialStoreClientServiceName);
                ServiceStateDefinition.populateResponse(context.getResult(), serviceController);
            }
        });
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)RELOAD, (OperationStepHandler)CredentialStoreHandler.INSTANCE);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new CredentialStoreAliasDefinition());
    }

    static String credentialStoreName(ModelNode operation) {
        String credentialStoreName = null;
        PathAddress pa = PathAddress.pathAddress((ModelNode)operation.require("address"));
        for (int i = pa.size() - 1; i > 0; --i) {
            PathElement pe = pa.getElement(i);
            if (!"credential-store".equals(pe.getKey())) continue;
            credentialStoreName = pe.getValue();
            break;
        }
        if (credentialStoreName == null) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.operationAddressMissingKey("credential-store");
        }
        return credentialStoreName;
    }

    private static class CredentialStoreHandler
    extends CredentialStoreRuntimeOnlyHandler {
        private static final CredentialStoreHandler INSTANCE = new CredentialStoreHandler();

        private CredentialStoreHandler() {
            super(true, true);
        }

        @Override
        protected void performRuntime(ModelNode result, OperationContext context, ModelNode operation, CredentialStoreService credentialStoreService) throws OperationFailedException {
            String operationName;
            switch (operationName = operation.require("operation").asString()) {
                case "reload": {
                    try {
                        credentialStoreService.stop(null);
                        credentialStoreService.start(null);
                        break;
                    }
                    catch (StartException e) {
                        throw new OperationFailedException((Throwable)e);
                    }
                }
                default: {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.invalidOperationName(operationName, "load");
                }
            }
        }
    }

    static abstract class CredentialStoreRuntimeOnlyHandler
    extends ElytronRuntimeOnlyHandler {
        private final boolean serviceMustBeUp;
        private final boolean writeAccess;

        CredentialStoreRuntimeOnlyHandler(boolean serviceMustBeUp, boolean writeAccess) {
            this.serviceMustBeUp = serviceMustBeUp;
            this.writeAccess = writeAccess;
        }

        CredentialStoreRuntimeOnlyHandler(boolean serviceMustBeUp) {
            this(serviceMustBeUp, false);
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ServiceName credentialStoreServiceName = CREDENTIAL_STORE_UTIL.serviceName(operation);
            ServiceController credentialStoreServiceController = context.getServiceRegistry(this.writeAccess).getRequiredService(credentialStoreServiceName);
            ServiceController.State serviceState = credentialStoreServiceController.getState();
            if (serviceState != ServiceController.State.UP) {
                if (this.serviceMustBeUp) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.requiredServiceNotUp(credentialStoreServiceName, serviceState);
                }
                return;
            }
            CredentialStoreService service = (CredentialStoreService)credentialStoreServiceController.getService();
            this.performRuntime(context.getResult(), context, operation, service);
        }

        protected abstract void performRuntime(ModelNode var1, OperationContext var2, ModelNode var3, CredentialStoreService var4) throws OperationFailedException;
    }

    private static class WriteAttributeHandler
    extends ModelOnlyWriteAttributeHandler {
        WriteAttributeHandler() {
            super(CONFIG_ATTRIBUTES);
        }
    }

    private static class CredentialStoreAddHandler
    extends BaseAddHandler {
        private CredentialStoreAddHandler() {
            super(Capabilities.CREDENTIAL_STORE_RUNTIME_CAPABILITY, CONFIG_ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            String providersCapabilityName;
            CredentialStoreService csService;
            HashMap<String, String> implementationAttributes;
            ModelNode model = resource.getModel();
            String location = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)LOCATION, model);
            boolean modifiable = MODIFIABLE.resolveModelAttribute(context, model).asBoolean();
            boolean create = CREATE.resolveModelAttribute(context, model).asBoolean();
            ModelNode implAttrModel = IMPLEMENTATION_PROPERTIES.resolveModelAttribute(context, model);
            if (implAttrModel.isDefined()) {
                implementationAttributes = new HashMap<String, String>();
                implAttrModel.keys().forEach(s -> implementationAttributes.put((String)s, implAttrModel.require(s).asString()));
            } else {
                implementationAttributes = null;
            }
            String type = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)TYPE, model);
            String providers = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)PROVIDERS, model);
            String otherProviders = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)OTHER_PROVIDERS, model);
            String providerName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)PROVIDER_NAME, model);
            String name = CredentialStoreResourceDefinition.credentialStoreName(operation);
            String relativeTo = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)RELATIVE_TO, model);
            ServiceTarget serviceTarget = context.getServiceTarget();
            try {
                csService = CredentialStoreService.createCredentialStoreService(name, location, modifiable, create, implementationAttributes, type, providerName, relativeTo, providers, otherProviders);
            }
            catch (CredentialStoreException e) {
                throw new OperationFailedException((Throwable)e);
            }
            ServiceName credentialStoreServiceName = CREDENTIAL_STORE_UTIL.serviceName(operation);
            ServiceBuilder credentialStoreServiceBuilder = serviceTarget.addService(credentialStoreServiceName, (Service)csService).setInitialMode(ServiceController.Mode.ACTIVE);
            if (relativeTo != null) {
                credentialStoreServiceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, csService.getPathManagerInjector());
                credentialStoreServiceBuilder.addDependency(FileAttributeDefinitions.pathName(relativeTo));
            }
            if (providers != null) {
                providersCapabilityName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.providers", (String)providers);
                ServiceName providerLoaderServiceName = context.getCapabilityServiceName(providersCapabilityName, Provider[].class);
                credentialStoreServiceBuilder.addDependency(providerLoaderServiceName, Provider[].class, csService.getProvidersInjector());
            }
            if (otherProviders != null) {
                providersCapabilityName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.providers", (String)otherProviders);
                ServiceName otherProvidersLoaderServiceName = context.getCapabilityServiceName(providersCapabilityName, Provider[].class);
                credentialStoreServiceBuilder.addDependency(otherProvidersLoaderServiceName, Provider[].class, csService.getOtherProvidersInjector());
            }
            csService.getCredentialSourceSupplierInjector().inject((Object)CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)CREDENTIAL_REFERENCE, (ModelNode)model, (ServiceBuilder)credentialStoreServiceBuilder));
            ElytronDefinition.commonDependencies(credentialStoreServiceBuilder);
            ServiceController credentialStoreServiceController = credentialStoreServiceBuilder.install();
            ((CredentialStoreResource)resource).setCredentialStoreServiceController((ServiceController<CredentialStore>)credentialStoreServiceController);
        }

        protected Resource createResource(OperationContext context) {
            CredentialStoreResource resource = new CredentialStoreResource(Resource.Factory.create());
            context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
            return resource;
        }
    }
}

