/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.Provider;
import java.util.Set;

class ProviderUtil {
    ProviderUtil() {
    }

    static Provider identifyProvider(Provider[] candidates, String name, Class<?> type, String algorithm) {
        String typeName = type.getSimpleName();
        for (Provider current : candidates) {
            if (name != null && !name.equals(current.getName()) || current.getService(typeName, algorithm) == null) continue;
            return current;
        }
        return null;
    }

    static boolean isServiceTypeProvided(Provider[] candidates, Class<?> type) {
        String serviceType = type.getSimpleName();
        for (Provider current : candidates) {
            Set<Provider.Service> services = current.getServices();
            if (services == null) continue;
            for (Provider.Service currentService : services) {
                if (!serviceType.equals(currentService.getType())) continue;
                return true;
            }
        }
        return false;
    }
}

