/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.AuthenticationFactoryParser;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.CommonAttributes;
import org.wildfly.extension.elytron.ElytronSubsystemParser;
import org.wildfly.extension.elytron.SaslServerDefinitions;

class SaslParser {
    private final AuthenticationFactoryParser authenticationFactoryParser = new AuthenticationFactoryParser();

    SaslParser() {
    }

    void readSasl(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block16: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "sasl-authentication-factory": {
                    this.authenticationFactoryParser.readSaslAuthenticationFactoryElement(parentAddress, reader, operations);
                    continue block16;
                }
                case "aggregate-sasl-server-factory": {
                    this.readAggregateSaslServerFactoryElement(parentAddress, reader, operations);
                    continue block16;
                }
                case "configurable-sasl-server-factory": {
                    this.readConfigurableSaslServerFactoryElement(parentAddress, reader, operations);
                    continue block16;
                }
                case "mechanism-provider-filtering-sasl-server-factory": {
                    this.readMechanismProviderFilteringSaslServerFactoryElement(parentAddress, reader, operations);
                    continue block16;
                }
                case "provider-sasl-server-factory": {
                    this.readProviderSaslServerFactoryElement(parentAddress, reader, operations);
                    continue block16;
                }
                case "service-loader-sasl-server-factory": {
                    this.readServiceLoaderSaslServerFactoryElement(parentAddress, reader, operations);
                    continue block16;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readAggregateSaslServerFactoryElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addOperation = new ModelNode();
        addOperation.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        addOperation.get("address").set(parentAddress).add("aggregate-sasl-server-factory", name);
        operations.add(addOperation);
        ListAttributeDefinition saslServerFactories = SaslServerDefinitions.getRawAggregateSaslServerFactoryDefinition().getReferencesAttribute();
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!"sasl-server-factory".equals(localName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
            String saslServerFactoryName = reader.getAttributeValue(0);
            saslServerFactories.parseAndAddParameterElement(saslServerFactoryName, addOperation, (XMLStreamReader)reader);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }

    private void readConfigurableSaslServerFactoryElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addOperation = new ModelNode();
        addOperation.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "sasl-server-factory"));
        String name = null;
        int count = reader.getAttributeCount();
        block20: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block20;
                }
                case "sasl-server-factory": {
                    SaslServerDefinitions.SASL_SERVER_FACTORY.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block20;
                }
                case "protocol": {
                    SaslServerDefinitions.PROTOCOL.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block20;
                }
                case "server-name": {
                    SaslServerDefinitions.SERVER_NAME.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block20;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addOperation.get("address").set(parentAddress).add("configurable-sasl-server-factory", name);
        block21: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "filters": {
                    ModelNode filters = addOperation.get("filters");
                    this.parseFilters(filters, reader);
                    continue block21;
                }
                case "properties": {
                    ModelNode properties = addOperation.get("properties");
                    this.parseProperties(properties, reader);
                    continue block21;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(addOperation);
    }

    private void parseFilters(ModelNode filters, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "filter": {
                    this.parseFilter(filters, reader);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseFilter(ModelNode filters, XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode filter = new ModelNode();
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            String attribute;
            String attributeValue = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "enabling": {
                    SaslServerDefinitions.ENABLING.parseAndSetParameter(attributeValue, filter, (XMLStreamReader)reader);
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "predefined-filter": {
                    ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"value");
                    String value = reader.getAttributeValue(0);
                    SaslServerDefinitions.PREDEFINED_FILTER.parseAndSetParameter(value, filter, (XMLStreamReader)reader);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block15;
                }
                case "pattern-filter": {
                    ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"value");
                    String value = reader.getAttributeValue(0);
                    SaslServerDefinitions.PATTERN_FILTER.parseAndSetParameter(value, filter, (XMLStreamReader)reader);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        filters.add(filter);
    }

    private void parseProperties(ModelNode properties, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "property": {
                    this.parseProperty(properties, reader);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseProperty(ModelNode properties, XMLExtendedStreamReader reader) throws XMLStreamException {
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "value"));
        String key = null;
        String value = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String attributeValue = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    key = attributeValue;
                    continue block8;
                }
                case "value": {
                    value = attributeValue;
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        properties.add(key, new ModelNode(value));
    }

    private void readMechanismProviderFilteringSaslServerFactoryElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addOperation = new ModelNode();
        addOperation.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "sasl-server-factory"));
        String name = null;
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block16;
                }
                case "sasl-server-factory": {
                    SaslServerDefinitions.SASL_SERVER_FACTORY.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block16;
                }
                case "enabling": {
                    SaslServerDefinitions.ENABLING.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addOperation.get("address").set(parentAddress).add("mechanism-provider-filtering-sasl-server-factory", name);
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "filters": {
                    ModelNode filters = addOperation.get("filters");
                    ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                    while (reader.hasNext() && reader.nextTag() != 2) {
                        ElytronSubsystemParser.verifyNamespace(reader);
                        if (!"filter".equals(reader.getLocalName())) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        this.parseMechanismProviderFilter(filters, reader);
                    }
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(addOperation);
    }

    private void parseMechanismProviderFilter(ModelNode filters, XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode filter = new ModelNode();
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("provider-name"));
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "mechanism-name": {
                    SaslServerDefinitions.MECHANISM_NAME.parseAndSetParameter(value, filter, (XMLStreamReader)reader);
                    continue block12;
                }
                case "provider-name": {
                    SaslServerDefinitions.PROVIDER_NAME.parseAndSetParameter(value, filter, (XMLStreamReader)reader);
                    continue block12;
                }
                case "provider-version": {
                    SaslServerDefinitions.PROVIDER_VERSION.parseAndSetParameter(value, filter, (XMLStreamReader)reader);
                    continue block12;
                }
                case "version-comparison": {
                    SaslServerDefinitions.VERSION_COMPARISON.parseAndSetParameter(value, filter, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        filters.add(filter);
    }

    private void readProviderSaslServerFactoryElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addOperation = new ModelNode();
        addOperation.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block8;
                }
                case "providers": {
                    SaslServerDefinitions.PROVIDERS.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        addOperation.get("address").set(parentAddress).add("provider-sasl-server-factory", name);
        operations.add(addOperation);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readServiceLoaderSaslServerFactoryElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addOperation = new ModelNode();
        addOperation.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block8;
                }
                case "module": {
                    ClassLoadingAttributeDefinitions.MODULE.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        addOperation.get("address").set(parentAddress).add("service-loader-sasl-server-factory", name);
        operations.add(addOperation);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void startSasl(boolean started, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (!started) {
            writer.writeStartElement("sasl");
        }
    }

    private boolean writeAggregateSaslServerFactory(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("aggregate-sasl-server-factory")) {
            this.startSasl(started, writer);
            ModelNode serverFactories = subsystem.require("aggregate-sasl-server-factory");
            for (String name : serverFactories.keys()) {
                ModelNode serverFactory = serverFactories.require(name);
                writer.writeStartElement("aggregate-sasl-server-factory");
                writer.writeAttribute("name", name);
                List serverFactoryReferences = serverFactory.get("sasl-server-factories").asList();
                for (ModelNode currentReference : serverFactoryReferences) {
                    writer.writeStartElement("sasl-server-factory");
                    writer.writeAttribute("name", currentReference.asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeConfigurableSaslServerFactory(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("configurable-sasl-server-factory")) {
            this.startSasl(started, writer);
            ModelNode saslServerFactories = subsystem.require("configurable-sasl-server-factory");
            for (String name : saslServerFactories.keys()) {
                ModelNode serverFactory = saslServerFactories.require(name);
                writer.writeStartElement("configurable-sasl-server-factory");
                writer.writeAttribute("name", name);
                SaslServerDefinitions.PROTOCOL.marshallAsAttribute(serverFactory, (XMLStreamWriter)writer);
                SaslServerDefinitions.SASL_SERVER_FACTORY.marshallAsAttribute(serverFactory, (XMLStreamWriter)writer);
                SaslServerDefinitions.SERVER_NAME.marshallAsAttribute(serverFactory, (XMLStreamWriter)writer);
                CommonAttributes.PROPERTIES.marshallAsElement(serverFactory, (XMLStreamWriter)writer);
                if (serverFactory.hasDefined("filters")) {
                    writer.writeStartElement("filters");
                    List filters = serverFactory.require("filters").asList();
                    for (ModelNode currentFilter : filters) {
                        writer.writeStartElement("filter");
                        SaslServerDefinitions.ENABLING.marshallAsAttribute(currentFilter, (XMLStreamWriter)writer);
                        if (currentFilter.hasDefined("predefined-filter")) {
                            writer.writeStartElement("predefined-filter");
                            SaslServerDefinitions.PREDEFINED_FILTER.marshallAsAttribute(currentFilter, (XMLStreamWriter)writer);
                            writer.writeEndElement();
                        } else if (currentFilter.hasDefined("pattern-filter")) {
                            writer.writeStartElement("pattern-filter");
                            SaslServerDefinitions.PATTERN_FILTER.marshallAsAttribute(currentFilter, (XMLStreamWriter)writer);
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeMechanismProviderFilteringSaslServerFactory(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("mechanism-provider-filtering-sasl-server-factory")) {
            this.startSasl(started, writer);
            ModelNode saslServerFactories = subsystem.require("mechanism-provider-filtering-sasl-server-factory");
            for (String name : saslServerFactories.keys()) {
                ModelNode serverFactory = saslServerFactories.require(name);
                writer.writeStartElement("mechanism-provider-filtering-sasl-server-factory");
                writer.writeAttribute("name", name);
                SaslServerDefinitions.ENABLING.marshallAsAttribute(serverFactory, (XMLStreamWriter)writer);
                SaslServerDefinitions.SASL_SERVER_FACTORY.marshallAsAttribute(serverFactory, (XMLStreamWriter)writer);
                if (serverFactory.hasDefined("filters")) {
                    writer.writeStartElement("filters");
                    List filters = serverFactory.require("filters").asList();
                    for (ModelNode currentFilter : filters) {
                        writer.writeStartElement("filter");
                        SaslServerDefinitions.MECHANISM_NAME.marshallAsAttribute(currentFilter, (XMLStreamWriter)writer);
                        SaslServerDefinitions.PROVIDER_NAME.marshallAsAttribute(currentFilter, (XMLStreamWriter)writer);
                        SaslServerDefinitions.PROVIDER_VERSION.marshallAsAttribute(currentFilter, (XMLStreamWriter)writer);
                        SaslServerDefinitions.VERSION_COMPARISON.marshallAsAttribute(currentFilter, (XMLStreamWriter)writer);
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeProviderSaslServerFactory(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("provider-sasl-server-factory")) {
            this.startSasl(started, writer);
            ModelNode serverFactories = subsystem.require("provider-sasl-server-factory");
            for (String name : serverFactories.keys()) {
                ModelNode serverFactory = serverFactories.require(name);
                writer.writeStartElement("provider-sasl-server-factory");
                writer.writeAttribute("name", name);
                SaslServerDefinitions.PROVIDERS.marshallAsAttribute(serverFactory, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeServiceLoaderSaslServerFactory(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("service-loader-sasl-server-factory")) {
            this.startSasl(started, writer);
            ModelNode serverFactories = subsystem.require("service-loader-sasl-server-factory");
            for (String name : serverFactories.keys()) {
                ModelNode serverFactory = serverFactories.require(name);
                writer.writeStartElement("service-loader-sasl-server-factory");
                writer.writeAttribute("name", name);
                ClassLoadingAttributeDefinitions.MODULE.marshallAsAttribute(serverFactory, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    void writeSasl(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        boolean saslStarted = false;
        saslStarted |= this.authenticationFactoryParser.writeSaslAuthenticationFactory(saslStarted, subsystem, writer, b -> this.startSasl(b, writer));
        saslStarted |= this.writeAggregateSaslServerFactory(saslStarted, subsystem, writer);
        saslStarted |= this.writeConfigurableSaslServerFactory(saslStarted, subsystem, writer);
        saslStarted |= this.writeMechanismProviderFilteringSaslServerFactory(saslStarted, subsystem, writer);
        saslStarted |= this.writeProviderSaslServerFactory(saslStarted, subsystem, writer);
        if (saslStarted |= this.writeServiceLoaderSaslServerFactory(saslStarted, subsystem, writer)) {
            writer.writeEndElement();
        }
    }
}

