/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.authz.PermissionMapper;
import org.wildfly.security.authz.SimplePermissionMapper;
import org.wildfly.security.permission.InvalidPermissionClassException;
import org.wildfly.security.permission.PermissionUtil;
import org.wildfly.security.permission.PermissionVerifier;

class PermissionMapperDefinitions {
    static final SimpleAttributeDefinition LEFT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("left", ModelType.STRING, false).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.permission-mapper", "org.wildfly.security.permission-mapper", true)).build();
    static final SimpleAttributeDefinition RIGHT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("right", ModelType.STRING, false).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.permission-mapper", "org.wildfly.security.permission-mapper", true)).build();
    static final SimpleAttributeDefinition LOGICAL_OPERATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("logical-operation", ModelType.STRING, false).setAllowExpression(true)).setAllowedValues(new String[]{"and", "or", "xor", "unless"})).setValidator((ParameterValidator)EnumValidator.create(LogicalMapperOperation.class, (boolean)false, (boolean)true))).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MAPPING_MODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("mapping-mode", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode("first"))).setAllowedValues(new String[]{"and", "or", "xor", "unless", "first"})).setValidator((ParameterValidator)EnumValidator.create(MappingMode.class, (boolean)true, (boolean)true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final StringListAttributeDefinition PRINCIPALS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("principals").setAllowExpression(true)).setRequired(false)).setMinSize(1)).build();
    static final StringListAttributeDefinition ROLES = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("roles").setAllowExpression(true)).setRequired(false)).setMinSize(1)).build();
    static final SimpleAttributeDefinition TARGET_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("target-name", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).build();
    static final SimpleAttributeDefinition ACTION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("action", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).build();
    static final ObjectTypeAttributeDefinition PERMISSION = new ObjectTypeAttributeDefinition.Builder("permission", new AttributeDefinition[]{ClassLoadingAttributeDefinitions.CLASS_NAME, ClassLoadingAttributeDefinitions.MODULE, TARGET_NAME, ACTION}).build();
    static final ObjectListAttributeDefinition PERMISSIONS = new ObjectListAttributeDefinition.Builder("permissions", PERMISSION).setAllowNull(true).build();
    static final ObjectTypeAttributeDefinition PERMISSION_MAPPING = new ObjectTypeAttributeDefinition.Builder("permission-mapping", new AttributeDefinition[]{PRINCIPALS, ROLES, PERMISSIONS}).build();
    static final ObjectListAttributeDefinition PERMISSION_MAPPINGS = new ObjectListAttributeDefinition.Builder("permission-mappings", PERMISSION_MAPPING).setAllowNull(true).build();

    PermissionMapperDefinitions() {
    }

    static ResourceDefinition getLogicalPermissionMapper() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{LOGICAL_OPERATION, LEFT, RIGHT};
        TrivialAddHandler<PermissionMapper> add = new TrivialAddHandler<PermissionMapper>(PermissionMapper.class, attributes, new RuntimeCapability[]{Capabilities.PERMISSION_MAPPER_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<PermissionMapper> getValueSupplier(ServiceBuilder<PermissionMapper> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                InjectedValue leftPermissionMapperInjector = new InjectedValue();
                InjectedValue rightPermissionMapperInjector = new InjectedValue();
                LogicalMapperOperation operation = LogicalMapperOperation.valueOf(LogicalMapperOperation.class, LOGICAL_OPERATION.resolveModelAttribute(context, model).asString().toUpperCase(Locale.ENGLISH));
                serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.permission-mapper", (String)LEFT.resolveModelAttribute(context, model).asString()), PermissionMapper.class), PermissionMapper.class, (Injector)leftPermissionMapperInjector);
                serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.permission-mapper", (String)RIGHT.resolveModelAttribute(context, model).asString()), PermissionMapper.class), PermissionMapper.class, (Injector)rightPermissionMapperInjector);
                return () -> operation.create((PermissionMapper)leftPermissionMapperInjector.getValue(), (PermissionMapper)rightPermissionMapperInjector.getValue());
            }
        };
        return new TrivialResourceDefinition("logical-permission-mapper", add, attributes, Capabilities.PERMISSION_MAPPER_RUNTIME_CAPABILITY);
    }

    static ResourceDefinition getSimplePermissionMapper() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{MAPPING_MODE, PERMISSION_MAPPINGS};
        TrivialAddHandler<PermissionMapper> add = new TrivialAddHandler<PermissionMapper>(PermissionMapper.class, attributes, new RuntimeCapability[]{Capabilities.PERMISSION_MAPPER_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<PermissionMapper> getValueSupplier(ServiceBuilder<PermissionMapper> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                MappingMode mappingMode = MappingMode.valueOf(MappingMode.class, MAPPING_MODE.resolveModelAttribute(context, model).asString().toUpperCase(Locale.ENGLISH));
                ArrayList<Mapping> permissionMappings = new ArrayList<Mapping>();
                if (model.hasDefined("permission-mappings")) {
                    for (ModelNode permissionMapping : model.get("permission-mappings").asList()) {
                        HashSet<String> principals = new HashSet<String>(PRINCIPALS.unwrap((ExpressionResolver)context, permissionMapping));
                        HashSet<String> roles = new HashSet<String>(ROLES.unwrap((ExpressionResolver)context, permissionMapping));
                        ArrayList<Permission> permissions = new ArrayList<Permission>();
                        if (permissionMapping.hasDefined("permissions")) {
                            for (ModelNode permission : permissionMapping.require("permissions").asList()) {
                                permissions.add(new Permission(ClassLoadingAttributeDefinitions.CLASS_NAME.resolveModelAttribute(context, permission).asString(), ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ClassLoadingAttributeDefinitions.MODULE, permission), ElytronExtension.asStringIfDefined(context, (AttributeDefinition)TARGET_NAME, permission), ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ACTION, permission)));
                            }
                        }
                        permissionMappings.add(new Mapping(principals, roles, permissions));
                    }
                }
                return () -> PermissionMapperDefinitions.createSimplePermissionMapper(mappingMode, permissionMappings);
            }
        };
        return new TrivialResourceDefinition("simple-permission-mapper", add, attributes, Capabilities.PERMISSION_MAPPER_RUNTIME_CAPABILITY);
    }

    private static PermissionMapper createSimplePermissionMapper(MappingMode mappingMode, List<Mapping> mappings) throws StartException {
        SimplePermissionMapper.Builder builder = SimplePermissionMapper.builder();
        builder.setMappingMode(mappingMode.convert());
        for (Mapping current : mappings) {
            Permissions permissions = new Permissions();
            for (Permission permission : current.getPermissions()) {
                java.security.Permission realPerm = PermissionMapperDefinitions.createPermission(permission);
                if (realPerm == null) continue;
                permissions.add(realPerm);
            }
            builder.addMapping(current.getPrincipals(), current.getRoles(), PermissionVerifier.from((PermissionCollection)permissions));
        }
        return builder.build();
    }

    static ResourceDefinition getConstantPermissionMapper() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{PERMISSIONS};
        TrivialAddHandler<PermissionMapper> add = new TrivialAddHandler<PermissionMapper>(PermissionMapper.class, attributes, new RuntimeCapability[]{Capabilities.PERMISSION_MAPPER_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<PermissionMapper> getValueSupplier(ServiceBuilder<PermissionMapper> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                ArrayList<Permission> permissions = new ArrayList<Permission>();
                if (model.hasDefined("permissions")) {
                    for (ModelNode permission : model.require("permissions").asList()) {
                        permissions.add(new Permission(ClassLoadingAttributeDefinitions.CLASS_NAME.resolveModelAttribute(context, permission).asString(), ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ClassLoadingAttributeDefinitions.MODULE, permission), ElytronExtension.asStringIfDefined(context, (AttributeDefinition)TARGET_NAME, permission), ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ACTION, permission)));
                    }
                }
                return () -> PermissionMapperDefinitions.createConstantPermissionMapper(permissions);
            }
        };
        return new TrivialResourceDefinition("constant-permission-mapper", add, attributes, Capabilities.PERMISSION_MAPPER_RUNTIME_CAPABILITY);
    }

    private static PermissionMapper createConstantPermissionMapper(List<Permission> permissionsList) throws StartException {
        Permissions permissions = new Permissions();
        for (Permission permission : permissionsList) {
            java.security.Permission realPerm = PermissionMapperDefinitions.createPermission(permission);
            if (realPerm == null) continue;
            permissions.add(realPerm);
        }
        return PermissionMapper.createConstant((PermissionVerifier)PermissionVerifier.from((PermissionCollection)permissions));
    }

    private static java.security.Permission createPermission(Permission permission) throws StartException {
        Module currentModule = Module.getCallerModule();
        if (permission.getModule() != null && currentModule != null) {
            ModuleIdentifier mi = ModuleIdentifier.fromString((String)permission.getModule());
            try {
                currentModule = currentModule.getModule(mi);
            }
            catch (ModuleLoadException e) {
                return null;
            }
        }
        Object classLoader = currentModule != null ? currentModule.getClassLoader() : PermissionMapperDefinitions.class.getClassLoader();
        try {
            return PermissionUtil.createPermission((ClassLoader)classLoader, (String)permission.getClassName(), (String)permission.getTargetName(), (String)permission.getAction());
        }
        catch (InvalidPermissionClassException e) {
            return null;
        }
        catch (Throwable e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.exceptionWhileCreatingPermission(permission.getClassName(), e);
        }
    }

    private static enum LogicalMapperOperation {
        AND((l, r) -> l.and(r)),
        OR((l, r) -> l.or(r)),
        XOR((l, r) -> l.xor(r)),
        UNLESS((l, r) -> l.unless(r));

        private final BinaryOperator<PermissionMapper> operator;

        private LogicalMapperOperation(BinaryOperator<PermissionMapper> operator) {
            this.operator = operator;
        }

        PermissionMapper create(PermissionMapper left, PermissionMapper right) {
            return (PermissionMapper)this.operator.apply(left, right);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    private static enum MappingMode {
        AND,
        OR,
        XOR,
        UNLESS,
        FIRST;


        SimplePermissionMapper.MappingMode convert() {
            switch (this) {
                case AND: {
                    return SimplePermissionMapper.MappingMode.AND;
                }
                case OR: {
                    return SimplePermissionMapper.MappingMode.OR;
                }
                case XOR: {
                    return SimplePermissionMapper.MappingMode.XOR;
                }
                case UNLESS: {
                    return SimplePermissionMapper.MappingMode.UNLESS;
                }
            }
            return SimplePermissionMapper.MappingMode.FIRST_MATCH;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static class Mapping {
        private final Set<String> principals;
        private final Set<String> roles;
        private final List<Permission> permissions;

        Mapping(Set<String> principals, Set<String> roles, List<Permission> permissions) {
            this.principals = principals;
            this.roles = roles;
            this.permissions = permissions;
        }

        public Set<String> getPrincipals() {
            return this.principals;
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public List<Permission> getPermissions() {
            return this.permissions;
        }
    }

    static class Permission {
        private final String className;
        private final String module;
        private final String targetName;
        private final String action;

        Permission(String className, String module, String targetName, String action) {
            this.className = className;
            this.module = module;
            this.targetName = targetName;
            this.action = action;
        }

        public String getClassName() {
            return this.className;
        }

        public String getModule() {
            return this.module;
        }

        public String getTargetName() {
            return this.targetName;
        }

        public String getAction() {
            return this.action;
        }
    }
}

