/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.auth.realm.DistributedSecurityRealm;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.event.SecurityEvent;
import org.wildfly.security.auth.server.event.SecurityRealmUnavailableEvent;

class DistributedRealmDefinition
extends SimpleResourceDefinition {
    static final ServiceUtil<SecurityRealm> REALM_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, "aggregate-realm", SecurityRealm.class);
    static final StringListAttributeDefinition REALMS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("realms").setMinSize(1)).setCapabilityReference("org.wildfly.security.security-realm")).setRestartAllServices()).build();
    static final SimpleAttributeDefinition IGNORE_UNAVAILABLE_REALMS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ignore-unavailable-realms", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition EMIT_EVENTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("emit-events", ModelType.BOOLEAN, true).setRequires(new String[]{"ignore-unavailable-realms"})).setAllowExpression(true)).setRestartAllServices()).setDefaultValue(ModelNode.TRUE)).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{REALMS, IGNORE_UNAVAILABLE_REALMS, EMIT_EVENTS};
    private static final AbstractAddStepHandler ADD = new RealmAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);

    DistributedRealmDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"distributed-realm"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("distributed-realm")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ElytronReloadRequiredWriteAttributeHandler write = new ElytronReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)write);
        }
    }

    private static class RealmAddHandler
    extends BaseAddHandler {
        private RealmAddHandler() {
            super(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName realmName = runtimeCapability.getCapabilityServiceName(SecurityRealm.class);
            ArrayList<InjectedValue> distributedRealmValues = new ArrayList<InjectedValue>();
            boolean ignoreUnavailableRealms = IGNORE_UNAVAILABLE_REALMS.resolveModelAttribute(context, model).asBoolean();
            boolean emitEvents = EMIT_EVENTS.resolveModelAttribute(context, model).asBoolean();
            List distributedRealms = REALMS.unwrap((ExpressionResolver)context, model);
            TrivialService<SecurityRealm> distributedRealmService = new TrivialService<SecurityRealm>(() -> {
                SecurityRealm[] realms = new SecurityRealm[distributedRealmValues.size()];
                Consumer<Integer> unavailableRealmConsumer = ignoreUnavailableRealms && emitEvents ? realmIndex -> {
                    SecurityDomain domain = SecurityDomain.getCurrent();
                    String realm = (String)distributedRealms.get((int)realmIndex);
                    if (domain != null) {
                        domain.handleSecurityEvent((SecurityEvent)new SecurityRealmUnavailableEvent(domain.getCurrentSecurityIdentity(), realm));
                    }
                } : realmIndex -> {};
                for (int i = 0; i < distributedRealmValues.size(); ++i) {
                    realms[i] = (SecurityRealm)((InjectedValue)distributedRealmValues.get(i)).getValue();
                }
                return new DistributedSecurityRealm(ignoreUnavailableRealms, unavailableRealmConsumer, realms);
            });
            ServiceBuilder serviceBuilder = serviceTarget.addService(realmName, distributedRealmService);
            for (String distributedRealm : distributedRealms) {
                InjectedValue authorizationRealmValue = new InjectedValue();
                this.addRealmDependency(context, (ServiceBuilder<SecurityRealm>)serviceBuilder, distributedRealm, (Injector<SecurityRealm>)authorizationRealmValue);
                distributedRealmValues.add(authorizationRealmValue);
            }
            ElytronDefinition.commonDependencies(serviceBuilder).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }

        private void addRealmDependency(OperationContext context, ServiceBuilder<SecurityRealm> serviceBuilder, String realmName, Injector<SecurityRealm> securityRealmInjector) {
            String runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.security-realm", (String)realmName);
            ServiceName realmServiceName = context.getCapabilityServiceName(runtimeCapability, SecurityRealm.class);
            REALM_SERVICE_UTIL.addInjection(serviceBuilder, securityRealmInjector, realmServiceName);
        }
    }
}

