/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.Permissions;
import java.util.ArrayList;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.PermissionMapperDefinitions;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;

class PermissionSetDefinition {
    static final ObjectListAttributeDefinition PERMISSIONS = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("permissions", PermissionMapperDefinitions.PERMISSION).setRequired(false)).setRestartAllServices()).setAttributeMarshaller(AttributeMarshaller.UNWRAPPED_OBJECT_LIST_MARSHALLER)).setAttributeParser(AttributeParser.UNWRAPPED_OBJECT_LIST_PARSER)).build();

    PermissionSetDefinition() {
    }

    static ResourceDefinition getPermissionSet() {
        AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{PERMISSIONS};
        TrivialAddHandler<Permissions> add = new TrivialAddHandler<Permissions>(Permissions.class, ATTRIBUTES, Capabilities.PERMISSION_SET_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<Permissions> getValueSupplier(ServiceBuilder<Permissions> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                ArrayList<PermissionMapperDefinitions.Permission> permissionsList = new ArrayList<PermissionMapperDefinitions.Permission>();
                if (model.hasDefined("permissions")) {
                    for (ModelNode permission : model.get("permissions").asList()) {
                        permissionsList.add(new PermissionMapperDefinitions.Permission(ClassLoadingAttributeDefinitions.CLASS_NAME.resolveModelAttribute(context, permission).asString(), ClassLoadingAttributeDefinitions.MODULE.resolveModelAttribute(context, permission).asStringOrNull(), PermissionMapperDefinitions.TARGET_NAME.resolveModelAttribute(context, permission).asStringOrNull(), PermissionMapperDefinitions.ACTION.resolveModelAttribute(context, permission).asStringOrNull()));
                    }
                }
                return () -> PermissionMapperDefinitions.createPermissions(permissionsList);
            }
        };
        return new TrivialResourceDefinition("permission-set", add, ATTRIBUTES, Capabilities.PERMISSION_SET_RUNTIME_CAPABILITY);
    }
}

