/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.expression;

import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.Map;
import javax.crypto.SecretKey;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ExpressionResolverExtension;
import org.jboss.as.controller.OperationClientException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionBiConsumer;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.encryption.CipherUtil;

public class ElytronExpressionResolver
implements ExpressionResolverExtension {
    private static final String CREDENTIAL_STORE_API_CAPABILITY = "org.wildfly.security.credential-store-api";
    private volatile boolean initialised = false;
    private final ThreadLocal<String> initialisingFor = new ThreadLocal();
    private volatile OperationFailedException firstFailure = null;
    private final ExceptionBiConsumer<ElytronExpressionResolver, OperationContext, OperationFailedException> configurator;
    private volatile String prefix;
    private volatile String completePrefix;
    private volatile String defaultResolver;
    private volatile Map<String, ResolverConfiguration> resolverConfigurations;

    public ElytronExpressionResolver(ExceptionBiConsumer<ElytronExpressionResolver, OperationContext, OperationFailedException> configurator) {
        this.configurator = configurator;
    }

    public void initialize(OperationContext context) throws OperationFailedException {
        this.ensureInitialised(null, context);
    }

    public String resolveExpression(String expression, OperationContext context) {
        Assert.checkNotNullParam((String)"expression", (Object)expression);
        Assert.checkNotNullParam((String)"context", (Object)context);
        return this.resolveExpressionInternal(expression, context, null);
    }

    String resolveDeploymentExpression(String expression, CapabilityServiceSupport serviceSupport) {
        return this.resolveExpressionInternal(expression, null, serviceSupport);
    }

    private String resolveExpressionInternal(String fullExpression, OperationContext operationContext, CapabilityServiceSupport serviceSupport) {
        assert (operationContext == null || serviceSupport == null);
        assert (operationContext != null || serviceSupport != null);
        if (fullExpression.length() > 3) {
            String expression = fullExpression.substring(2, fullExpression.length() - 1);
            try {
                this.ensureInitialised(fullExpression, operationContext);
            }
            catch (OperationFailedException e) {
                throw new IllegalStateException(e);
            }
            if (expression.startsWith(this.completePrefix)) {
                SecretKey secretKey;
                String resolver;
                int delimiter = expression.indexOf(58, this.completePrefix.length());
                String string = resolver = delimiter > 0 ? expression.substring(this.completePrefix.length(), delimiter) : this.defaultResolver;
                if (resolver == null) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.expressionResolutionWithoutResolver(fullExpression);
                }
                ResolverConfiguration resolverConfiguration = this.resolverConfigurations.get(resolver);
                if (resolverConfiguration == null) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.invalidResolver(fullExpression);
                }
                ElytronSubsystemMessages.ROOT_LOGGER.tracef("Attempting to decrypt expression '%s' using credential store '%s' and alias '%s'.", fullExpression, resolverConfiguration.credentialStore, resolverConfiguration.alias);
                CredentialStore credentialStore = this.resolveCredentialStore(resolverConfiguration.getCredentialStore(), operationContext, serviceSupport);
                try {
                    SecretKeyCredential credential = (SecretKeyCredential)credentialStore.retrieve(resolverConfiguration.getAlias(), SecretKeyCredential.class);
                    secretKey = credential.getSecretKey();
                }
                catch (CredentialStoreException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.unableToLoadCredential(e);
                }
                String token = expression.substring(expression.lastIndexOf(58) + 1);
                try {
                    return CipherUtil.decrypt((String)token, (SecretKey)secretKey);
                }
                catch (GeneralSecurityException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.unableToDecryptExpression(fullExpression, e);
                }
            }
        }
        return null;
    }

    public String createExpression(String resolver, String clearText, OperationContext context) throws OperationFailedException {
        String cipherTextToken;
        SecretKey secretKey;
        String resolvedResolver;
        this.ensureInitialised(null, context);
        String string = resolvedResolver = resolver != null ? resolver : this.defaultResolver;
        if (resolvedResolver == null) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.noResolverSpecifiedAndNoDefault();
        }
        ResolverConfiguration resolverConfiguration = this.resolverConfigurations.get(resolvedResolver);
        if (resolverConfiguration == null) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.noResolverWithSpecifiedName(resolvedResolver);
        }
        CredentialStore credentialStore = this.resolveCredentialStore(resolverConfiguration.getCredentialStore(), context, null);
        try {
            SecretKeyCredential credential = (SecretKeyCredential)credentialStore.retrieve(resolverConfiguration.getAlias(), SecretKeyCredential.class);
            if (credential == null) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.credentialDoesNotExist(resolverConfiguration.getAlias(), SecretKeyCredential.class.getSimpleName());
            }
            secretKey = credential.getSecretKey();
        }
        catch (CredentialStoreException e) {
            throw new OperationFailedException((Throwable)ElytronSubsystemMessages.ROOT_LOGGER.unableToLoadCredential(e));
        }
        try {
            cipherTextToken = CipherUtil.encrypt((String)clearText, (SecretKey)secretKey);
        }
        catch (GeneralSecurityException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToEncryptClearText(e);
        }
        String expression = resolver == null ? String.format("${%s::%s}", this.prefix, cipherTextToken) : String.format("${%s::%s:%s}", this.prefix, resolvedResolver, cipherTextToken);
        return expression;
    }

    public ElytronExpressionResolver setPrefix(String prefix) {
        this.prefix = prefix;
        this.completePrefix = prefix + "::";
        return this;
    }

    public ElytronExpressionResolver setDefaultResolver(String defaultResolver) {
        this.defaultResolver = defaultResolver;
        return this;
    }

    public ElytronExpressionResolver setResolverConfigurations(Map<String, ResolverConfiguration> resolverConfigurations) {
        this.resolverConfigurations = Collections.unmodifiableMap(resolverConfigurations);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureInitialised(String initialisingFor, OperationContext context) throws OperationFailedException {
        if (!this.initialised) {
            String existingInitialisation;
            if (this.firstFailure != null) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.expressionResolverInitialisationAlreadyFailed(this.firstFailure);
            }
            if (initialisingFor != null && (existingInitialisation = this.initialisingFor.get()) != null) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.cycleDetectedInitialisingExpressionResolver(existingInitialisation, existingInitialisation);
            }
            ElytronExpressionResolver elytronExpressionResolver = this;
            synchronized (elytronExpressionResolver) {
                if (!this.initialised) {
                    try {
                        this.initialisingFor.set(initialisingFor);
                        if (context == null) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.illegalNonManagementInitialization(this.getClass());
                        }
                        this.configurator.accept((Object)this, (Object)context);
                        this.initialised = true;
                    }
                    catch (OperationFailedException e) {
                        this.firstFailure = e;
                        throw e;
                    }
                    finally {
                        this.initialisingFor.set(null);
                    }
                }
            }
        }
    }

    private CredentialStore resolveCredentialStore(String credentialStore, OperationContext operationContext, CapabilityServiceSupport serviceSupport) {
        Throwable toThrow;
        try {
            ExceptionFunction function;
            if (operationContext != null) {
                try {
                    function = (ExceptionFunction)operationContext.getCapabilityRuntimeAPI(CREDENTIAL_STORE_API_CAPABILITY, credentialStore, ExceptionFunction.class);
                }
                catch (IllegalStateException re) {
                    if (operationContext.getCurrentStage() == OperationContext.Stage.MODEL) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.modelStageResolutionNotSupported(re);
                    }
                    throw re;
                }
            } else {
                Assert.checkNotNullParam((String)"serviceSupport", (Object)serviceSupport);
                function = (ExceptionFunction)serviceSupport.getCapabilityRuntimeAPI(CREDENTIAL_STORE_API_CAPABILITY, credentialStore, ExceptionFunction.class);
            }
            return (CredentialStore)function.apply((Object)operationContext);
        }
        catch (ExpressionResolver.ExpressionResolutionServerException | ExpressionResolver.ExpressionResolutionUserException ree) {
            toThrow = ree;
        }
        catch (RuntimeException | OperationFailedException | CapabilityServiceSupport.NoSuchCapabilityException e) {
            toThrow = e instanceof OperationClientException ? ElytronSubsystemMessages.ROOT_LOGGER.unableToInitializeCredentialStore(credentialStore, e.getLocalizedMessage(), (Exception)e) : ElytronSubsystemMessages.ROOT_LOGGER.unableToResolveCredentialStore(credentialStore, e.getLocalizedMessage(), (Exception)e);
        }
        throw toThrow;
    }

    public static class ResolverConfiguration {
        private final String credentialStore;
        private final String alias;

        public ResolverConfiguration(String credentialStore, String alias) {
            this.credentialStore = (String)Assert.checkNotNullParam((String)"credentialStore", (Object)credentialStore);
            this.alias = (String)Assert.checkNotNullParam((String)"alias", (Object)alias);
        }

        public String getCredentialStore() {
            return this.credentialStore;
        }

        public String getAlias() {
            return this.alias;
        }
    }
}

