/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.management.security.KeystoreAttributes;
import org.jboss.as.domain.management.security.SecurityRealmChildAddHandler;
import org.jboss.as.domain.management.security.SecurityRealmChildRemoveHandler;
import org.jboss.as.domain.management.security.SecurityRealmChildWriteAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SSLServerIdentityResourceDefinition
extends SimpleResourceDefinition {
    public static final SimpleAttributeDefinition PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("protocol", ModelType.STRING, true).setDefaultValue(new ModelNode("TLS"))).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    public static final StringListAttributeDefinition ENABLED_CIPHER_SUITES = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("enabled-cipher-suites").setAllowExpression(true)).setAllowNull(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).setAttributeMarshaller((AttributeMarshaller)new StringListMarshaller(Attribute.ENABLED_CIPHER_SUITES.getLocalName()))).build();
    public static final StringListAttributeDefinition ENABLED_PROTOCOLS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("enabled-protocols").setDefaultValue(new ModelNode().add("TLSv1").add("TLSv1.1").add("TLSv1.2"))).setAllowExpression(true)).setAllowNull(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).setAttributeMarshaller((AttributeMarshaller)new StringListMarshaller(Attribute.ENABLED_PROTOCOLS.getLocalName()))).build();
    public static final AttributeDefinition[] ATTRIBUTE_DEFINITIONS = new AttributeDefinition[]{PROTOCOL, ENABLED_CIPHER_SUITES, ENABLED_PROTOCOLS, KeystoreAttributes.KEYSTORE_PASSWORD, KeystoreAttributes.KEYSTORE_PATH, KeystoreAttributes.KEYSTORE_RELATIVE_TO, KeystoreAttributes.ALIAS, KeystoreAttributes.KEY_PASSWORD, KeystoreAttributes.KEYSTORE_PROVIDER, KeystoreAttributes.GENERATE_SELF_SIGNED_CERTIFICATE_HOST, KeystoreAttributes.KEY_PASSWORD_CREDENTIAL_REFERENCE, KeystoreAttributes.KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE};

    public SSLServerIdentityResourceDefinition() {
        super(PathElement.pathElement((String)"server-identity", (String)"ssl"), ControllerResolver.getDeprecatedResolver((String)"core.management.security-realm", (String[])new String[]{"core.management.security-realm.server-identity.ssl"}), (OperationStepHandler)new SecurityRealmChildAddHandler(false, false, ATTRIBUTE_DEFINITIONS), (OperationStepHandler)new SecurityRealmChildRemoveHandler(false), OperationEntry.Flag.RESTART_RESOURCE_SERVICES, OperationEntry.Flag.RESTART_RESOURCE_SERVICES);
        this.setDeprecated(ModelVersion.create((int)1, (int)7));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        SecurityRealmChildWriteAttributeHandler handler = new SecurityRealmChildWriteAttributeHandler(ATTRIBUTE_DEFINITIONS);
        handler.registerAttributes(resourceRegistration);
    }

    private static class StringListMarshaller
    extends AttributeMarshaller {
        private final String xmlAttributeName;

        private StringListMarshaller(String xmlAttributeName) {
            this.xmlAttributeName = xmlAttributeName;
        }

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            List list;
            if (resourceModel.hasDefined(attribute.getName()) && (list = resourceModel.get(attribute.getName()).asList()).size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (ModelNode child : list) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(child.asString());
                }
                writer.writeAttribute(this.xmlAttributeName, sb.toString());
            }
        }
    }
}

