/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.X509PeerCertificateChainEvidence;

public class ClientCertCallbackHandler
implements Service<CallbackHandlerService>,
CallbackHandlerService,
CallbackHandler {
    private static final String SERVICE_SUFFIX = "client_cert";

    ClientCertCallbackHandler() {
    }

    public CallbackHandlerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    @Override
    public AuthMechanism getPreferredMechanism() {
        return AuthMechanism.CLIENT_CERT;
    }

    @Override
    public Set<AuthMechanism> getSupplementaryMechanisms() {
        return Collections.emptySet();
    }

    @Override
    public Map<String, String> getConfigurationOptions() {
        return Collections.emptyMap();
    }

    @Override
    public boolean isReadyForHttpChallenge() {
        return false;
    }

    @Override
    public CallbackHandler getCallbackHandler(Map<String, Object> sharedState) {
        return this;
    }

    @Override
    public SecurityRealm getElytronSecurityRealm() {
        return new ClientCertSecurityRealm();
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback current : callbacks) {
            boolean authorized;
            AuthorizeCallback acb;
            if (current instanceof AuthorizeCallback) {
                acb = (AuthorizeCallback)current;
                authorized = acb.getAuthenticationID().equals(acb.getAuthorizationID());
                if (!authorized) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Checking 'AuthorizeCallback', authorized=false, authenticationID=%s, authorizationID=%s.", acb.getAuthenticationID(), acb.getAuthorizationID());
                }
            } else {
                throw new UnsupportedCallbackException(current);
            }
            acb.setAuthorized(authorized);
        }
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{ClientCertCallbackHandler.SERVICE_SUFFIX});
        }
    }

    private class ClientCertSecurityRealm
    implements SecurityRealm {
        private ClientCertSecurityRealm() {
        }

        public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
            return new ClientCertRealmIdentity(principal);
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return X509PeerCertificateChainEvidence.class.isAssignableFrom(evidenceType) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
        }

        private class ClientCertRealmIdentity
        implements RealmIdentity {
            private final Principal principal;

            ClientCertRealmIdentity(Principal principal) {
                this.principal = principal;
            }

            public Principal getRealmIdentityPrincipal() {
                return this.principal;
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
                return ClientCertSecurityRealm.this.getCredentialAcquireSupport(credentialType, algorithmName);
            }

            public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                return null;
            }

            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return ClientCertSecurityRealm.this.getEvidenceVerifySupport(evidenceType, algorithmName);
            }

            public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                return evidence instanceof X509PeerCertificateChainEvidence;
            }

            public boolean exists() throws RealmUnavailableException {
                return true;
            }
        }
    }
}

