/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.BootErrorCollector;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintUtilizationRegistry;
import org.jboss.as.controller.access.management.DelegatingConfigurableAuthorizer;
import org.jboss.as.controller.access.management.ManagementSecurityIdentitySupplier;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.domain.management.Environment;
import org.jboss.as.domain.management.LegacyConfigurationChangeResourceDefinition;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.access.AccessIdentityResourceDefinition;
import org.jboss.as.domain.management.audit.AccessAuditResourceDefinition;
import org.jboss.as.domain.management.audit.EnvironmentNameReader;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionResourceDefinition;
import org.jboss.as.domain.management.controller.ManagementControllerResourceDefinition;
import org.jboss.as.domain.management.security.SecurityRealmResourceDefinition;

public class CoreManagementResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"core-service", (String)"management");
    private final Environment environment;
    private final List<ResourceDefinition> interfaces;
    private final DelegatingConfigurableAuthorizer authorizer;
    private final ManagementSecurityIdentitySupplier securityIdentitySupplier;
    private final ManagedAuditLogger auditLogger;
    private final PathManagerService pathManager;
    private final EnvironmentNameReader environmentReader;
    private final BootErrorCollector bootErrorCollector;

    public static void registerDomainResource(Resource parent, AccessConstraintUtilizationRegistry registry) {
        Resource coreManagement = Resource.Factory.create();
        coreManagement.registerChild(AccessAuthorizationResourceDefinition.PATH_ELEMENT, AccessAuthorizationResourceDefinition.createResource(registry));
        parent.registerChild(PATH_ELEMENT, coreManagement);
    }

    private CoreManagementResourceDefinition(Environment environment, DelegatingConfigurableAuthorizer authorizer, ManagementSecurityIdentitySupplier securityIdentitySupplier, ManagedAuditLogger auditLogger, PathManagerService pathManager, EnvironmentNameReader environmentReader, List<ResourceDefinition> interfaces, BootErrorCollector bootErrorCollector) {
        super(PATH_ELEMENT, DomainManagementResolver.getResolver("core", "management"));
        this.environment = environment;
        this.authorizer = authorizer;
        this.securityIdentitySupplier = securityIdentitySupplier;
        this.interfaces = interfaces;
        this.auditLogger = auditLogger;
        this.pathManager = pathManager;
        this.environmentReader = environmentReader;
        this.bootErrorCollector = bootErrorCollector;
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        if (this.environment != Environment.DOMAIN) {
            resourceRegistration.registerSubModel(ManagementControllerResourceDefinition.INSTANCE);
            resourceRegistration.registerSubModel((ResourceDefinition)SecurityRealmResourceDefinition.INSTANCE);
            resourceRegistration.registerSubModel((ResourceDefinition)LdapConnectionResourceDefinition.newInstance());
            resourceRegistration.registerSubModel((ResourceDefinition)LegacyConfigurationChangeResourceDefinition.INSTANCE);
        }
        for (ResourceDefinition current : this.interfaces) {
            resourceRegistration.registerSubModel(current);
        }
        switch (this.environment) {
            case DOMAIN: {
                resourceRegistration.registerSubModel((ResourceDefinition)AccessAuthorizationResourceDefinition.forDomain(this.authorizer));
                resourceRegistration.registerSubModel(LegacyConfigurationChangeResourceDefinition.forDomain());
                break;
            }
            case DOMAIN_SERVER: {
                resourceRegistration.registerSubModel((ResourceDefinition)AccessAuthorizationResourceDefinition.forDomainServer(this.authorizer));
                break;
            }
            case STANDALONE_SERVER: {
                resourceRegistration.registerSubModel((ResourceDefinition)AccessAuthorizationResourceDefinition.forStandaloneServer(this.authorizer));
            }
        }
        if (this.environment != Environment.DOMAIN) {
            resourceRegistration.registerSubModel((ResourceDefinition)new AccessAuditResourceDefinition(this.auditLogger, this.pathManager, this.environmentReader));
        }
        resourceRegistration.registerSubModel(AccessIdentityResourceDefinition.newInstance(this.securityIdentitySupplier));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.bootErrorCollector != null) {
            resourceRegistration.registerOperationHandler((OperationDefinition)BootErrorCollector.ListBootErrorsHandler.DEFINITION, this.bootErrorCollector.getReadBootErrorsHandler());
        }
    }

    public static SimpleResourceDefinition forDomain(DelegatingConfigurableAuthorizer authorizer, ManagementSecurityIdentitySupplier securityIdentitySupplier) {
        List<ResourceDefinition> interfaces = Collections.emptyList();
        return new CoreManagementResourceDefinition(Environment.DOMAIN, authorizer, securityIdentitySupplier, null, null, null, interfaces, null);
    }

    public static SimpleResourceDefinition forDomainServer(DelegatingConfigurableAuthorizer authorizer, ManagementSecurityIdentitySupplier securityIdentitySupplier, ManagedAuditLogger auditLogger, PathManagerService pathManager, EnvironmentNameReader environmentReader, BootErrorCollector bootErrorCollector) {
        List<ResourceDefinition> interfaces = Collections.emptyList();
        return new CoreManagementResourceDefinition(Environment.DOMAIN_SERVER, authorizer, securityIdentitySupplier, auditLogger, pathManager, environmentReader, interfaces, bootErrorCollector);
    }

    public static SimpleResourceDefinition forHost(DelegatingConfigurableAuthorizer authorizer, ManagementSecurityIdentitySupplier securityIdentitySupplier, ManagedAuditLogger auditLogger, PathManagerService pathManager, EnvironmentNameReader environmentReader, BootErrorCollector bootErrorCollector, ResourceDefinition ... interfaces) {
        return new CoreManagementResourceDefinition(Environment.HOST_CONTROLLER, authorizer, securityIdentitySupplier, auditLogger, pathManager, environmentReader, Arrays.asList(interfaces), bootErrorCollector);
    }

    public static SimpleResourceDefinition forStandaloneServer(DelegatingConfigurableAuthorizer authorizer, ManagementSecurityIdentitySupplier securityIdentitySupplier, ManagedAuditLogger auditLogger, PathManagerService pathManager, EnvironmentNameReader environmentReader, BootErrorCollector bootErrorCollector, ResourceDefinition ... interfaces) {
        return new CoreManagementResourceDefinition(Environment.STANDALONE_SERVER, authorizer, securityIdentitySupplier, auditLogger, pathManager, environmentReader, Arrays.asList(interfaces), bootErrorCollector);
    }
}

