/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RenegotiationRequiredException;
import io.undertow.server.SSLSessionInfo;
import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.jboss.as.domain.http.server.logging.HttpServerLogger;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.SecurityRealm;

abstract class RealmReadinessHandler
implements HttpHandler {
    private final SecurityRealm securityRealm;
    private final HttpHandler next;

    RealmReadinessHandler(SecurityRealm securityRealm, HttpHandler next) {
        this.securityRealm = securityRealm;
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.securityRealm == null || this.securityRealm.isReadyForHttpChallenge() || this.clientCertPotentiallyPossible(exchange)) {
            this.next.handleRequest(exchange);
        } else {
            try {
                this.rejectRequest(exchange);
            }
            catch (IOException e) {
                HttpServerLogger.ROOT_LOGGER.error(e);
                exchange.setStatusCode(500);
                exchange.endExchange();
            }
        }
    }

    private boolean clientCertPotentiallyPossible(HttpServerExchange exchange) {
        if (!this.securityRealm.getSupportedAuthenticationMechanisms().contains(AuthMechanism.CLIENT_CERT)) {
            return false;
        }
        SSLSessionInfo session = exchange.getConnection().getSslSessionInfo();
        if (session != null) {
            try {
                return session.getPeerCertificates()[0] instanceof X509Certificate;
            }
            catch (RenegotiationRequiredException | SSLPeerUnverifiedException throwable) {
                // empty catch block
            }
        }
        return false;
    }

    abstract void rejectRequest(HttpServerExchange var1) throws Exception;
}

