/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PredicateHandler;
import io.undertow.server.handlers.RedirectHandler;
import io.undertow.server.handlers.SetHeaderHandler;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.domain.http.server.OperationParameter;
import org.jboss.as.domain.http.server.ResourceHandlerDefinition;
import org.jboss.dmr.ModelNode;
import org.xnio.IoUtils;

public class DomainUtil {
    private static final String NOCACHE_JS = ".nocache.js";
    private static final String INDEX_HTML = "index.html";
    private static final String APP_HTML = "App.html";
    private static final String DEFAULT_RESOURCE = "/index.html";

    public static void writeResponse(HttpServerExchange exchange, int status, ModelNode response, OperationParameter operationParameter) {
        exchange.setStatusCode(status);
        HeaderMap responseHeaders = exchange.getResponseHeaders();
        String contentType = operationParameter.isEncode() ? "application/dmr-encoded" : "application/json";
        responseHeaders.put(Headers.CONTENT_TYPE, contentType + "; charset=" + "utf-8");
        DomainUtil.writeCacheHeaders(exchange, status, operationParameter);
        if (operationParameter.isGet() && status == 200) {
            response = response.get("result");
        }
        try {
            byte[] data = DomainUtil.getResponseBytes(response, operationParameter);
            responseHeaders.put(Headers.CONTENT_LENGTH, (long)data.length);
            exchange.getResponseSender().send(ByteBuffer.wrap(data));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void writeResponse(final HttpServerExchange exchange, int status, final OperationResponse operationResponse, int streamIndex, OperationParameter operationParameter) {
        exchange.setStatusCode(status);
        HeaderMap responseHeaders = exchange.getResponseHeaders();
        final OperationResponse.StreamEntry entry = (OperationResponse.StreamEntry)operationResponse.getInputStreams().get(streamIndex);
        String mimeType = DomainUtil.determineMimeType(entry, exchange);
        responseHeaders.put(Headers.CONTENT_TYPE, mimeType + "; charset=" + "utf-8");
        DomainUtil.writeCacheHeaders(exchange, status, operationParameter);
        final Sender sender = exchange.getResponseSender();
        class ServeTask
        implements IoCallback,
        Runnable {
            private final byte[] buffer = new byte[1024];

            ServeTask() {
            }

            @Override
            public void run() {
                try {
                    InputStream inputStream = entry.getStream();
                    int res = inputStream.read(this.buffer);
                    if (res == -1) {
                        IoUtils.safeClose((Closeable)operationResponse);
                        return;
                    }
                    sender.send(ByteBuffer.wrap(this.buffer, 0, res), (IoCallback)this);
                }
                catch (IOException e) {
                    this.onException(exchange, sender, e);
                }
            }

            public void onComplete(HttpServerExchange exchange2, Sender sender2) {
                if (exchange2.isInIoThread()) {
                    exchange2.dispatch((Runnable)this);
                } else {
                    this.run();
                }
            }

            public void onException(HttpServerExchange exchange2, Sender sender2, IOException exception) {
                IoUtils.safeClose((Closeable)operationResponse);
                if (!exchange2.isResponseStarted()) {
                    exchange2.setStatusCode(500);
                }
            }
        }
        ServeTask serveTask = new ServeTask();
        if (exchange.isInIoThread()) {
            exchange.dispatch((Runnable)serveTask);
        } else {
            serveTask.run();
        }
    }

    private static String determineMimeType(OperationResponse.StreamEntry entry, HttpServerExchange exchange) {
        String entryType = entry.getMimeType();
        HeaderValues headerValues = exchange.getRequestHeaders().get(Headers.ACCEPT);
        if (headerValues == null || headerValues.size() == 0) {
            return entryType;
        }
        String wildCard = null;
        int slash = entryType.indexOf(47);
        if (slash > 0) {
            wildCard = entryType.substring(0, slash) + "/*";
        }
        for (String acceptable : headerValues) {
            if (!"*/*".equals(acceptable) && !acceptable.contains(entryType) && (wildCard == null || !acceptable.contains(wildCard))) continue;
            return entryType;
        }
        return "application/octet-stream";
    }

    private static byte[] getResponseBytes(ModelNode modelNode, OperationParameter operationParameter) throws IOException {
        if (operationParameter.isEncode()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedOutputStream out = new BufferedOutputStream(baos);
            modelNode.writeBase64((OutputStream)out);
            out.flush();
            return baos.toByteArray();
        }
        String json = modelNode.toJSONString(!operationParameter.isPretty());
        return json.getBytes(StandardCharsets.UTF_8);
    }

    public static void writeCacheHeaders(HttpServerExchange exchange, int status, OperationParameter operationParameter) {
        HeaderMap responseHeaders = exchange.getResponseHeaders();
        if (operationParameter.getMaxAge() > 0 && status != 304) {
            responseHeaders.put(Headers.CACHE_CONTROL, "max-age=" + operationParameter.getMaxAge() + ", private, must-revalidate");
        }
        if (operationParameter.getEtag() != null) {
            responseHeaders.put(Headers.ETAG, operationParameter.getEtag().toString());
        }
    }

    public static String constructUrl(HttpServerExchange exchange, String path) {
        HeaderMap headers = exchange.getRequestHeaders();
        String host = headers.getFirst(Headers.HOST);
        String protocol = exchange.getConnection().getSslSessionInfo() != null ? "https" : "http";
        return protocol + "://" + host + path;
    }

    static ResourceHandlerDefinition createStaticContentHandler(ResourceManager resource, String context) {
        ResourceHandler handler = new ResourceHandler(resource).setCacheTime(Integer.valueOf(2678400)).setAllowed(Predicates.not((Predicate)Predicates.path((String)"META-INF"))).setResourceManager(resource).setDirectoryListingEnabled(false).setCachable(Predicates.not((Predicate)Predicates.suffixes((String[])new String[]{NOCACHE_JS, APP_HTML, INDEX_HTML})));
        SetHeaderHandler frameHandler = new SetHeaderHandler((HttpHandler)handler, "X-Frame-Options", "SAMEORIGIN");
        PredicateHandler predicateHandler = new PredicateHandler(Predicates.path((String)"/"), (HttpHandler)new RedirectHandler(context + DEFAULT_RESOURCE), (HttpHandler)frameHandler);
        return new ResourceHandlerDefinition(context, DEFAULT_RESOURCE, (HttpHandler)predicateHandler);
    }
}

