/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.SinglePortConfidentialityHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RenegotiationRequiredException;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.ChannelUpgradeHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.SetHeaderHandler;
import io.undertow.server.handlers.cache.CacheHandler;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.error.SimpleErrorPageHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.protocol.http.HttpOpenListener;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.domain.http.server.ConsoleMode;
import org.jboss.as.domain.http.server.DomainApiCheckHandler;
import org.jboss.as.domain.http.server.DomainUtil;
import org.jboss.as.domain.http.server.ErrorContextHandler;
import org.jboss.as.domain.http.server.InExecutorHandler;
import org.jboss.as.domain.http.server.ManagementHttpRequestHandler;
import org.jboss.as.domain.http.server.ManagementHttpRequestProcessor;
import org.jboss.as.domain.http.server.ManagementRootConsoleRedirectHandler;
import org.jboss.as.domain.http.server.ResourceHandlerDefinition;
import org.jboss.as.domain.http.server.cors.CorsHttpHandler;
import org.jboss.as.domain.http.server.logging.HttpServerLogger;
import org.jboss.as.domain.http.server.security.DmrFailureReadinessHandler;
import org.jboss.as.domain.http.server.security.ElytronIdentityHandler;
import org.jboss.as.domain.http.server.security.LogoutHandler;
import org.jboss.as.domain.http.server.security.RedirectReadinessHandler;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.common.Assert;
import org.wildfly.elytron.web.undertow.server.ElytronContextAssociationHandler;
import org.wildfly.elytron.web.undertow.server.ElytronHttpExchange;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.SslClientAuthMode;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.ssl.SslConnection;

public class ManagementHttpServer {
    private static final Map<Pattern, Charset> USER_AGENT_CHARSET_MAP = ManagementHttpServer.generateCharsetMap();
    private static final Set<String> RESERVED_CONTEXTS;
    private final HttpOpenListener openListener;
    private final InetSocketAddress httpAddress;
    private final InetSocketAddress secureAddress;
    private final XnioWorker worker;
    private volatile AcceptingChannel<StreamConnection> normalServer;
    private volatile AcceptingChannel<SslConnection> secureServer;
    private final SSLContext sslContext;
    private final SslClientAuthMode sslClientAuthMode;
    private final ExtensionHandlers extensionHandlers;

    private ManagementHttpServer(HttpOpenListener openListener, InetSocketAddress httpAddress, InetSocketAddress secureAddress, SSLContext sslContext, SslClientAuthMode sslClientAuthMode, XnioWorker worker, ExtensionHandlers extensionExtensionHandlers) {
        this.openListener = openListener;
        this.httpAddress = httpAddress;
        this.secureAddress = secureAddress;
        this.sslContext = sslContext;
        this.sslClientAuthMode = sslClientAuthMode;
        this.worker = worker;
        this.extensionHandlers = extensionExtensionHandlers;
    }

    public void start() {
        try {
            OptionMap.Builder serverOptionsBuilder = OptionMap.builder().set(Options.TCP_NODELAY, true).set(Options.REUSE_ADDRESSES, true);
            ChannelListener acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)this.openListener);
            if (this.httpAddress != null) {
                this.normalServer = this.worker.createStreamConnectionServer((SocketAddress)this.httpAddress, acceptListener, serverOptionsBuilder.getMap());
                this.normalServer.resumeAccepts();
            }
            if (this.secureAddress != null) {
                if (this.sslClientAuthMode != null) {
                    serverOptionsBuilder.set(Options.SSL_CLIENT_AUTH_MODE, (Object)this.sslClientAuthMode);
                }
                OptionMap secureOptions = serverOptionsBuilder.getMap();
                UndertowXnioSsl xnioSsl = new UndertowXnioSsl(this.worker.getXnio(), secureOptions, this.sslContext);
                this.secureServer = xnioSsl.createSslConnectionServer(this.worker, this.secureAddress, acceptListener, secureOptions);
                this.secureServer.resumeAccepts();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        IoUtils.safeClose(this.normalServer);
        IoUtils.safeClose(this.secureServer);
    }

    public void addStaticContext(String contextName, ResourceManager resourceManager) {
        Assert.checkNotNullParam((String)"contextName", (Object)contextName);
        Assert.checkNotNullParam((String)"resourceManager", (Object)resourceManager);
        String context = ManagementHttpServer.fixPath(contextName);
        if (this.extensionHandlers.reservedContexts.contains(context) || !this.extensionHandlers.extensionContexts.add(context)) {
            throw new IllegalStateException();
        }
        ResourceHandlerDefinition def = DomainUtil.createStaticContentHandler(resourceManager, context);
        RedirectReadinessHandler readinessHandler = new RedirectReadinessHandler(this.extensionHandlers.readyFunction, def.getHandler(), "/error");
        this.extensionHandlers.extensionPathHandler.addPrefixPath(context, (HttpHandler)readinessHandler);
    }

    public void addManagementGetRemapContext(String contextName, PathRemapper remapper) {
        Assert.checkNotNullParam((String)"contextName", (Object)contextName);
        String context = ManagementHttpServer.fixPath(contextName);
        if (this.extensionHandlers.reservedContexts.contains(context) || !this.extensionHandlers.extensionContexts.add(context)) {
            throw new IllegalStateException();
        }
        RemapHandler remapHandler = new RemapHandler(remapper, this.extensionHandlers.managementHandler);
        this.extensionHandlers.extensionPathHandler.addPrefixPath(context, (HttpHandler)remapHandler);
    }

    public void removeContext(String contextName) {
        Assert.checkNotNullParam((String)"contextName", (Object)contextName);
        String context = ManagementHttpServer.fixPath(contextName);
        if (this.extensionHandlers.reservedContexts.contains(context) || !this.extensionHandlers.extensionContexts.contains(context)) {
            throw new IllegalStateException();
        }
        this.extensionHandlers.extensionContexts.remove(context);
        this.extensionHandlers.extensionPathHandler.removePrefixPath(context);
    }

    private static String fixPath(String contextName) {
        Assert.checkNotEmptyParam((String)"contextName", (String)contextName);
        return '/' == contextName.charAt(0) ? contextName : "/" + contextName;
    }

    private static SSLContext getSSLContext(Builder builder) {
        if (builder.sslContext != null) {
            return builder.sslContext;
        }
        if (builder.securityRealm != null) {
            return builder.securityRealm.getSSLContext();
        }
        throw HttpServerLogger.ROOT_LOGGER.noRealmOrSSLContext();
    }

    private static SslClientAuthMode getSslClientAuthMode(Builder builder) {
        if (builder.sslContext != null) {
            return null;
        }
        if (builder.securityRealm != null) {
            Set supportedMechanisms = builder.securityRealm.getSupportedAuthenticationMechanisms();
            if (supportedMechanisms.contains(AuthMechanism.CLIENT_CERT)) {
                if (supportedMechanisms.contains(AuthMechanism.DIGEST) || supportedMechanisms.contains(AuthMechanism.PLAIN)) {
                    return SslClientAuthMode.REQUESTED;
                }
                return SslClientAuthMode.REQUIRED;
            }
            return null;
        }
        throw HttpServerLogger.ROOT_LOGGER.noRealmOrSSLContext();
    }

    private static ManagementHttpServer create(Builder builder) {
        boolean redirectSupported;
        SSLContext sslContext = null;
        SslClientAuthMode sslClientAuthMode = null;
        if (builder.secureBindAddress != null) {
            sslContext = ManagementHttpServer.getSSLContext(builder);
            if (sslContext == null) {
                throw HttpServerLogger.ROOT_LOGGER.sslRequestedNoSslContext();
            }
            sslClientAuthMode = ManagementHttpServer.getSslClientAuthMode(builder);
        }
        HttpOpenListener openListener = new HttpOpenListener((Pool)new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 4096, 40960));
        int secureRedirectPort = builder.secureBindAddress != null ? builder.secureBindAddress.getPort() : -1;
        boolean bl = redirectSupported = builder.bindAddress == null || builder.secureBindAddress == null || builder.bindAddress.getAddress().equals(builder.secureBindAddress.getAddress());
        if (!redirectSupported && secureRedirectPort > 0) {
            HttpServerLogger.ROOT_LOGGER.httpsRedirectNotSupported(builder.bindAddress.getAddress(), builder.secureBindAddress.getAddress());
            secureRedirectPort = -1;
        }
        ExtensionHandlers extensionHandlers = ManagementHttpServer.setupOpenListener(openListener, secureRedirectPort, builder);
        return new ManagementHttpServer(openListener, builder.bindAddress, builder.secureBindAddress, sslContext, sslClientAuthMode, builder.worker, extensionHandlers);
    }

    private static Function<HttpServerExchange, Boolean> createReadyFunction(Builder builder) {
        if (builder.securityRealm != null) {
            SecurityRealm securityRealm = builder.securityRealm;
            return e -> securityRealm.isReadyForHttpChallenge() || ManagementHttpServer.clientCertPotentiallyPossible(securityRealm, e);
        }
        return e -> Boolean.TRUE;
    }

    private static boolean clientCertPotentiallyPossible(SecurityRealm securityRealm, HttpServerExchange exchange) {
        if (!securityRealm.getSupportedAuthenticationMechanisms().contains(AuthMechanism.CLIENT_CERT)) {
            return false;
        }
        SSLSessionInfo session = exchange.getConnection().getSslSessionInfo();
        if (session != null) {
            try {
                return session.getPeerCertificates()[0] instanceof X509Certificate;
            }
            catch (RenegotiationRequiredException | SSLPeerUnverifiedException throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static void addRedirectRedinessHandler(PathHandler pathHandler, ResourceHandlerDefinition consoleHandler, Function<HttpServerExchange, Boolean> readyFunction) {
        RedirectReadinessHandler readinessHandler = new RedirectReadinessHandler(readyFunction, consoleHandler.getHandler(), "/error");
        pathHandler.addPrefixPath(consoleHandler.getContext(), (HttpHandler)readinessHandler);
    }

    private static HttpHandler addDmrRedinessHandler(PathHandler pathHandler, HttpHandler domainApiHandler, Function<HttpServerExchange, Boolean> readinessFunction) {
        HttpHandler readinessHandler = ManagementHttpServer.wrapXFrameOptions(new DmrFailureReadinessHandler(readinessFunction, domainApiHandler, "/error"));
        pathHandler.addPrefixPath("/management", readinessHandler);
        pathHandler.addExactPath("/management-upload", readinessHandler);
        return readinessHandler;
    }

    private static void addLogoutHandler(PathHandler pathHandler, Builder builder) {
        if (builder.securityRealm != null) {
            pathHandler.addPrefixPath("/logout", ManagementHttpServer.wrapXFrameOptions(new LogoutHandler(builder.securityRealm.getName())));
        }
    }

    private static ExtensionHandlers setupOpenListener(HttpOpenListener listener, int secureRedirectPort, Builder builder) {
        PathHandler pathHandler;
        CanonicalPathHandler canonicalPathHandler = new CanonicalPathHandler();
        ManagementHttpRequestHandler managementHttpRequestHandler = new ManagementHttpRequestHandler(builder.managementHttpRequestProcessor, (HttpHandler)canonicalPathHandler);
        CorsHttpHandler corsHandler = new CorsHttpHandler(managementHttpRequestHandler, builder.allowedOrigins);
        listener.setRootHandler((HttpHandler)new UpgradeFixHandler(corsHandler));
        PathHandler current = pathHandler = new PathHandler();
        if (builder.upgradeHandler != null) {
            builder.upgradeHandler.setNonUpgradeHandler((HttpHandler)current);
            current = builder.upgradeHandler;
        }
        if (secureRedirectPort > 0) {
            current = new SinglePortConfidentialityHandler((HttpHandler)current, secureRedirectPort);
        }
        current = new CacheHandler(new DirectBufferCache(1024, 10240, 1024000, BufferAllocator.BYTE_BUFFER_ALLOCATOR), (HttpHandler)current);
        current = new SimpleErrorPageHandler((HttpHandler)current);
        canonicalPathHandler.setNext((HttpHandler)current);
        ResourceHandlerDefinition consoleHandler = null;
        try {
            consoleHandler = builder.consoleMode.createConsoleHandler(builder.consoleSlot);
        }
        catch (ModuleLoadException e) {
            HttpServerLogger.ROOT_LOGGER.consoleModuleNotFound(builder.consoleSlot == null ? "main" : builder.consoleSlot);
        }
        try {
            pathHandler.addPrefixPath("/error", ErrorContextHandler.createErrorContext(builder.consoleSlot));
        }
        catch (ModuleLoadException e) {
            HttpServerLogger.ROOT_LOGGER.errorContextModuleNotFound(builder.consoleSlot == null ? "main" : builder.consoleSlot);
        }
        ManagementRootConsoleRedirectHandler rootConsoleRedirectHandler = new ManagementRootConsoleRedirectHandler(consoleHandler);
        HttpHandler domainApiHandler = InExecutorHandler.wrap(builder.executor, ManagementHttpServer.associateIdentity(new DomainApiCheckHandler(builder.modelController, builder.controlledProcessStateService, builder.allowedOrigins), builder));
        Function<HttpServerExchange, Boolean> readyFunction = ManagementHttpServer.createReadyFunction(builder);
        pathHandler.addPrefixPath("/", (HttpHandler)rootConsoleRedirectHandler);
        if (consoleHandler != null) {
            ManagementHttpServer.addRedirectRedinessHandler(pathHandler, consoleHandler, readyFunction);
        }
        domainApiHandler = ManagementHttpServer.secureDomainAccess(domainApiHandler, builder);
        HttpHandler readinessHandler = ManagementHttpServer.addDmrRedinessHandler(pathHandler, domainApiHandler, readyFunction);
        ManagementHttpServer.addLogoutHandler(pathHandler, builder);
        return new ExtensionHandlers(pathHandler, readinessHandler, readyFunction, consoleHandler);
    }

    private static HttpHandler associateIdentity(HttpHandler domainHandler, Builder builder) {
        domainHandler = new ElytronIdentityHandler(domainHandler);
        return new BlockingHandler(domainHandler);
    }

    private static HttpHandler secureDomainAccess(HttpHandler domainHandler, Builder builder) {
        HttpAuthenticationFactory httpAuthenticationFactory;
        if (builder.httpAuthenticationFactory != null) {
            return ManagementHttpServer.secureDomainAccess(domainHandler, builder.httpAuthenticationFactory);
        }
        if (builder.securityRealm != null && (httpAuthenticationFactory = builder.securityRealm.getHttpAuthenticationFactory()) != null) {
            return ManagementHttpServer.secureDomainAccess(domainHandler, httpAuthenticationFactory);
        }
        return domainHandler;
    }

    private static Map<Pattern, Charset> generateCharsetMap() {
        HashMap<Pattern, Charset> charsetMap = new HashMap<Pattern, Charset>();
        charsetMap.put(Pattern.compile("Mozilla/5\\.0 \\(.*\\) Gecko/.* Firefox/.*"), StandardCharsets.ISO_8859_1);
        charsetMap.put(Pattern.compile("(?!.*OPR)(?!.*Chrome)Mozilla/5\\.0 \\(.*\\).* Safari/.*"), StandardCharsets.ISO_8859_1);
        charsetMap.put(Pattern.compile("Mozilla/5\\.0 \\(.*; Trident/.*; rv:.*\\).*"), StandardCharsets.ISO_8859_1);
        charsetMap.put(Pattern.compile("Mozilla/5\\.0 \\(.* MSIE.* Trident/.*\\)"), StandardCharsets.ISO_8859_1);
        return Collections.unmodifiableMap(charsetMap);
    }

    private static HttpHandler secureDomainAccess(HttpHandler domainHandler, HttpAuthenticationFactory httpAuthenticationFactory) {
        domainHandler = new AuthenticationCallHandler(domainHandler);
        domainHandler = new AuthenticationConstraintHandler(domainHandler);
        Supplier<List> mechanismSupplier = () -> httpAuthenticationFactory.getMechanismNames().stream().map(s -> {
            try {
                return (HttpServerAuthenticationMechanism)httpAuthenticationFactory.createMechanism(s);
            }
            catch (Exception e) {
                return null;
            }
        }).collect(Collectors.toList());
        domainHandler = ElytronContextAssociationHandler.builder().setNext(domainHandler).setMechanismSupplier(mechanismSupplier).setHttpExchangeSupplier(h -> new ElytronHttpExchange((HttpServerExchange)h, (HttpServerExchange)h){
            final /* synthetic */ HttpServerExchange val$h;
            {
                this.val$h = httpServerExchange;
                super(x0);
            }

            public void authenticationComplete(SecurityIdentity securityIdentity, String mechanismName) {
                super.authenticationComplete(securityIdentity, mechanismName);
                this.val$h.putAttachment(ElytronIdentityHandler.IDENTITY_KEY, (Object)securityIdentity);
            }
        }).build();
        return domainHandler;
    }

    private static HttpHandler wrapXFrameOptions(HttpHandler toWrap) {
        return new SetHeaderHandler(toWrap, "X-Frame-Options", "SAMEORIGIN");
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("/management");
        set.add("/management-upload");
        set.add("/logout");
        set.add("/error");
        RESERVED_CONTEXTS = Collections.unmodifiableSet(set);
    }

    private static class RemapHandler
    implements HttpHandler {
        private final PathRemapper remapper;
        private final HttpHandler next;

        private RemapHandler(PathRemapper remapper, HttpHandler next) {
            this.remapper = remapper;
            this.next = next;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            if (Methods.POST.equals(exchange.getRequestMethod())) {
                ResponseCodeHandler.HANDLE_405.handleRequest(exchange);
                return;
            }
            String origReqPath = exchange.getRelativePath();
            String remapped = this.remapper.remapPath(origReqPath);
            if (remapped == null) {
                ResponseCodeHandler.HANDLE_404.handleRequest(exchange);
                return;
            }
            exchange.setRelativePath(remapped);
            this.next.handleRequest(exchange);
        }
    }

    private static class UpgradeFixHandler
    implements HttpHandler {
        final HttpHandler next;

        private UpgradeFixHandler(HttpHandler next) {
            this.next = next;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            if (exchange.getRequestHeaders().contains(Headers.UPGRADE)) {
                exchange.addResponseWrapper((factory, ex) -> {
                    StreamSinkConduit ret = (StreamSinkConduit)factory.create();
                    if (exchange.getResponseHeaders().contains(Headers.UPGRADE)) {
                        exchange.getResponseHeaders().add(Headers.CONTENT_LENGTH, "0");
                    }
                    return ret;
                });
            }
            this.next.handleRequest(exchange);
        }
    }

    public static class Builder {
        private boolean built = false;
        private InetSocketAddress bindAddress;
        private InetSocketAddress secureBindAddress;
        private ModelController modelController;
        private SecurityRealm securityRealm;
        private SSLContext sslContext;
        private HttpAuthenticationFactory httpAuthenticationFactory;
        private ControlledProcessStateService controlledProcessStateService;
        private ConsoleMode consoleMode;
        private String consoleSlot;
        private ChannelUpgradeHandler upgradeHandler;
        private ManagementHttpRequestProcessor managementHttpRequestProcessor;
        private Collection<String> allowedOrigins;
        private XnioWorker worker;
        private Executor executor;

        private Builder() {
        }

        public Builder setBindAddress(InetSocketAddress bindAddress) {
            this.assertNotBuilt();
            this.bindAddress = bindAddress;
            return this;
        }

        public Builder setSecureBindAddress(InetSocketAddress secureBindAddress) {
            this.assertNotBuilt();
            this.secureBindAddress = secureBindAddress;
            return this;
        }

        public Builder setModelController(ModelController modelController) {
            this.assertNotBuilt();
            this.modelController = modelController;
            return this;
        }

        public Builder setSecurityRealm(SecurityRealm securityRealm) {
            this.assertNotBuilt();
            this.securityRealm = securityRealm;
            return this;
        }

        public Builder setSSLContext(SSLContext sslContext) {
            this.assertNotBuilt();
            this.sslContext = sslContext;
            return this;
        }

        public Builder setHttpAuthenticationFactory(HttpAuthenticationFactory httpAuthenticationFactory) {
            this.assertNotBuilt();
            this.httpAuthenticationFactory = httpAuthenticationFactory;
            return this;
        }

        public Builder setControlledProcessStateService(ControlledProcessStateService controlledProcessStateService) {
            this.assertNotBuilt();
            this.controlledProcessStateService = controlledProcessStateService;
            return this;
        }

        public Builder setConsoleMode(ConsoleMode consoleMode) {
            this.assertNotBuilt();
            this.consoleMode = consoleMode;
            return this;
        }

        public Builder setConsoleSlot(String consoleSlot) {
            this.assertNotBuilt();
            this.consoleSlot = consoleSlot;
            return this;
        }

        public Builder setChannelUpgradeHandler(ChannelUpgradeHandler upgradeHandler) {
            this.assertNotBuilt();
            this.upgradeHandler = upgradeHandler;
            return this;
        }

        public Builder setManagementHttpRequestProcessor(ManagementHttpRequestProcessor managementHttpRequestProcessor) {
            this.assertNotBuilt();
            this.managementHttpRequestProcessor = managementHttpRequestProcessor;
            return this;
        }

        public Builder setAllowedOrigins(Collection<String> allowedOrigins) {
            this.assertNotBuilt();
            this.allowedOrigins = allowedOrigins;
            return this;
        }

        public Builder setWorker(XnioWorker worker) {
            this.assertNotBuilt();
            this.worker = worker;
            return this;
        }

        public Builder setExecutor(Executor executor) {
            this.assertNotBuilt();
            this.executor = executor;
            return this;
        }

        public ManagementHttpServer build() {
            this.assertNotBuilt();
            ManagementHttpServer managementHttpServer = ManagementHttpServer.create(this);
            this.built = true;
            return managementHttpServer;
        }

        private void assertNotBuilt() {
            if (this.built) {
                throw HttpServerLogger.ROOT_LOGGER.managementHttpServerAlreadyBuild();
            }
        }
    }

    private static class ExtensionHandlers {
        private final PathHandler extensionPathHandler;
        private final HttpHandler managementHandler;
        private final Function<HttpServerExchange, Boolean> readyFunction;
        private final Set<String> reservedContexts;
        private final Set<String> extensionContexts = new HashSet<String>();

        private ExtensionHandlers(PathHandler extensionPathHandler, HttpHandler managementHandler, Function<HttpServerExchange, Boolean> readyFunction, ResourceHandlerDefinition consoleHandler) {
            this.extensionPathHandler = extensionPathHandler;
            this.managementHandler = managementHandler;
            this.readyFunction = readyFunction;
            if (consoleHandler == null) {
                this.reservedContexts = RESERVED_CONTEXTS;
            } else {
                HashSet<String> set = new HashSet<String>(RESERVED_CONTEXTS);
                set.add(consoleHandler.getContext());
                this.reservedContexts = Collections.unmodifiableSet(set);
            }
        }
    }

    public static interface PathRemapper {
        public String remapPath(String var1);
    }
}

