/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.function.Function;
import org.jboss.as.domain.http.server.Common;
import org.jboss.as.domain.http.server.OperatingSystemDetector;
import org.jboss.as.domain.http.server.logging.HttpServerLogger;
import org.jboss.as.domain.http.server.security.RealmReadinessHandler;

public class ServerErrorReadinessHandler
extends RealmReadinessHandler {
    private final String contextName;

    public ServerErrorReadinessHandler(String contextName, Function<HttpServerExchange, Boolean> readyFunction, HttpHandler next) {
        super(readyFunction, next);
        this.contextName = contextName;
    }

    @Override
    void rejectRequest(HttpServerExchange exchange) {
        String scriptFile = OperatingSystemDetector.INSTANCE.isWindows() ? "add-user.bat" : "add-user.sh";
        String message = HttpServerLogger.ROOT_LOGGER.realmNotReadyForSecuredManagementHandler(scriptFile);
        Common.sendPlainTextError(exchange, message, 500);
    }
}

