/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.ETag;
import io.undertow.util.ETagUtils;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HexConverter;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.as.domain.http.server.Common;
import org.jboss.as.domain.http.server.DomainUtil;
import org.jboss.as.domain.http.server.OperationParameter;
import org.jboss.as.domain.http.server.logging.HttpServerLogger;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;
import org.xnio.IoUtils;
import org.xnio.streams.ChannelInputStream;

class DomainApiHandler
implements HttpHandler {
    private static final String JSON_PRETTY = "json.pretty";
    private static final String USE_STREAM_AS_RESPONSE = "useStreamAsResponse";
    private static final HttpString USE_STREAM_AS_RESPONSE_HEADER = new HttpString("org.wildfly.useStreamAsResponse");
    private final ModelController modelController;

    DomainApiHandler(ModelController modelController) {
        this.modelController = modelController;
    }

    public void handleRequest(final HttpServerExchange exchange) {
        OperationResponse response;
        boolean cachable;
        ModelNode dmr;
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        boolean get = exchange.getRequestMethod().equals(Methods.GET);
        final boolean encode = "application/dmr-encoded".equals(requestHeaders.getFirst(Headers.ACCEPT)) || "application/dmr-encoded".equals(requestHeaders.getFirst(Headers.CONTENT_TYPE));
        final OperationParameter.Builder operationParameterBuilder = new OperationParameter.Builder(get).encode(encode);
        final int streamIndex = DomainApiHandler.getStreamIndex(exchange, requestHeaders);
        try {
            if (get) {
                GetOperation operation = this.getOperation(exchange);
                operationParameterBuilder.maxAge(operation.getMaxAge());
                dmr = this.convertGetRequest(exchange, operation);
                cachable = operation.getMaxAge() > 0;
            } else {
                dmr = this.convertPostRequest(exchange, encode);
                cachable = false;
            }
            boolean pretty = false;
            if (dmr.hasDefined(JSON_PRETTY)) {
                String jsonPretty = dmr.get(JSON_PRETTY).asString();
                pretty = jsonPretty.equals("true") || jsonPretty.equals("1");
            }
            operationParameterBuilder.pretty(pretty);
        }
        catch (Exception e) {
            HttpServerLogger.ROOT_LOGGER.debugf("Unable to construct ModelNode '%s'", e.getMessage());
            Common.sendError(exchange, false, e.toString());
            return;
        }
        final ResponseCallback callback = new ResponseCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void doSendResponse(OperationResponse response) {
                boolean closeResponse = true;
                try {
                    ModelNode responseNode = response.getResponseNode();
                    if (responseNode.hasDefined("outcome") && "failed".equals(responseNode.get("outcome").asString())) {
                        Common.sendError(exchange, encode, responseNode);
                        return;
                    }
                    if (streamIndex < 0) {
                        DomainUtil.writeResponse(exchange, 200, responseNode, operationParameterBuilder.build());
                    } else {
                        List streamEntries = response.getInputStreams();
                        if (streamIndex >= streamEntries.size()) {
                            Common.sendError(exchange, encode, new ModelNode(HttpServerLogger.ROOT_LOGGER.invalidUseStreamAsResponseIndex(streamIndex, streamEntries.size())), 400);
                        } else {
                            closeResponse = false;
                            DomainUtil.writeResponse(exchange, 200, response, streamIndex, operationParameterBuilder.build());
                        }
                    }
                }
                finally {
                    if (closeResponse) {
                        StreamUtils.safeClose((Closeable)response);
                    }
                }
            }
        };
        boolean sendPreparedResponse = this.sendPreparedResponse(dmr);
        ModelController.OperationTransactionControl control = sendPreparedResponse ? new ModelController.OperationTransactionControl(){

            public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                transaction.commit();
                result.get("outcome").set("success");
                result.get("result");
                callback.sendResponse(OperationResponse.Factory.createSimple((ModelNode)result));
            }
        } : ModelController.OperationTransactionControl.COMMIT;
        try {
            ModelNode headers = dmr.get("operation-headers");
            headers.get("access-mechanism").set(AccessMechanism.HTTP.toString());
            headers.get("caller-type").set("user");
            if (headers.hasDefined("domain-uuid")) {
                headers.remove("domain-uuid");
            }
            response = this.modelController.execute(new OperationBuilder(dmr).build(), OperationMessageHandler.logging, control);
            if (cachable && streamIndex > -1) {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(response.toString().getBytes());
                ETag etag = new ETag(false, HexConverter.convertToHexString((byte[])md.digest()));
                operationParameterBuilder.etag(etag);
                if (!ETagUtils.handleIfNoneMatch((HttpServerExchange)exchange, (ETag)etag, (boolean)false)) {
                    exchange.setStatusCode(304);
                    DomainUtil.writeCacheHeaders(exchange, 304, operationParameterBuilder.build());
                    exchange.endExchange();
                    return;
                }
            }
        }
        catch (Throwable t) {
            HttpServerLogger.ROOT_LOGGER.modelRequestError(t);
            Common.sendError(exchange, encode, t.getLocalizedMessage());
            return;
        }
        callback.sendResponse(response);
    }

    private static int getStreamIndex(HttpServerExchange exchange, HeaderMap requestHeaders) {
        int result = DomainApiHandler.getStreamIndex((Deque<String>)requestHeaders.get(USE_STREAM_AS_RESPONSE_HEADER));
        if (result == -1) {
            Map queryParams = exchange.getQueryParameters();
            result = DomainApiHandler.getStreamIndex((Deque)queryParams.get(USE_STREAM_AS_RESPONSE));
        }
        return result;
    }

    private static int getStreamIndex(Deque<String> holder) {
        int result = holder != null ? (holder.size() > 0 && holder.getFirst().length() > 0 ? Integer.parseInt(holder.getFirst()) : 0) : -1;
        return result;
    }

    private GetOperation getOperation(HttpServerExchange exchange) {
        Map queryParameters = exchange.getQueryParameters();
        GetOperation operation = null;
        Deque parameter = (Deque)queryParameters.get("operation");
        if (parameter != null) {
            String value = (String)parameter.getFirst();
            try {
                operation = GetOperation.valueOf(value.toUpperCase(Locale.ENGLISH).replace('-', '_'));
                value = operation.realOperation();
            }
            catch (Exception e) {
                throw HttpServerLogger.ROOT_LOGGER.invalidOperation(e, value);
            }
        }
        if (operation == null) {
            operation = GetOperation.RESOURCE;
        }
        return operation;
    }

    private ModelNode convertGetRequest(HttpServerExchange exchange, GetOperation operation) {
        ArrayList<String> pathSegments = this.decodePath(exchange.getRequestPath());
        Map queryParameters = exchange.getQueryParameters();
        ModelNode dmr = new ModelNode();
        for (Map.Entry entry : queryParameters.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)((Deque)entry.getValue()).getFirst();
            ModelNode valueNode = null;
            if (key.startsWith("operation-header-")) {
                String header = key.substring("operation-header-".length());
                if (!(header.equals("sync-dropped-for-readd") || header.equals("execute-for-coordinator") || header.equals("domain-uuid"))) {
                    valueNode = dmr.get(new String[]{"operation-headers", header});
                }
            } else {
                valueNode = dmr.get(key);
            }
            if (valueNode == null) continue;
            valueNode.set(!value.equals("") ? value : "true");
        }
        dmr.get("operation").set(operation.realOperation);
        ModelNode list = dmr.get("address").setEmptyList();
        for (int i = 1; i < pathSegments.size() - 1; i += 2) {
            list.add(pathSegments.get(i), pathSegments.get(i + 1));
        }
        return dmr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelNode convertPostRequest(HttpServerExchange exchange, boolean encode) throws IOException {
        ChannelInputStream in = new ChannelInputStream(exchange.getRequestChannel());
        try {
            ModelNode modelNode = encode ? ModelNode.fromBase64((InputStream)in) : ModelNode.fromJSONStream((InputStream)in);
            return modelNode;
        }
        finally {
            IoUtils.safeClose((Closeable)in);
        }
    }

    private ArrayList<String> decodePath(String path) {
        int j;
        if (path == null) {
            throw new IllegalArgumentException();
        }
        int i = path.charAt(0) == '/' ? 1 : 0;
        ArrayList<String> segments = new ArrayList<String>();
        do {
            if ((j = path.indexOf(47, i)) == -1) {
                j = path.length();
            }
            segments.add(this.unescape(path.substring(i, j)));
        } while ((i = j + 1) < path.length());
        return segments;
    }

    private String unescape(String string) {
        try {
            return URLDecoder.decode(string, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean sendPreparedResponse(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String op = operation.get("operation").asString();
        int size = address.size();
        if (size == 0) {
            if (op.equals("reload")) {
                return true;
            }
            if (op.equals("composite")) {
                return false;
            }
            return false;
        }
        if (size == 1 && address.getLastElement().getKey().equals("host")) {
            return op.equals("reload");
        }
        return false;
    }

    private static abstract class ResponseCallback {
        private volatile boolean complete;

        private ResponseCallback() {
        }

        void sendResponse(OperationResponse response) {
            if (this.complete) {
                return;
            }
            this.complete = true;
            this.doSendResponse(response);
        }

        abstract void doSendResponse(OperationResponse var1);
    }

    static enum GetOperation {
        RESOURCE("read-resource", 0),
        ATTRIBUTE("read-attribute", 0),
        RESOURCE_DESCRIPTION("read-resource-description", 604800),
        SNAPSHOTS("list-snapshots", 0),
        OPERATION_DESCRIPTION("read-operation-description", 604800),
        OPERATION_NAMES("read-operation-names", 0);

        private String realOperation;
        private int maxAge;

        private GetOperation(String realOperation, int maxAge) {
            this.realOperation = realOperation;
            this.maxAge = maxAge;
        }

        public String realOperation() {
            return this.realOperation;
        }

        public int getMaxAge() {
            return this.maxAge;
        }
    }
}

