/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.cors;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.domain.http.server.cors.CorsHeaders;
import org.jboss.as.domain.http.server.cors.CorsUtil;

public class CorsHttpHandler
implements HttpHandler {
    private final HttpHandler next;
    private final Collection<String> allowedOrigins = new ArrayList<String>();
    private static final long ONE_HOUR_IN_SECONDS = 3600L;

    public CorsHttpHandler(HttpHandler next, Collection<String> allowedOrigins) {
        this.next = next;
        if (allowedOrigins != null) {
            for (String allowedOrigin : allowedOrigins) {
                this.allowedOrigins.add(CorsUtil.sanitizeDefaultPort(allowedOrigin));
            }
        }
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        HeaderMap headers = exchange.getRequestHeaders();
        if (CorsUtil.isCoreRequest(headers)) {
            if (CorsUtil.isPreflightedRequest(exchange)) {
                this.handlePreflightRequest(exchange);
                return;
            }
            this.setCorsResponseHeaders(exchange);
        }
        this.next.handleRequest(exchange);
    }

    private void handlePreflightRequest(HttpServerExchange exchange) throws Exception {
        this.setCorsResponseHeaders(exchange);
        ResponseCodeHandler.HANDLE_200.handleRequest(exchange);
    }

    private void setCorsResponseHeaders(HttpServerExchange exchange) throws Exception {
        HeaderValues requestedMethods;
        HeaderMap headers = exchange.getRequestHeaders();
        if (headers.contains(Headers.ORIGIN) && CorsUtil.matchOrigin(exchange, this.allowedOrigins) != null) {
            exchange.getResponseHeaders().addAll(CorsHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, (Collection)headers.get(Headers.ORIGIN));
        }
        if ((requestedMethods = headers.get(CorsHeaders.ACCESS_CONTROL_REQUEST_METHOD)) != null && !requestedMethods.isEmpty()) {
            exchange.getResponseHeaders().addAll(CorsHeaders.ACCESS_CONTROL_ALLOW_METHODS, (Collection)requestedMethods);
        } else {
            exchange.getResponseHeaders().addAll(CorsHeaders.ACCESS_CONTROL_ALLOW_METHODS, Arrays.asList("GET", "POST"));
        }
        HeaderValues requestedHeaders = headers.get(CorsHeaders.ACCESS_CONTROL_REQUEST_HEADERS);
        if (requestedHeaders != null && !requestedHeaders.isEmpty()) {
            exchange.getResponseHeaders().addAll(CorsHeaders.ACCESS_CONTROL_ALLOW_HEADERS, (Collection)requestedHeaders);
        } else {
            exchange.getResponseHeaders().add(CorsHeaders.ACCESS_CONTROL_ALLOW_HEADERS, "Content-Type");
            exchange.getResponseHeaders().add(CorsHeaders.ACCESS_CONTROL_ALLOW_HEADERS, "WWW-Authenticate");
            exchange.getResponseHeaders().add(CorsHeaders.ACCESS_CONTROL_ALLOW_HEADERS, "Authorization");
        }
        exchange.getResponseHeaders().add(CorsHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        exchange.getResponseHeaders().add(CorsHeaders.ACCESS_CONTROL_MAX_AGE, 3600L);
    }
}

