/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.cors;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.util.Collection;
import org.jboss.as.domain.http.server.cors.CorsHeaders;
import org.jboss.as.domain.http.server.logging.HttpServerLogger;

public class CorsUtil {
    public static boolean isCoreRequest(HeaderMap headers) {
        return headers.contains(CorsHeaders.ORIGIN) || headers.contains(CorsHeaders.ACCESS_CONTROL_REQUEST_HEADERS) || headers.contains(CorsHeaders.ACCESS_CONTROL_REQUEST_METHOD);
    }

    public static String matchOrigin(HttpServerExchange exchange, Collection<String> allowedOrigins) throws Exception {
        String allowedOrigin;
        HeaderMap headers = exchange.getRequestHeaders();
        String origin = headers.getFirst(Headers.ORIGIN);
        if (allowedOrigins != null && !allowedOrigins.isEmpty()) {
            for (String allowedOrigin2 : allowedOrigins) {
                if (!allowedOrigin2.equalsIgnoreCase(origin)) continue;
                return origin;
            }
        }
        if ((allowedOrigin = CorsUtil.defaultOrigin(exchange)).equalsIgnoreCase(origin)) {
            return origin;
        }
        HttpServerLogger.ROOT_LOGGER.debug("Request rejected due to HOST/ORIGIN mis-match.");
        ResponseCodeHandler.HANDLE_403.handleRequest(exchange);
        return null;
    }

    public static String defaultOrigin(HttpServerExchange exchange) {
        String host = exchange.getRequestHeaders().getFirst(Headers.HOST);
        String protocol = exchange.getRequestScheme();
        int port = exchange.getHostPort();
        StringBuilder allowedOrigin = new StringBuilder(256);
        allowedOrigin.append(protocol).append("://").append(host);
        if (!CorsUtil.isDefaultPort(port, protocol)) {
            allowedOrigin.append(':').append(port);
        }
        return allowedOrigin.toString();
    }

    private static boolean isDefaultPort(int port, String protocol) {
        return "http".equals(protocol) && 80 == port || "https".equals(protocol) && 443 == port;
    }

    public static boolean isPreflightedRequest(HttpServerExchange exchange) {
        return Methods.OPTIONS.equals(exchange.getRequestMethod()) && CorsUtil.isCoreRequest(exchange.getRequestHeaders());
    }
}

