/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.logging;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import org.jboss.as.domain.http.server.logging.HttpServerLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleNotFoundException;

public class HttpServerLogger_$logger
extends DelegatingBasicLogger
implements Serializable,
HttpServerLogger,
BasicLogger {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = HttpServerLogger_$logger.class.getName();
    private static final String modelRequestError = "WFLYDMHTTP0001: Unexpected error executing model request";
    private static final String uploadError = "WFLYDMHTTP0002: Unexpected error executing deployment upload request";
    private static final String consoleModuleNotFound = "WFLYDMHTTP0003: Unable to load console module for slot %s, disabling console";
    private static final String errorContextModuleNotFound = "WFLYDMHTTP0004: Unable to load error contest for slot %s, disabling error context.";
    private static final String invalidOperation = "WFLYDMHTTP0005: Invalid operation '%s'";
    private static final String realmNotReadyMessage = "WFLYDMHTTP0006: The security realm is not ready to process requests, see %s";
    private static final String consoleModuleNotFoundMsg = "WFLYDMHTTP0007: No console module available with module name %s";
    private static final String failedReadingResource = "WFLYDMHTTP0008: Failed to read %s";
    private static final String invalidResource = "WFLYDMHTTP0009: Invalid resource";
    private static final String invalidCredentialType = "WFLYDMHTTP0010: Invalid Credential Type '%s'";
    private static final String httpsRedirectNotSupported = "WFLYDMHTTP0011: Management interface is using different addresses for HTTP (%s) and HTTPS (%s). Redirection of HTTPS requests from HTTP socket to HTTPS socket will not be supported.";
    private static final String sslRequestedNoSslContext = "WFLYDMHTTP0012: A secure socket has been defined for the HTTP interface, however the referenced security realm is not supplying a SSLContext.";
    private static final String missingDMRParam = "WFLYDMHTTP0013: Requests of Content-Type application/x-www-form-urlencoded must include a JSON or Base64 encoded operation associated with parameter 'dmr'";
    private static final String invalidUseStreamAsResponseIndex = "WFLYDMHTTP0014: Invalid useStreamIndex value '%d'. The operation response had %d streams attached.";

    public HttpServerLogger_$logger(Logger log) {
        super(log);
    }

    @Override
    public final void modelRequestError(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.modelRequestError$str(), new Object[0]);
    }

    protected String modelRequestError$str() {
        return modelRequestError;
    }

    @Override
    public final void uploadError(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.uploadError$str(), new Object[0]);
    }

    protected String uploadError$str() {
        return uploadError;
    }

    @Override
    public final void consoleModuleNotFound(String slot) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.consoleModuleNotFound$str(), (Object)slot);
    }

    protected String consoleModuleNotFound$str() {
        return consoleModuleNotFound;
    }

    @Override
    public final void errorContextModuleNotFound(String slot) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.errorContextModuleNotFound$str(), (Object)slot);
    }

    protected String errorContextModuleNotFound$str() {
        return errorContextModuleNotFound;
    }

    @Override
    public final IllegalArgumentException invalidOperation(Throwable cause, String value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidOperation$str(), value), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidOperation$str() {
        return invalidOperation;
    }

    @Override
    public final String realmNotReadyMessage(String url) {
        String result = String.format(this.realmNotReadyMessage$str(), url);
        return result;
    }

    protected String realmNotReadyMessage$str() {
        return realmNotReadyMessage;
    }

    @Override
    public final ModuleNotFoundException consoleModuleNotFoundMsg(String moduleName) {
        ModuleNotFoundException result = new ModuleNotFoundException(String.format(this.consoleModuleNotFoundMsg$str(), moduleName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String consoleModuleNotFoundMsg$str() {
        return consoleModuleNotFoundMsg;
    }

    @Override
    public final RuntimeException failedReadingResource(Throwable cause, String resource) {
        RuntimeException result = new RuntimeException(String.format(this.failedReadingResource$str(), resource), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedReadingResource$str() {
        return failedReadingResource;
    }

    @Override
    public final String invalidResource() {
        String result = String.format(this.invalidResource$str(), new Object[0]);
        return result;
    }

    protected String invalidResource$str() {
        return invalidResource;
    }

    @Override
    public final IllegalArgumentException invalidCredentialType(String value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidCredentialType$str(), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCredentialType$str() {
        return invalidCredentialType;
    }

    @Override
    public final void httpsRedirectNotSupported(InetAddress bindAddress, InetAddress secureBindAddress) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.httpsRedirectNotSupported$str(), (Object)bindAddress, (Object)secureBindAddress);
    }

    protected String httpsRedirectNotSupported$str() {
        return httpsRedirectNotSupported;
    }

    @Override
    public final IllegalArgumentException sslRequestedNoSslContext() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.sslRequestedNoSslContext$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sslRequestedNoSslContext$str() {
        return sslRequestedNoSslContext;
    }

    @Override
    public final IOException missingDMRParam() {
        IOException result = new IOException(String.format(this.missingDMRParam$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingDMRParam$str() {
        return missingDMRParam;
    }

    @Override
    public final String invalidUseStreamAsResponseIndex(int index, int available) {
        String result = String.format(this.invalidUseStreamAsResponseIndex$str(), index, available);
        return result;
    }

    protected String invalidUseStreamAsResponseIndex$str() {
        return invalidUseStreamAsResponseIndex;
    }
}

