/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.discovery;

import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.extension.discovery.AggregateDiscoveryProviderRegistrar;
import org.wildfly.extension.discovery.StaticDiscoveryProviderRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.SubsystemResourceDefinitionRegistrar;

class DiscoverySubsystemRegistrar
implements SubsystemResourceDefinitionRegistrar {
    static final String NAME = "discovery";
    static final PathElement PATH = SubsystemResourceDefinitionRegistrar.pathElement((String)"discovery");
    static final ParentResourceDescriptionResolver RESOLVER = new SubsystemResourceDescriptionResolver("discovery", DiscoverySubsystemRegistrar.class);

    DiscoverySubsystemRegistrar() {
    }

    public ManagementResourceRegistration register(SubsystemRegistration parent, ManagementResourceRegistrationContext context) {
        parent.setHostCapable();
        ManagementResourceRegistration registration = parent.registerSubsystemModel(ResourceDefinition.builder((ResourceRegistration)ResourceRegistration.of((PathElement)PATH), (ResourceDescriptionResolver)RESOLVER).build());
        ResourceDescriptor descriptor = ResourceDescriptor.builder((ResourceDescriptionResolver)RESOLVER).build();
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        new AggregateDiscoveryProviderRegistrar().register(registration, context);
        new StaticDiscoveryProviderRegistrar().register(registration, context);
        return registration;
    }
}

