/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.discovery;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.extension.discovery.AggregateDiscoveryProviderDefinition;
import org.wildfly.extension.discovery.AggregateDiscoveryProviderService;
import org.wildfly.extension.discovery.DiscoveryExtension;

class AggregateDiscoveryProviderAddHandler
extends AbstractAddStepHandler {
    AggregateDiscoveryProviderAddHandler() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addService();
        Consumer provider = builder.provides(DiscoveryExtension.DISCOVERY_PROVIDER_CAPABILITY);
        List providerNames = AggregateDiscoveryProviderDefinition.PROVIDER_NAMES.unwrap((ExpressionResolver)context, resource.getModel());
        ArrayList<Supplier<DiscoveryProvider>> providers = new ArrayList<Supplier<DiscoveryProvider>>(providerNames.size());
        for (String providerName : providerNames) {
            providers.add(builder.requiresCapability(DiscoveryExtension.DISCOVERY_PROVIDER_CAPABILITY.getName(), DiscoveryProvider.class, new String[]{providerName}));
        }
        builder.setInstance((Service)new AggregateDiscoveryProviderService(provider, providers)).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        context.removeService(DiscoveryExtension.DISCOVERY_PROVIDER_CAPABILITY.getCapabilityServiceName(context.getCurrentAddress()));
    }
}

