/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.io.File;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.notification.NotificationFilter;
import org.jboss.as.controller.notification.NotificationHandler;
import org.jboss.as.controller.notification.NotificationHandlerRegistry;
import org.jboss.as.controller.registry.NotificationHandlerRegistration;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.scanner.DefaultDeploymentOperations;
import org.jboss.as.server.deployment.scanner.FileSystemDeploymentService;
import org.jboss.as.server.deployment.scanner.api.DeploymentOperations;
import org.jboss.as.server.deployment.scanner.api.DeploymentScanner;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class DeploymentScannerService
implements Service<DeploymentScanner> {
    private final PathAddress resourceAddress;
    private final long interval;
    private TimeUnit unit = TimeUnit.MILLISECONDS;
    private final boolean enabled;
    private final boolean autoDeployZipped;
    private final boolean autoDeployExploded;
    private final boolean autoDeployXml;
    private final Long deploymentTimeout;
    private final String relativeTo;
    private final String path;
    private final boolean rollbackOnRuntimeFailure;
    private static final NotificationFilter DEPLOYMENT_FILTER = notification -> {
        if ("deployment-undeployed".equals(notification.getType()) || "deployment-deployed".equals(notification.getType())) {
            List properties;
            ModelNode notificationData = notification.getData();
            if (notificationData.hasDefined("server-booting") && notificationData.get("server-booting").asBoolean()) {
                return false;
            }
            if (notificationData.hasDefined("owner") && (properties = notificationData.get("owner").asPropertyList()).size() >= 2) {
                return !"deployment-scanner".equals(((Property)properties.get(0)).getValue().asString()) && !"scanner".equals(((Property)properties.get(1)).getName());
            }
            return true;
        }
        return false;
    };
    private FileSystemDeploymentService scanner;
    private final InjectedValue<PathManager> pathManagerValue = new InjectedValue();
    private final InjectedValue<NotificationHandlerRegistry> notificationRegistryValue = new InjectedValue();
    private final InjectedValue<ModelControllerClientFactory> clientFactoryValue = new InjectedValue();
    private final InjectedValue<ScheduledExecutorService> scheduledExecutorValue = new InjectedValue();
    private final InjectedValue<ControlledProcessStateService> controlledProcessStateServiceValue = new InjectedValue();
    private volatile PathManager.Callback.Handle callbackHandle;

    public static ServiceName getServiceName(String repositoryName) {
        return DeploymentScanner.BASE_SERVICE_NAME.append(new String[]{repositoryName});
    }

    public static ServiceController<DeploymentScanner> addService(OperationContext context, PathAddress resourceAddress, String relativeTo, String path, int scanInterval, TimeUnit unit, boolean autoDeployZip, boolean autoDeployExploded, boolean autoDeployXml, boolean scanEnabled, long deploymentTimeout, boolean rollbackOnRuntimeFailure, FileSystemDeploymentService bootTimeService, ScheduledExecutorService scheduledExecutorService) {
        DeploymentScannerService service = new DeploymentScannerService(resourceAddress, relativeTo, path, scanInterval, unit, autoDeployZip, autoDeployExploded, autoDeployXml, scanEnabled, deploymentTimeout, rollbackOnRuntimeFailure, bootTimeService);
        ServiceName serviceName = DeploymentScannerService.getServiceName(resourceAddress.getLastElement().getValue());
        return context.getServiceTarget().addService(serviceName, (Service)service).addDependency(PathManagerService.SERVICE_NAME, PathManager.class, service.pathManagerValue).addDependency(context.getCapabilityServiceName("org.wildfly.managment.notification-handler-registry", null), NotificationHandlerRegistry.class, service.notificationRegistryValue).addDependency(context.getCapabilityServiceName("org.wildfly.managment.model-controller-client-factory", null), ModelControllerClientFactory.class, service.clientFactoryValue).addDependency(Services.JBOSS_DEPLOYMENT_CHAINS).addDependency(ControlledProcessStateService.SERVICE_NAME, ControlledProcessStateService.class, service.controlledProcessStateServiceValue).addInjection(service.scheduledExecutorValue, (Object)scheduledExecutorService).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private DeploymentScannerService(PathAddress resourceAddress, String relativeTo, String path, int interval, TimeUnit unit, boolean autoDeployZipped, boolean autoDeployExploded, boolean autoDeployXml, boolean enabled, long deploymentTimeout, boolean rollbackOnRuntimeFailure, FileSystemDeploymentService bootTimeService) {
        this.resourceAddress = resourceAddress;
        this.relativeTo = relativeTo;
        this.path = path;
        this.interval = interval;
        this.unit = unit;
        this.autoDeployZipped = autoDeployZipped;
        this.autoDeployExploded = autoDeployExploded;
        this.autoDeployXml = autoDeployXml;
        this.enabled = enabled;
        this.rollbackOnRuntimeFailure = rollbackOnRuntimeFailure;
        this.deploymentTimeout = deploymentTimeout;
        this.scanner = bootTimeService;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            DeploymentOperations.Factory factory = new DeploymentOperations.Factory(){

                @Override
                public DeploymentOperations create() {
                    return new DefaultDeploymentOperations((ModelControllerClientFactory)DeploymentScannerService.this.clientFactoryValue.getValue(), (Executor)DeploymentScannerService.this.scheduledExecutorValue.getValue());
                }
            };
            if (this.scanner == null) {
                PathManager pathManager = (PathManager)this.pathManagerValue.getValue();
                String pathName = pathManager.resolveRelativePathEntry(this.path, this.relativeTo);
                File relativePath = null;
                if (this.relativeTo != null) {
                    relativePath = new File(pathManager.getPathEntry(this.relativeTo).resolvePath());
                    this.callbackHandle = pathManager.registerCallback(pathName, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
                }
                FileSystemDeploymentService scanner = new FileSystemDeploymentService(this.resourceAddress, this.relativeTo, new File(pathName), relativePath, factory, (ScheduledExecutorService)this.scheduledExecutorValue.getValue(), (ControlledProcessStateService)this.controlledProcessStateServiceValue.getValue());
                scanner.setScanInterval(this.unit.toMillis(this.interval));
                scanner.setAutoDeployExplodedContent(this.autoDeployExploded);
                scanner.setAutoDeployZippedContent(this.autoDeployZipped);
                scanner.setAutoDeployXMLContent(this.autoDeployXml);
                scanner.setRuntimeFailureCausesRollback(this.rollbackOnRuntimeFailure);
                if (this.deploymentTimeout != null) {
                    scanner.setDeploymentTimeout(this.deploymentTimeout);
                }
                this.scanner = scanner;
            } else {
                this.scanner.setDeploymentOperationsFactory(factory);
            }
            ((NotificationHandlerRegistry)this.notificationRegistryValue.getValue()).registerNotificationHandler(NotificationHandlerRegistration.ANY_ADDRESS, (NotificationHandler)this.scanner, DEPLOYMENT_FILTER);
            if (this.enabled) {
                this.scanner.startScanner();
            }
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        FileSystemDeploymentService scanner = this.scanner;
        ((NotificationHandlerRegistry)this.notificationRegistryValue.getValue()).unregisterNotificationHandler(NotificationHandlerRegistration.ANY_ADDRESS, (NotificationHandler)this.scanner, DEPLOYMENT_FILTER);
        this.scanner = null;
        scanner.stopScanner();
        ((ScheduledExecutorService)this.scheduledExecutorValue.getValue()).shutdown();
        if (this.callbackHandle != null) {
            this.callbackHandle.remove();
        }
    }

    public synchronized DeploymentScanner getValue() throws IllegalStateException {
        FileSystemDeploymentService scanner = this.scanner;
        if (scanner == null) {
            throw new IllegalStateException();
        }
        return scanner;
    }
}

