/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.server.deployment.scanner.Attribute;
import org.jboss.as.server.deployment.scanner.DeploymentScannerAdd;
import org.jboss.as.server.deployment.scanner.DeploymentScannerExtension;
import org.jboss.as.server.deployment.scanner.DeploymentScannerRemove;
import org.jboss.as.server.deployment.scanner.FileSystemDeploymentScanHandler;
import org.jboss.as.server.deployment.scanner.WriteAutoDeployExplodedAttributeHandler;
import org.jboss.as.server.deployment.scanner.WriteAutoDeployXMLAttributeHandler;
import org.jboss.as.server.deployment.scanner.WriteAutoDeployZipAttributeHandler;
import org.jboss.as.server.deployment.scanner.WriteDeploymentTimeoutAttributeHandler;
import org.jboss.as.server.deployment.scanner.WriteEnabledAttributeHandler;
import org.jboss.as.server.deployment.scanner.WritePathAttributeHandler;
import org.jboss.as.server.deployment.scanner.WriteRelativeToAttributeHandler;
import org.jboss.as.server.deployment.scanner.WriteRuntimeFailureCausesRollbackAttributeHandler;
import org.jboss.as.server.deployment.scanner.WriteScanIntervalAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentScannerDefinition
extends SimpleResourceDefinition {
    private final PathManager pathManager;
    protected static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, false).setXmlName(Attribute.NAME.getLocalName())).setAllowExpression(false)).setValidator((ParameterValidator)new StringLengthValidator(1))).setDefaultValue(new ModelNode().set("default"))).build();
    protected static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", ModelType.STRING, false).setXmlName(Attribute.PATH.getLocalName())).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true))).addArbitraryDescriptor("filesystem-path", new ModelNode(true))).build();
    protected static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", ModelType.STRING, true).setXmlName(Attribute.RELATIVE_TO.getLocalName())).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).build();
    protected static final SimpleAttributeDefinition SCAN_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("scan-enabled", ModelType.BOOLEAN, true).setXmlName(Attribute.SCAN_ENABLED.getLocalName())).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).build();
    protected static final SimpleAttributeDefinition SCAN_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("scan-interval", ModelType.INT, true).setXmlName(Attribute.SCAN_INTERVAL.getLocalName())).setAllowExpression(true)).setDefaultValue(new ModelNode().set(0))).build();
    protected static final SimpleAttributeDefinition AUTO_DEPLOY_ZIPPED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("auto-deploy-zipped", ModelType.BOOLEAN, true).setXmlName(Attribute.AUTO_DEPLOY_ZIPPED.getLocalName())).setDefaultValue(new ModelNode().set(true))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition AUTO_DEPLOY_EXPLODED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("auto-deploy-exploded", ModelType.BOOLEAN, true).setXmlName(Attribute.AUTO_DEPLOY_EXPLODED.getLocalName())).setAllowExpression(true)).setDefaultValue(new ModelNode().set(false))).build();
    protected static final SimpleAttributeDefinition AUTO_DEPLOY_XML = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("auto-deploy-xml", ModelType.BOOLEAN, true).setXmlName(Attribute.AUTO_DEPLOY_XML.getLocalName())).setAllowExpression(true)).setDefaultValue(new ModelNode().set(true))).build();
    protected static final SimpleAttributeDefinition DEPLOYMENT_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("deployment-timeout", ModelType.LONG, true).setXmlName(Attribute.DEPLOYMENT_TIMEOUT.getLocalName())).setAllowExpression(true)).setDefaultValue(new ModelNode().set(600))).build();
    protected static final SimpleAttributeDefinition RUNTIME_FAILURE_CAUSES_ROLLBACK = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("runtime-failure-causes-rollback", ModelType.BOOLEAN, true).setXmlName(Attribute.RUNTIME_FAILURE_CAUSES_ROLLBACK.getLocalName())).setAllowExpression(true)).setDefaultValue(new ModelNode().set(false))).build();
    protected static final SimpleAttributeDefinition[] ALL_ATTRIBUTES = new SimpleAttributeDefinition[]{PATH, RELATIVE_TO, SCAN_ENABLED, SCAN_INTERVAL, AUTO_DEPLOY_EXPLODED, AUTO_DEPLOY_XML, AUTO_DEPLOY_ZIPPED, DEPLOYMENT_TIMEOUT, RUNTIME_FAILURE_CAUSES_ROLLBACK};

    DeploymentScannerDefinition(PathManager pathManager) {
        super(DeploymentScannerExtension.SCANNERS_PATH, DeploymentScannerExtension.getResourceDescriptionResolver("deployment.scanner"), (OperationStepHandler)new DeploymentScannerAdd(pathManager), (OperationStepHandler)DeploymentScannerRemove.INSTANCE);
        this.pathManager = pathManager;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)PATH, null, (OperationStepHandler)new WritePathAttributeHandler(this.pathManager));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)RELATIVE_TO, null, (OperationStepHandler)new WriteRelativeToAttributeHandler(this.pathManager));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SCAN_ENABLED, null, (OperationStepHandler)WriteEnabledAttributeHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SCAN_INTERVAL, null, (OperationStepHandler)WriteScanIntervalAttributeHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)AUTO_DEPLOY_ZIPPED, null, (OperationStepHandler)WriteAutoDeployZipAttributeHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)AUTO_DEPLOY_EXPLODED, null, (OperationStepHandler)WriteAutoDeployExplodedAttributeHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)AUTO_DEPLOY_XML, null, (OperationStepHandler)WriteAutoDeployXMLAttributeHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)DEPLOYMENT_TIMEOUT, null, (OperationStepHandler)WriteDeploymentTimeoutAttributeHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)RUNTIME_FAILURE_CAUSES_ROLLBACK, null, (OperationStepHandler)WriteRuntimeFailureCausesRollbackAttributeHandler.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler(FileSystemDeploymentScanHandler.DEFINITION, (OperationStepHandler)FileSystemDeploymentScanHandler.INSTANCE);
    }
}

