/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.deployment.scanner.ExtensibleFilter;
import org.jboss.as.server.deployment.scanner.XmlCompletionScanner;
import org.jboss.as.server.deployment.scanner.ZipCompletionScanner;
import org.jboss.as.server.deployment.scanner.api.DeploymentOperations;
import org.jboss.as.server.deployment.scanner.api.DeploymentScanner;
import org.jboss.as.server.deployment.scanner.logging.DeploymentScannerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

class FileSystemDeploymentService
implements DeploymentScanner {
    static final Pattern ARCHIVE_PATTERN = Pattern.compile("^.*\\.(?:(?:[SsWwJjEeRr][Aa][Rr])|(?:[Ww][Aa][Bb])|(?:[Ee][Ss][Aa]))$");
    static final String DEPLOYED = ".deployed";
    static final String FAILED_DEPLOY = ".failed";
    static final String DO_DEPLOY = ".dodeploy";
    static final String DEPLOYING = ".isdeploying";
    static final String UNDEPLOYING = ".isundeploying";
    static final String UNDEPLOYED = ".undeployed";
    static final String SKIP_DEPLOY = ".skipdeploy";
    static final String PENDING = ".pending";
    static final String WEB_INF = "WEB-INF";
    static final String META_INF = "META-INF";
    static final long MAX_NO_PROGRESS = 60000L;
    static final long DEFAULT_DEPLOYMENT_TIMEOUT = 600L;
    private File deploymentDir;
    private long scanInterval = 0L;
    private volatile boolean scanEnabled = false;
    private volatile boolean firstScan = true;
    private ScheduledFuture<?> scanTask;
    private ScheduledFuture<?> rescanIncompleteTask;
    private ScheduledFuture<?> rescanUndeployTask;
    private final Lock scanLock = new ReentrantLock();
    private final Map<String, DeploymentMarker> deployed = new HashMap<String, DeploymentMarker>();
    private final HashSet<String> ignoredMissingDeployments = new HashSet();
    private final HashSet<String> noticeLogged = new HashSet();
    private final HashSet<String> illegalDirLogged = new HashSet();
    private final HashSet<String> prematureExplodedContentDeletionLogged = new HashSet();
    private final HashSet<File> nonscannableLogged = new HashSet();
    private final Map<File, IncompleteDeploymentStatus> incompleteDeployments = new HashMap<File, IncompleteDeploymentStatus>();
    private final ScheduledExecutorService scheduledExecutor;
    private final ControlledProcessStateService processStateService;
    private volatile DeploymentOperations.Factory deploymentOperationsFactory;
    private volatile DeploymentOperations deploymentOperations;
    private FileFilter filter = new ExtensibleFilter();
    private volatile boolean autoDeployZip;
    private volatile boolean autoDeployExploded;
    private volatile boolean autoDeployXml;
    private volatile long maxNoProgress = 60000L;
    private volatile boolean rollbackOnRuntimeFailure;
    private volatile long deploymentTimeout = 600L;
    private final ModelNode resourceAddress;
    private final String relativeTo;
    private final String relativePath;
    private final PropertyChangeListener propertyChangeListener;
    private Future<?> undeployScanTask;
    private final DeploymentScanRunnable scanRunnable = new DeploymentScanRunnable();

    FileSystemDeploymentService(PathAddress resourceAddress, String relativeTo, File deploymentDir, File relativeToDir, DeploymentOperations.Factory deploymentOperationsFactory, final ScheduledExecutorService scheduledExecutor, final ControlledProcessStateService processStateService) throws OperationFailedException {
        assert (resourceAddress != null);
        assert (resourceAddress.size() > 0);
        assert (scheduledExecutor != null);
        assert (deploymentDir != null);
        if (!deploymentDir.exists()) {
            throw DeploymentScannerLogger.ROOT_LOGGER.directoryDoesNotExist(deploymentDir.getAbsolutePath());
        }
        if (!deploymentDir.isDirectory()) {
            throw DeploymentScannerLogger.ROOT_LOGGER.notADirectory(deploymentDir.getAbsolutePath());
        }
        if (!deploymentDir.canWrite()) {
            throw DeploymentScannerLogger.ROOT_LOGGER.directoryNotWritable(deploymentDir.getAbsolutePath());
        }
        this.resourceAddress = resourceAddress.toModelNode();
        this.resourceAddress.protect();
        this.relativeTo = relativeTo;
        this.deploymentDir = deploymentDir;
        this.deploymentOperationsFactory = deploymentOperationsFactory;
        this.scheduledExecutor = scheduledExecutor;
        this.processStateService = processStateService;
        if (processStateService != null) {
            this.propertyChangeListener = new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (ControlledProcessState.State.RUNNING == evt.getNewValue()) {
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            if (FileSystemDeploymentService.this.scanEnabled) {
                                FileSystemDeploymentService.this.undeployScanTask = scheduledExecutor.submit(new UndeployScanRunnable());
                            }
                        }
                    } else if (ControlledProcessState.State.STOPPING == evt.getNewValue()) {
                        if (FileSystemDeploymentService.this.undeployScanTask != null) {
                            FileSystemDeploymentService.this.undeployScanTask.cancel(true);
                            FileSystemDeploymentService.this.undeployScanTask = null;
                        }
                        processStateService.removePropertyChangeListener(FileSystemDeploymentService.this.propertyChangeListener);
                    }
                }
            };
            this.processStateService.addPropertyChangeListener(this.propertyChangeListener);
        } else {
            this.propertyChangeListener = null;
        }
        if (relativeToDir != null) {
            String relDir;
            String fullDir = deploymentDir.getAbsolutePath();
            String sub = fullDir.substring((relDir = relativeToDir.getAbsolutePath()).length());
            if (sub.startsWith(File.separator)) {
                sub = sub.length() == 1 ? "" : sub.substring(1);
            }
            this.relativePath = sub.length() > 0 ? sub + File.separator : sub;
        } else {
            this.relativePath = null;
        }
    }

    @Override
    public boolean isAutoDeployZippedContent() {
        return this.autoDeployZip;
    }

    @Override
    public void setAutoDeployZippedContent(boolean autoDeployZip) {
        this.autoDeployZip = autoDeployZip;
    }

    @Override
    public boolean isAutoDeployExplodedContent() {
        return this.autoDeployExploded;
    }

    @Override
    public void setAutoDeployExplodedContent(boolean autoDeployExploded) {
        if (autoDeployExploded && !this.autoDeployExploded) {
            DeploymentScannerLogger.ROOT_LOGGER.explodedAutoDeploymentContentWarning(DO_DEPLOY, "auto-deploy-exploded");
        }
        this.autoDeployExploded = autoDeployExploded;
    }

    @Override
    public void setAutoDeployXMLContent(boolean autoDeployXML) {
        this.autoDeployXml = autoDeployXML;
    }

    @Override
    public boolean isAutoDeployXMLContent() {
        return this.autoDeployXml;
    }

    @Override
    public boolean isEnabled() {
        return this.scanEnabled;
    }

    @Override
    public long getScanInterval() {
        return this.scanInterval;
    }

    @Override
    public synchronized void setScanInterval(long scanInterval) {
        if (scanInterval != this.scanInterval) {
            this.cancelScan();
        }
        this.scanInterval = scanInterval;
        this.startScan();
    }

    @Override
    public void setDeploymentTimeout(long deploymentTimeout) {
        this.deploymentTimeout = deploymentTimeout;
    }

    @Override
    public synchronized void startScanner() {
        assert (this.deploymentOperationsFactory != null) : "deploymentOperationsFactory is null";
        this.startScanner(this.deploymentOperationsFactory.create());
    }

    @Override
    public void setRuntimeFailureCausesRollback(boolean rollbackOnRuntimeFailure) {
        this.rollbackOnRuntimeFailure = rollbackOnRuntimeFailure;
    }

    @Override
    public synchronized void startScanner(DeploymentOperations deploymentOperations) {
        this.deploymentOperations = deploymentOperations;
        boolean scanEnabled = this.scanEnabled;
        if (scanEnabled) {
            return;
        }
        this.establishDeployedContentList(this.deploymentDir, deploymentOperations);
        this.scanEnabled = true;
        this.startScan();
        DeploymentScannerLogger.ROOT_LOGGER.started(this.getClass().getSimpleName(), this.deploymentDir.getAbsolutePath());
    }

    @Override
    public synchronized void stopScanner() {
        this.scanEnabled = false;
        this.cancelScan();
        this.safeClose(this.deploymentOperations);
        this.deploymentOperations = null;
        if (this.undeployScanTask != null) {
            this.undeployScanTask.cancel(true);
        }
        this.undeployScanTask = null;
    }

    void setDeploymentOperationsFactory(DeploymentOperations.Factory factory) {
        assert (factory != null) : "factory is null";
        this.deploymentOperationsFactory = factory;
    }

    void setMaxNoProgress(long max) {
        this.maxNoProgress = max;
    }

    private void establishDeployedContentList(File dir, DeploymentOperations deploymentOperations) {
        File[] children;
        Set<String> deploymentNames = deploymentOperations.getDeploymentsStatus().keySet();
        for (File child : children = FileSystemDeploymentService.listDirectoryChildren(dir)) {
            File skipDeploy;
            String fileName = child.getName();
            if (child.isDirectory()) {
                if (this.isEEArchive(fileName)) continue;
                this.establishDeployedContentList(child, deploymentOperations);
                continue;
            }
            if (!fileName.endsWith(DEPLOYED)) continue;
            String deploymentName = fileName.substring(0, fileName.length() - DEPLOYED.length());
            if (deploymentNames.contains(deploymentName)) {
                File deployment = new File(dir, deploymentName);
                this.deployed.put(deploymentName, new DeploymentMarker(child.lastModified(), !deployment.isDirectory(), dir));
                continue;
            }
            if (!child.delete()) {
                DeploymentScannerLogger.ROOT_LOGGER.cannotRemoveDeploymentMarker(fileName);
            }
            if ((skipDeploy = new File(dir, deploymentName + SKIP_DEPLOY)).exists()) continue;
            File deployedMarker = new File(dir, deploymentName + DO_DEPLOY);
            this.createMarkerFile(deployedMarker, deploymentName);
        }
    }

    void bootTimeScan(DeploymentOperations deploymentOperations) {
        this.establishDeployedContentList(this.deploymentDir, deploymentOperations);
        if (this.acquireScanLock()) {
            try {
                this.scan(true, deploymentOperations);
            }
            finally {
                this.releaseScanLock();
            }
        }
    }

    void singleScan() {
        assert (this.deploymentOperationsFactory != null) : "deploymentOperationsFactory is null";
        ManualScanCallable manualScan = new ManualScanCallable();
        this.scheduledExecutor.submit(manualScan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scan() {
        if (this.acquireScanLock()) {
            ScanResult scanResult = null;
            try {
                scanResult = this.scan(false, this.deploymentOperations);
            }
            finally {
                block17: {
                    try {
                        if (scanResult == null || !scanResult.scheduleRescan) break block17;
                        FileSystemDeploymentService fileSystemDeploymentService = this;
                        synchronized (fileSystemDeploymentService) {
                            if (this.scanEnabled) {
                                this.rescanIncompleteTask = this.scheduledExecutor.schedule(this.scanRunnable, 200L, TimeUnit.MILLISECONDS);
                            }
                        }
                    }
                    finally {
                        this.releaseScanLock();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forcedUndeployScan() {
        if (this.acquireScanLock()) {
            try {
                DeploymentScannerLogger.ROOT_LOGGER.tracef("Performing a post-boot forced undeploy scan for scan directory %oManu", this.deploymentDir.getAbsolutePath());
                ScanContext scanContext = new ScanContext(this.deploymentOperations);
                for (Map.Entry missing : scanContext.toRemove.entrySet()) {
                    if (!scanContext.registeredDeployments.containsKey(missing.getKey())) continue;
                    scanContext.registeredDeployments.remove(missing.getKey());
                }
                HashSet scannedDeployments = new HashSet(scanContext.registeredDeployments.keySet());
                scannedDeployments.removeAll(scanContext.persistentDeployments);
                List scannerTasks = scanContext.scannerTasks;
                for (String toUndeploy : scannedDeployments) {
                    scannerTasks.add(new UndeployTask(toUndeploy, this.deploymentDir, scanContext.scanStartTime, true));
                }
                try {
                    this.executeScannerTasks(scannerTasks, this.deploymentOperations, true, new ScanResult());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                DeploymentScannerLogger.ROOT_LOGGER.tracef("Forced undeploy scan complete", new Object[0]);
            }
            catch (Exception e) {
                DeploymentScannerLogger.ROOT_LOGGER.scanException(e, this.deploymentDir.getAbsolutePath());
            }
            finally {
                this.releaseScanLock();
            }
        }
    }

    private boolean acquireScanLock() {
        try {
            this.scanLock.lockInterruptibly();
            return true;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private void releaseScanLock() {
        this.scanLock.unlock();
    }

    private ScanResult scan(boolean oneOffScan, DeploymentOperations deploymentOperations) {
        ScanResult scanResult = new ScanResult();
        if (this.scanEnabled || oneOffScan) {
            DeploymentScannerLogger.ROOT_LOGGER.tracef("Scanning directory %s for deployment content changes", this.deploymentDir.getAbsolutePath());
            ScanContext scanContext = new ScanContext(deploymentOperations);
            this.scanDirectory(this.deploymentDir, this.relativePath, scanContext);
            this.ignoredMissingDeployments.retainAll(scanContext.ignoredMissingDeployments);
            for (String deploymentName : scanContext.ignoredMissingDeployments) {
                if (!this.ignoredMissingDeployments.add(deploymentName)) continue;
                DeploymentScannerLogger.ROOT_LOGGER.deploymentNotFound(deploymentName);
            }
            this.noticeLogged.retainAll(scanContext.nonDeployable);
            for (String fileName : scanContext.nonDeployable) {
                if (!this.noticeLogged.add(fileName)) continue;
                DeploymentScannerLogger.ROOT_LOGGER.deploymentTriggered(fileName, DO_DEPLOY);
            }
            this.illegalDirLogged.retainAll(scanContext.illegalDir);
            for (String fileName : scanContext.illegalDir) {
                if (!this.illegalDirLogged.add(fileName)) continue;
                DeploymentScannerLogger.ROOT_LOGGER.invalidExplodedDeploymentDirectory(fileName, this.deploymentDir.getAbsolutePath());
            }
            this.prematureExplodedContentDeletionLogged.retainAll(scanContext.prematureExplodedDeletions);
            for (String fileName : scanContext.prematureExplodedDeletions) {
                if (!this.prematureExplodedContentDeletionLogged.add(fileName)) continue;
                DeploymentScannerLogger.ROOT_LOGGER.explodedDeploymentContentDeleted(fileName, DEPLOYED);
            }
            ScanStatus status = this.handleAutoDeployFailures(scanContext);
            if (status != ScanStatus.PROCEED) {
                if (status == ScanStatus.RETRY && this.scanInterval > 1000L) {
                    scanResult.scheduleRescan = true;
                }
            } else {
                List scannerTasks = scanContext.scannerTasks;
                for (Map.Entry missing : scanContext.toRemove.entrySet()) {
                    scannerTasks.add(new UndeployTask((String)missing.getKey(), ((DeploymentMarker)missing.getValue()).parentFolder, scanContext.scanStartTime, false));
                }
                try {
                    scanResult.tasks = scannerTasks;
                    this.executeScannerTasks(scannerTasks, deploymentOperations, oneOffScan, scanResult);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                DeploymentScannerLogger.ROOT_LOGGER.tracef("Scan complete", new Object[0]);
                this.firstScan = false;
            }
        }
        return scanResult;
    }

    private void executeScannerTasks(List<ScannerTask> scannerTasks, DeploymentOperations deploymentOperations, boolean oneOffScan, ScanResult scanResult) throws InterruptedException {
        if (scannerTasks.size() > 0) {
            ArrayList<Object> updates = new ArrayList<ModelNode>(scannerTasks.size());
            for (ScannerTask task : scannerTasks) {
                task.recordInProgress();
                ModelNode update = task.getUpdate();
                if (DeploymentScannerLogger.ROOT_LOGGER.isDebugEnabled()) {
                    DeploymentScannerLogger.ROOT_LOGGER.debugf("Deployment scan of [%s] found update action [%s]", this.deploymentDir, update);
                }
                updates.add(update);
            }
            boolean first = true;
            while (!(updates.isEmpty() || !first && oneOffScan)) {
                ModelNode results;
                first = false;
                try {
                    ModelNode failure;
                    Future<ModelNode> futureResults = deploymentOperations.deploy(this.getCompositeUpdate(updates), this.scheduledExecutor);
                    try {
                        results = futureResults.get(this.deploymentTimeout, TimeUnit.SECONDS);
                    }
                    catch (TimeoutException e) {
                        futureResults.cancel(true);
                        failure = new ModelNode();
                        failure.get("outcome").set("failed");
                        failure.get("failure-description").set(DeploymentScannerLogger.ROOT_LOGGER.deploymentTimeout(this.deploymentTimeout));
                        for (ScannerTask task : scannerTasks) {
                            task.handleFailureResult(failure);
                        }
                        break;
                    }
                    catch (InterruptedException e) {
                        futureResults.cancel(true);
                        throw e;
                    }
                    catch (Exception e) {
                        DeploymentScannerLogger.ROOT_LOGGER.fileSystemDeploymentFailed(e);
                        futureResults.cancel(true);
                        failure = new ModelNode();
                        failure.get("outcome").set("failed");
                        failure.get("failure-description").set(e.getMessage());
                        for (ScannerTask task : scannerTasks) {
                            task.handleFailureResult(failure);
                        }
                        break;
                    }
                }
                catch (RejectedExecutionException ex) {
                    for (ScannerTask task : scannerTasks) {
                        task.removeInProgressMarker();
                    }
                    break;
                }
                ArrayList toRetry = new ArrayList();
                ArrayList<ScannerTask> retryTasks = new ArrayList<ScannerTask>();
                if (results.hasDefined("result")) {
                    List resultList = results.get("result").asPropertyList();
                    scanResult.requireUndeploy = false;
                    for (int i = 0; i < resultList.size(); ++i) {
                        ModelNode result = ((Property)resultList.get(i)).getValue();
                        ScannerTask task = scannerTasks.get(i);
                        ModelNode outcome = result.get("outcome");
                        StringBuilder failureDesc = new StringBuilder();
                        if (outcome.isDefined() && "success".equals(outcome.asString()) && this.handleCompositeResult(result, failureDesc)) {
                            task.handleSuccessResult();
                            continue;
                        }
                        if (outcome.isDefined() && "cancelled".equals(outcome.asString())) {
                            toRetry.add(updates.get(i));
                            retryTasks.add(task);
                            continue;
                        }
                        if (failureDesc.length() > 0) {
                            result.get("failure-description").set(failureDesc.toString());
                            scanResult.requireUndeploy = true;
                        }
                        task.handleFailureResult(result);
                    }
                    updates = toRetry;
                    scannerTasks = retryTasks;
                    continue;
                }
                for (ScannerTask current : scannerTasks) {
                    current.handleFailureResult(results);
                }
            }
        }
    }

    private boolean handleCompositeResult(ModelNode resultNode, StringBuilder failureDesc) {
        ModelNode outcome = resultNode.get("outcome");
        boolean success = true;
        if (resultNode.get("outcome").isDefined() && "success".equals(outcome.asString())) {
            if (resultNode.get("result").isDefined()) {
                List results = resultNode.get("result").asPropertyList();
                for (int i = 0; i < results.size(); ++i) {
                    if (this.handleCompositeResult(((Property)results.get(i)).getValue(), failureDesc)) continue;
                    success = false;
                    break;
                }
            }
        } else {
            success = false;
            if (resultNode.get("failure-description").isDefined()) {
                failureDesc.append(resultNode.get("failure-description").toString());
            }
        }
        return success;
    }

    private void scanDirectory(File directory, String relativePath, ScanContext scanContext) {
        File[] children;
        for (File child : children = FileSystemDeploymentService.listDirectoryChildren(directory, this.filter)) {
            File deploymentFile;
            String fileName = child.getName();
            if (fileName.endsWith(DEPLOYED)) {
                boolean autoDeployable;
                String deploymentName = fileName.substring(0, fileName.length() - DEPLOYED.length());
                DeploymentMarker deploymentMarker = this.deployed.get(deploymentName);
                if (deploymentMarker == null) {
                    scanContext.toRemove.remove(deploymentName);
                    this.removeExtraneousMarker(child, fileName);
                    continue;
                }
                deploymentFile = new File(directory, deploymentName);
                if (deploymentFile.exists()) {
                    scanContext.toRemove.remove(deploymentName);
                    if (this.deployed.get(deploymentName).lastModified != child.lastModified()) {
                        scanContext.scannerTasks.add(new RedeployTask(deploymentName, child.lastModified(), directory, !child.isDirectory()));
                        continue;
                    }
                    Boolean isDeployed = (Boolean)scanContext.registeredDeployments.get(deploymentName);
                    if (isDeployed != null && isDeployed.booleanValue()) continue;
                    this.deployed.remove(deploymentName);
                    this.removeExtraneousMarker(child, fileName);
                    File marker = new File(directory, deploymentName + UNDEPLOYED);
                    this.createMarkerFile(marker, deploymentName);
                    if (isDeployed == null) {
                        DeploymentScannerLogger.ROOT_LOGGER.scannerDeploymentRemovedButNotByScanner(deploymentName, marker);
                        continue;
                    }
                    DeploymentScannerLogger.ROOT_LOGGER.scannerDeploymentUndeployedButNotByScanner(deploymentName, marker);
                    continue;
                }
                boolean bl = autoDeployable = deploymentMarker.archive ? this.autoDeployZip : this.autoDeployExploded;
                if (autoDeployable) continue;
                scanContext.toRemove.remove(deploymentName);
                if (deploymentMarker.archive) continue;
                scanContext.prematureExplodedDeletions.add(deploymentName);
                continue;
            }
            if (fileName.endsWith(DO_DEPLOY) || fileName.endsWith(FAILED_DEPLOY) && this.firstScan) {
                String markerStatus = fileName.endsWith(DO_DEPLOY) ? DO_DEPLOY : FAILED_DEPLOY;
                String deploymentName = fileName.substring(0, fileName.length() - markerStatus.length());
                if (FAILED_DEPLOY.equals(markerStatus)) {
                    if (!scanContext.firstScanDeployments.add(deploymentName)) continue;
                    DeploymentScannerLogger.ROOT_LOGGER.reattemptingFailedDeployment(deploymentName);
                }
                if (!(deploymentFile = new File(directory, deploymentName)).exists()) {
                    scanContext.ignoredMissingDeployments.add(deploymentName);
                    continue;
                }
                long timestamp = this.getDeploymentTimestamp(deploymentFile);
                String path = this.relativeTo == null ? deploymentFile.getAbsolutePath() : relativePath + deploymentName;
                boolean archive = deploymentFile.isFile();
                this.addContentAddingTask(path, archive, deploymentName, deploymentFile, timestamp, scanContext);
                continue;
            }
            if (fileName.endsWith(FAILED_DEPLOY)) {
                String deploymentName = fileName.substring(0, fileName.length() - FAILED_DEPLOY.length());
                scanContext.toRemove.remove(deploymentName);
                if (this.deployed.containsKey(deploymentName) || new File(child.getParent(), deploymentName).exists()) continue;
                this.removeExtraneousMarker(child, fileName);
                continue;
            }
            if (this.isEEArchive(fileName)) {
                boolean autoDeployable;
                boolean bl = autoDeployable = child.isDirectory() ? this.autoDeployExploded : this.autoDeployZip;
                if (autoDeployable) {
                    DeploymentMarker marker;
                    if (this.isAutoDeployDisabled(child)) continue;
                    long timestamp = this.getDeploymentTimestamp(child);
                    this.synchronizeScannerStatus(scanContext, directory, fileName, timestamp);
                    if (this.isFailedOrUndeployed(scanContext, directory, fileName, timestamp) || scanContext.firstScanDeployments.contains(fileName) || (marker = this.deployed.get(fileName)) != null && marker.lastModified == timestamp) continue;
                    try {
                        if (this.isZipComplete(child)) {
                            String path = this.relativeTo == null ? child.getAbsolutePath() : relativePath + fileName;
                            boolean archive = child.isFile();
                            if (this.firstScan) {
                                scanContext.firstScanDeployments.add(fileName);
                            }
                            this.addContentAddingTask(path, archive, fileName, child, timestamp, scanContext);
                            continue;
                        }
                        if (!child.exists()) continue;
                        scanContext.incompleteFiles.put(child, new IncompleteDeploymentStatus(child, timestamp));
                    }
                    catch (ZipCompletionScanner.NonScannableZipException e) {
                        scanContext.nonscannable.put(child, new NonScannableStatus(e, timestamp));
                    }
                    continue;
                }
                if (this.deployed.containsKey(fileName) || new File(fileName + DO_DEPLOY).exists() || new File(fileName + FAILED_DEPLOY).exists()) continue;
                scanContext.nonDeployable.add(fileName);
                continue;
            }
            if (this.isXmlFile(fileName)) {
                if (this.autoDeployXml) {
                    DeploymentMarker marker;
                    long timestamp;
                    if (this.isAutoDeployDisabled(child) || this.isFailedOrUndeployed(scanContext, directory, fileName, timestamp = this.getDeploymentTimestamp(child)) || scanContext.firstScanDeployments.contains(fileName) || (marker = this.deployed.get(fileName)) != null && marker.lastModified == timestamp) continue;
                    if (this.isXmlComplete(child)) {
                        String path;
                        String string = path = this.relativeTo == null ? child.getAbsolutePath() : relativePath + fileName;
                        if (this.firstScan) {
                            scanContext.firstScanDeployments.add(fileName);
                        }
                        this.addContentAddingTask(path, true, fileName, child, timestamp, scanContext);
                        continue;
                    }
                    if (!child.exists()) continue;
                    scanContext.incompleteFiles.put(child, new IncompleteDeploymentStatus(child, timestamp));
                    continue;
                }
                if (this.deployed.containsKey(fileName) || new File(fileName + DO_DEPLOY).exists() || new File(fileName + FAILED_DEPLOY).exists()) continue;
                scanContext.nonDeployable.add(fileName);
                continue;
            }
            if (fileName.endsWith(DEPLOYING) || fileName.endsWith(UNDEPLOYING)) {
                this.removeExtraneousMarker(child, fileName);
                continue;
            }
            if (fileName.endsWith(PENDING)) {
                String deploymentName = fileName.substring(0, fileName.length() - PENDING.length());
                File deployment = new File(child.getParent(), deploymentName);
                if (deployment.exists()) continue;
                this.removeExtraneousMarker(child, fileName);
                continue;
            }
            if (!child.isDirectory()) continue;
            if (WEB_INF.equalsIgnoreCase(fileName) || META_INF.equalsIgnoreCase(fileName)) {
                scanContext.illegalDir.add(fileName);
                continue;
            }
            this.scanDirectory(child, relativePath + child.getName() + File.separator, scanContext);
        }
    }

    private boolean isXmlComplete(File xmlFile) {
        try {
            return XmlCompletionScanner.isCompleteDocument(xmlFile);
        }
        catch (Exception e) {
            DeploymentScannerLogger.ROOT_LOGGER.failedCheckingXMLFile(e, xmlFile.getPath());
            return false;
        }
    }

    private boolean isFailedOrUndeployed(ScanContext scanContext, File directory, String fileName, long timestamp) {
        File failedMarker = new File(directory, fileName + FAILED_DEPLOY);
        if (failedMarker.exists() && timestamp <= failedMarker.lastModified()) {
            return true;
        }
        File undeployedMarker = new File(directory, fileName + UNDEPLOYED);
        return this.isMarkedUndeployed(undeployedMarker, timestamp) && !this.isRegisteredDeployment(scanContext, fileName);
    }

    private void synchronizeScannerStatus(ScanContext scanContext, File directory, String fileName, long timestamp) {
        File undeployedMarker;
        if (this.isRegisteredDeployment(scanContext, fileName) && this.isMarkedUndeployed(undeployedMarker = new File(directory, fileName + UNDEPLOYED), timestamp) && !scanContext.persistentDeployments.contains(fileName)) {
            try {
                DeploymentScannerLogger.ROOT_LOGGER.scannerDeploymentRedeployedButNotByScanner(fileName, undeployedMarker);
                undeployedMarker.delete();
                File deployedMarker = new File(directory, fileName + DEPLOYED);
                deployedMarker.createNewFile();
                boolean isArchive = false;
                if (this.deployed.containsKey(fileName)) {
                    isArchive = this.deployed.get(fileName).archive;
                    deployedMarker.setLastModified(this.deployed.get(fileName).lastModified);
                } else {
                    File deploymentFile = new File(directory, fileName);
                    boolean bl = isArchive = deploymentFile.exists() && deploymentFile.isFile();
                    if (deploymentFile.exists()) {
                        deployedMarker.setLastModified(deploymentFile.lastModified());
                    }
                }
                this.deployed.put(fileName, new DeploymentMarker(deployedMarker.lastModified(), isArchive, directory));
            }
            catch (IOException ex) {
                DeploymentScannerLogger.ROOT_LOGGER.failedStatusSynchronization(ex, fileName);
            }
        }
    }

    private long addContentAddingTask(String path, boolean archive, String deploymentName, File deploymentFile, long timestamp, ScanContext scanContext) {
        if (scanContext.registeredDeployments.containsKey(deploymentName)) {
            scanContext.scannerTasks.add(new ReplaceTask(path, archive, deploymentName, deploymentFile, timestamp));
        } else {
            scanContext.scannerTasks.add(new DeployTask(path, archive, deploymentName, deploymentFile, timestamp));
        }
        scanContext.toRemove.remove(deploymentName);
        return timestamp;
    }

    private boolean isRegisteredDeployment(ScanContext scanContext, String fileName) {
        if (!scanContext.persistentDeployments.contains(fileName)) {
            return scanContext.registeredDeployments.get(fileName) == null ? false : (Boolean)scanContext.registeredDeployments.get(fileName);
        }
        return false;
    }

    private boolean isMarkedUndeployed(File undeployedMarker, long timestamp) {
        return undeployedMarker.exists() && timestamp <= undeployedMarker.lastModified();
    }

    private boolean isZipComplete(File file) throws ZipCompletionScanner.NonScannableZipException {
        if (file.isDirectory()) {
            for (File child : FileSystemDeploymentService.listDirectoryChildren(file)) {
                if (this.isZipComplete(child)) continue;
                return false;
            }
            return true;
        }
        if (this.isEEArchive(file.getName())) {
            try {
                return ZipCompletionScanner.isCompleteZip(file);
            }
            catch (IOException e) {
                DeploymentScannerLogger.ROOT_LOGGER.failedCheckingZipFile(e, file.getPath());
                return false;
            }
        }
        return true;
    }

    private boolean isAutoDeployDisabled(File file) {
        String name;
        File parent = file.getParentFile();
        return new File(parent, (name = file.getName()) + SKIP_DEPLOY).exists() || new File(parent, name + DO_DEPLOY).exists();
    }

    private long getDeploymentTimestamp(File deploymentFile) {
        if (deploymentFile.isDirectory()) {
            long latest = deploymentFile.lastModified();
            for (File child : FileSystemDeploymentService.listDirectoryChildren(deploymentFile)) {
                long childTimestamp = this.getDeploymentTimestamp(child);
                if (childTimestamp <= latest) continue;
                latest = childTimestamp;
            }
            return latest;
        }
        return deploymentFile.lastModified();
    }

    private boolean isEEArchive(String fileName) {
        return ARCHIVE_PATTERN.matcher(fileName).matches();
    }

    private boolean isXmlFile(String fileName) {
        return fileName.endsWith(".xml");
    }

    private void removeExtraneousMarker(File child, String fileName) {
        if (!child.delete()) {
            DeploymentScannerLogger.ROOT_LOGGER.cannotRemoveDeploymentMarker(fileName);
        }
    }

    private ScanStatus handleAutoDeployFailures(ScanContext scanContext) {
        ScanStatus result = ScanStatus.PROCEED;
        boolean warnLogged = false;
        HashSet<File> noLongerIncomplete = new HashSet<File>(this.incompleteDeployments.keySet());
        noLongerIncomplete.removeAll(scanContext.incompleteFiles.keySet());
        int oldIncompleteCount = this.incompleteDeployments.size();
        this.incompleteDeployments.keySet().retainAll(scanContext.incompleteFiles.keySet());
        if (scanContext.incompleteFiles.size() > 0) {
            result = ScanStatus.RETRY;
            boolean logAll = this.incompleteDeployments.size() != oldIncompleteCount;
            long now = System.currentTimeMillis();
            for (Map.Entry entry : scanContext.incompleteFiles.entrySet()) {
                boolean newIncomplete;
                File incompleteFile = (File)entry.getKey();
                String deploymentName = incompleteFile.getName();
                IncompleteDeploymentStatus status = this.incompleteDeployments.get(incompleteFile);
                if (status == null || status.size < ((IncompleteDeploymentStatus)entry.getValue()).size) {
                    status = (IncompleteDeploymentStatus)entry.getValue();
                }
                if (now - status.timestamp > this.maxNoProgress) {
                    if (!status.warned) {
                        String suffix = this.deployed.containsKey(deploymentName) ? DeploymentScannerLogger.ROOT_LOGGER.previousContentDeployed() : "";
                        String msg = DeploymentScannerLogger.ROOT_LOGGER.deploymentContentIncomplete(incompleteFile, suffix);
                        this.writeFailedMarker(incompleteFile, msg, status.timestamp);
                        DeploymentScannerLogger.ROOT_LOGGER.error(msg);
                        status.warned = true;
                        warnLogged = true;
                        result = ScanStatus.ABORT;
                    }
                    new File(incompleteFile.getParentFile(), deploymentName + PENDING).delete();
                    continue;
                }
                boolean bl = newIncomplete = this.incompleteDeployments.put(incompleteFile, status) == null;
                if (newIncomplete || logAll) {
                    DeploymentScannerLogger.ROOT_LOGGER.incompleteContent(((File)entry.getKey()).getPath());
                }
                if (!newIncomplete) continue;
                File pending = new File(incompleteFile.getParentFile(), deploymentName + PENDING);
                this.createMarkerFile(pending, deploymentName);
            }
        }
        for (File complete : noLongerIncomplete) {
            File pending = new File(complete.getParentFile(), complete.getName() + PENDING);
            this.removeExtraneousMarker(pending, pending.getName());
        }
        int oldNonScannableCount = this.nonscannableLogged.size();
        this.nonscannableLogged.retainAll(scanContext.nonscannable.keySet());
        if (scanContext.nonscannable.size() > 0) {
            result = result == ScanStatus.PROCEED ? ScanStatus.RETRY : result;
            boolean logAll = this.nonscannableLogged.size() != oldNonScannableCount;
            for (Map.Entry entry : scanContext.nonscannable.entrySet()) {
                File nonScannable = (File)entry.getKey();
                String fileName = nonScannable.getName();
                if (!this.nonscannableLogged.add(nonScannable) && !logAll) continue;
                NonScannableStatus nonScannableStatus = (NonScannableStatus)entry.getValue();
                ZipCompletionScanner.NonScannableZipException e = nonScannableStatus.exception;
                String msg = DeploymentScannerLogger.ROOT_LOGGER.unsafeAutoDeploy2(e.getLocalizedMessage(), fileName, DO_DEPLOY);
                this.writeFailedMarker(nonScannable, msg, nonScannableStatus.timestamp);
                DeploymentScannerLogger.ROOT_LOGGER.error(msg);
                warnLogged = true;
                result = ScanStatus.ABORT;
            }
        }
        if (warnLogged) {
            HashSet<String> allProblems = new HashSet<String>();
            for (File file : scanContext.nonscannable.keySet()) {
                allProblems.add(file.getName());
            }
            for (File file : scanContext.incompleteFiles.keySet()) {
                allProblems.add(file.getName());
            }
            DeploymentScannerLogger.ROOT_LOGGER.unsafeAutoDeploy(DO_DEPLOY, SKIP_DEPLOY, allProblems);
        }
        return result;
    }

    private synchronized void startScan() {
        if (this.scanEnabled) {
            this.scanTask = this.scanInterval > 0L ? this.scheduledExecutor.scheduleWithFixedDelay(this.scanRunnable, 0L, this.scanInterval, TimeUnit.MILLISECONDS) : this.scheduledExecutor.schedule(this.scanRunnable, this.scanInterval, TimeUnit.MILLISECONDS);
        }
    }

    private void cancelScan() {
        if (this.rescanIncompleteTask != null) {
            this.rescanIncompleteTask.cancel(true);
            this.rescanIncompleteTask = null;
        }
        if (this.rescanUndeployTask != null) {
            this.rescanUndeployTask.cancel(true);
            this.rescanUndeployTask = null;
        }
        if (this.scanTask != null) {
            this.scanTask.cancel(true);
            this.scanTask = null;
        }
    }

    private ModelNode getCompositeUpdate(List<ModelNode> updates) {
        ModelNode op = Util.getEmptyOperation((String)"composite", (ModelNode)new ModelNode());
        ModelNode steps = op.get("steps");
        for (ModelNode update : updates) {
            steps.add(update);
        }
        op.get(new String[]{"operation-headers", "rollback-on-runtime-failure"}).set(this.rollbackOnRuntimeFailure);
        return op;
    }

    private ModelNode getCompositeUpdate(ModelNode ... updates) {
        ModelNode op = Util.getEmptyOperation((String)"composite", (ModelNode)new ModelNode());
        ModelNode steps = op.get("steps");
        for (ModelNode update : updates) {
            steps.add(update);
        }
        op.get(new String[]{"operation-headers", "rollback-on-runtime-failure"}).set(this.rollbackOnRuntimeFailure);
        return op;
    }

    private void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMarkerFile(File marker, String deploymentName) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(marker);
            fos.write(deploymentName.getBytes());
        }
        catch (IOException io) {
            DeploymentScannerLogger.ROOT_LOGGER.errorWritingDeploymentMarker(io, marker.getAbsolutePath());
        }
        finally {
            this.safeClose(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFailedMarker(File deploymentFile, String failureDescription, long failureTimestamp) {
        File undeployedMarker;
        File deployedMarker;
        File failedMarker = new File(deploymentFile.getParent(), deploymentFile.getName() + FAILED_DEPLOY);
        File deployMarker = new File(deploymentFile.getParent(), deploymentFile.getName() + DO_DEPLOY);
        if (deployMarker.exists() && !deployMarker.delete()) {
            DeploymentScannerLogger.ROOT_LOGGER.cannotRemoveDeploymentMarker(deployMarker);
        }
        if ((deployedMarker = new File(deploymentFile.getParent(), deploymentFile.getName() + DEPLOYED)).exists() && !deployedMarker.delete()) {
            DeploymentScannerLogger.ROOT_LOGGER.cannotRemoveDeploymentMarker(deployedMarker);
        }
        if ((undeployedMarker = new File(deploymentFile.getParent(), deploymentFile.getName() + UNDEPLOYED)).exists() && !undeployedMarker.delete()) {
            DeploymentScannerLogger.ROOT_LOGGER.cannotRemoveDeploymentMarker(undeployedMarker);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(failedMarker);
            fos.write(failureDescription.getBytes());
        }
        catch (IOException io) {
            DeploymentScannerLogger.ROOT_LOGGER.errorWritingDeploymentMarker(io, failedMarker.getAbsolutePath());
        }
        finally {
            this.safeClose(fos);
        }
    }

    private static File[] listDirectoryChildren(File directory) {
        return FileSystemDeploymentService.listDirectoryChildren(directory, null);
    }

    private static File[] listDirectoryChildren(File directory, FileFilter filter) {
        File[] result = directory.listFiles(filter);
        if (result == null) {
            throw DeploymentScannerLogger.ROOT_LOGGER.cannotListDirectoryFiles(directory);
        }
        return result;
    }

    private static enum ScanStatus {
        ABORT,
        RETRY,
        PROCEED;

    }

    private static class ScanResult {
        private boolean scheduleRescan;
        private boolean requireUndeploy;
        private List<ScannerTask> tasks;

        private ScanResult() {
        }
    }

    private static class NonScannableStatus {
        private final long timestamp;
        private final ZipCompletionScanner.NonScannableZipException exception;

        public NonScannableStatus(ZipCompletionScanner.NonScannableZipException exception, long timestamp) {
            this.exception = exception;
            this.timestamp = timestamp;
        }
    }

    private static class IncompleteDeploymentStatus {
        private final long timestamp;
        private final long size;
        private boolean warned;

        IncompleteDeploymentStatus(File file, long timestamp) {
            this.size = file.length();
            this.timestamp = timestamp;
        }
    }

    private class ScanContext {
        private final Map<String, Boolean> registeredDeployments;
        private final Set<String> persistentDeployments;
        private final List<ScannerTask> scannerTasks = new ArrayList<ScannerTask>();
        private final Map<String, DeploymentMarker> toRemove = new HashMap<String, DeploymentMarker>(FileSystemDeploymentService.access$4600(FileSystemDeploymentService.this));
        private final HashSet<String> ignoredMissingDeployments = new HashSet();
        private Map<File, IncompleteDeploymentStatus> incompleteFiles = new HashMap<File, IncompleteDeploymentStatus>();
        private final HashSet<String> nonDeployable = new HashSet();
        private final HashSet<String> illegalDir = new HashSet();
        private final HashSet<String> prematureExplodedDeletions = new HashSet();
        private final HashSet<String> firstScanDeployments = new HashSet();
        private final Map<File, NonScannableStatus> nonscannable = new HashMap<File, NonScannableStatus>();
        private final long scanStartTime = System.currentTimeMillis();

        private ScanContext(DeploymentOperations deploymentOperations) {
            this.registeredDeployments = deploymentOperations.getDeploymentsStatus();
            this.persistentDeployments = deploymentOperations.getUnrelatedDeployments(FileSystemDeploymentService.this.resourceAddress);
        }
    }

    private class DeploymentMarker {
        private final long lastModified;
        private final boolean archive;
        private final File parentFolder;

        private DeploymentMarker(long lastModified, boolean archive, File parentFolder) {
            this.lastModified = lastModified;
            this.archive = archive;
            this.parentFolder = parentFolder;
        }
    }

    private final class UndeployTask
    extends ScannerTask {
        private final long scanStartTime;
        private boolean forcedUndeploy;

        private UndeployTask(String deploymentName, File parent, long scanStartTime, boolean forcedUndeploy) {
            super(deploymentName, parent, FileSystemDeploymentService.UNDEPLOYING);
            this.scanStartTime = scanStartTime;
            this.forcedUndeploy = forcedUndeploy;
        }

        @Override
        protected ModelNode getUpdate() {
            ModelNode address = new ModelNode().add("deployment", this.deploymentName);
            ModelNode undeployOp = Util.getEmptyOperation((String)"undeploy", (ModelNode)address);
            ModelNode removeOp = Util.getEmptyOperation((String)"remove", (ModelNode)address);
            return FileSystemDeploymentService.this.getCompositeUpdate(new ModelNode[]{undeployOp, removeOp});
        }

        @Override
        protected void handleSuccessResult() {
            this.removeInProgressMarker();
            if (!this.forcedUndeploy) {
                this.deleteDeployedMarker();
                File undeployedMarker = new File(this.parent, this.deploymentName + FileSystemDeploymentService.UNDEPLOYED);
                FileSystemDeploymentService.this.createMarkerFile(undeployedMarker, this.deploymentName);
                undeployedMarker.setLastModified(this.scanStartTime);
            }
            FileSystemDeploymentService.this.deployed.remove(this.deploymentName);
            FileSystemDeploymentService.this.noticeLogged.remove(this.deploymentName);
        }

        @Override
        protected void handleFailureResult(ModelNode result) {
            this.removeInProgressMarker();
            if (!this.forcedUndeploy) {
                FileSystemDeploymentService.this.writeFailedMarker(new File(this.parent, this.deploymentName), result.get("failure-description").toString(), this.scanStartTime);
            }
        }
    }

    private final class RedeployTask
    extends ScannerTask {
        private final long markerLastModified;
        private final boolean archive;

        private RedeployTask(String deploymentName, long markerLastModified, File parent, boolean archive) {
            super(deploymentName, parent, FileSystemDeploymentService.DEPLOYING);
            this.markerLastModified = markerLastModified;
            this.archive = archive;
        }

        @Override
        protected ModelNode getUpdate() {
            ModelNode address = new ModelNode().add("deployment", this.deploymentName);
            return Util.getEmptyOperation((String)"redeploy", (ModelNode)address);
        }

        @Override
        protected void handleSuccessResult() {
            this.removeInProgressMarker();
            FileSystemDeploymentService.this.deployed.remove(this.deploymentName);
            FileSystemDeploymentService.this.deployed.put(this.deploymentName, new DeploymentMarker(this.markerLastModified, this.archive, new File(this.parent)));
        }

        @Override
        protected void handleFailureResult(ModelNode result) {
            this.removeInProgressMarker();
            FileSystemDeploymentService.this.writeFailedMarker(new File(this.parent, this.deploymentName), result.get("failure-description").toString(), this.markerLastModified);
        }
    }

    private final class ReplaceTask
    extends ContentAddingTask {
        private ReplaceTask(String path, boolean archive, String deploymentName, File deploymentFile, long markerTimestamp) {
            super(path, archive, deploymentName, deploymentFile, markerTimestamp);
        }

        @Override
        protected ModelNode getUpdate() {
            ModelNode replaceOp = Util.getEmptyOperation((String)"full-replace-deployment", (ModelNode)new ModelNode());
            replaceOp.get("name").set(this.deploymentName);
            replaceOp.get("content").set(this.createContent());
            replaceOp.get("persistent").set(false);
            replaceOp.get("owner").set(FileSystemDeploymentService.this.resourceAddress);
            replaceOp.get("enabled").set(true);
            return replaceOp;
        }

        @Override
        protected void handleFailureResult(ModelNode result) {
            this.removeInProgressMarker();
            FileSystemDeploymentService.this.writeFailedMarker(this.deploymentFile, result.get("failure-description").toString(), this.doDeployTimestamp);
        }
    }

    private final class DeployTask
    extends ContentAddingTask {
        private DeployTask(String path, boolean archive, String deploymentName, File deploymentFile, long markerTimestamp) {
            super(path, archive, deploymentName, deploymentFile, markerTimestamp);
        }

        @Override
        protected ModelNode getUpdate() {
            ModelNode address = new ModelNode().add("deployment", this.deploymentName);
            ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)address);
            addOp.get("content").set(this.createContent());
            addOp.get("persistent").set(false);
            addOp.get("owner").set(FileSystemDeploymentService.this.resourceAddress);
            ModelNode deployOp = Util.getEmptyOperation((String)"deploy", (ModelNode)address);
            return FileSystemDeploymentService.this.getCompositeUpdate(new ModelNode[]{addOp, deployOp});
        }

        @Override
        protected void handleFailureResult(ModelNode result) {
            this.removeInProgressMarker();
            FileSystemDeploymentService.this.writeFailedMarker(this.deploymentFile, result.get("failure-description").toString(), this.doDeployTimestamp);
        }
    }

    private abstract class ContentAddingTask
    extends ScannerTask {
        private final String path;
        private final boolean archive;
        protected final File deploymentFile;
        protected final long doDeployTimestamp;

        protected ContentAddingTask(String path, boolean archive, String deploymentName, File deploymentFile, long markerTimestamp) {
            super(deploymentName, deploymentFile.getParentFile(), FileSystemDeploymentService.DEPLOYING);
            this.path = path;
            this.archive = archive;
            this.deploymentFile = deploymentFile;
            this.doDeployTimestamp = markerTimestamp;
        }

        protected ModelNode createContent() {
            ModelNode content = new ModelNode();
            ModelNode contentItem = content.get(0);
            if (this.archive) {
                try {
                    contentItem.get("url").set(this.deploymentFile.toURI().toURL().toString());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (!contentItem.hasDefined("url")) {
                contentItem.get("archive").set(this.archive);
                contentItem.get("path").set(this.path);
                if (FileSystemDeploymentService.this.relativeTo != null) {
                    contentItem.get("relative-to").set(FileSystemDeploymentService.this.relativeTo);
                }
            }
            return content;
        }

        @Override
        protected void handleSuccessResult() {
            File failedMarker;
            File parentFolder = new File(this.parent);
            File doDeployMarker = new File(parentFolder, this.deploymentFile.getName() + FileSystemDeploymentService.DO_DEPLOY);
            if (doDeployMarker.exists() && !doDeployMarker.delete()) {
                DeploymentScannerLogger.ROOT_LOGGER.cannotRemoveDeploymentMarker(doDeployMarker.getAbsolutePath());
            }
            if ((failedMarker = new File(this.deploymentFile.getParent(), this.deploymentFile.getName() + FileSystemDeploymentService.FAILED_DEPLOY)).exists() && !failedMarker.delete()) {
                DeploymentScannerLogger.ROOT_LOGGER.cannotRemoveDeploymentMarker(failedMarker);
            }
            File deployedMarker = new File(this.parent, this.deploymentFile.getName() + FileSystemDeploymentService.DEPLOYED);
            FileSystemDeploymentService.this.createMarkerFile(deployedMarker, this.deploymentName);
            deployedMarker.setLastModified(this.doDeployTimestamp);
            if (FileSystemDeploymentService.this.deployed.containsKey(this.deploymentName)) {
                FileSystemDeploymentService.this.deployed.remove(this.deploymentName);
            }
            FileSystemDeploymentService.this.deployed.put(this.deploymentName, new DeploymentMarker(this.doDeployTimestamp, this.archive, parentFolder));
            this.removeInProgressMarker();
        }
    }

    private abstract class ScannerTask {
        protected final String deploymentName;
        protected final String parent;
        private final String inProgressMarkerSuffix;

        private ScannerTask(String deploymentName, File parent, String inProgressMarkerSuffix) {
            this.deploymentName = deploymentName;
            this.parent = parent.getAbsolutePath();
            this.inProgressMarkerSuffix = inProgressMarkerSuffix;
            File marker = new File(parent, deploymentName + FileSystemDeploymentService.PENDING);
            if (!marker.exists()) {
                FileSystemDeploymentService.this.createMarkerFile(marker, deploymentName);
            }
        }

        protected void recordInProgress() {
            File marker = new File(this.parent, this.deploymentName + this.inProgressMarkerSuffix);
            FileSystemDeploymentService.this.createMarkerFile(marker, this.deploymentName);
            this.deleteUndeployedMarker();
            this.deletePendingMarker();
        }

        protected abstract ModelNode getUpdate();

        protected abstract void handleSuccessResult();

        protected abstract void handleFailureResult(ModelNode var1);

        protected void deletePendingMarker() {
            File pendingMarker = new File(this.parent, this.deploymentName + FileSystemDeploymentService.PENDING);
            if (pendingMarker.exists() && !pendingMarker.delete()) {
                DeploymentScannerLogger.ROOT_LOGGER.cannotRemoveDeploymentMarker(pendingMarker);
            }
        }

        protected void deleteUndeployedMarker() {
            File undeployedMarker = new File(this.parent, this.deploymentName + FileSystemDeploymentService.UNDEPLOYED);
            if (undeployedMarker.exists() && !undeployedMarker.delete()) {
                DeploymentScannerLogger.ROOT_LOGGER.cannotRemoveDeploymentMarker(undeployedMarker);
            }
        }

        protected void deleteDeployedMarker() {
            File deployedMarker = new File(this.parent, this.deploymentName + FileSystemDeploymentService.DEPLOYED);
            if (deployedMarker.exists() && !deployedMarker.delete()) {
                DeploymentScannerLogger.ROOT_LOGGER.cannotRemoveDeploymentMarker(deployedMarker);
            }
        }

        protected void removeInProgressMarker() {
            File marker = new File(new File(this.parent), this.deploymentName + this.inProgressMarkerSuffix);
            if (marker.exists() && !marker.delete()) {
                DeploymentScannerLogger.ROOT_LOGGER.cannotDeleteDeploymentProgressMarker(marker);
            }
        }
    }

    private class UndeployScanRunnable
    implements Runnable {
        private UndeployScanRunnable() {
        }

        @Override
        public void run() {
            FileSystemDeploymentService.this.forcedUndeployScan();
            FileSystemDeploymentService.this.processStateService.removePropertyChangeListener(FileSystemDeploymentService.this.propertyChangeListener);
        }
    }

    private class ManualScanCallable
    implements Runnable {
        private ManualScanCallable() {
        }

        @Override
        public void run() {
            DeploymentOperations operations = FileSystemDeploymentService.this.deploymentOperations;
            if (operations == null) {
                operations = FileSystemDeploymentService.this.deploymentOperationsFactory.create();
            }
            if (FileSystemDeploymentService.this.acquireScanLock()) {
                try {
                    DeploymentScannerLogger.ROOT_LOGGER.debug("Manual scan launched");
                    FileSystemDeploymentService.this.scan(true, operations);
                }
                catch (Exception e) {
                    DeploymentScannerLogger.ROOT_LOGGER.scanException(e, FileSystemDeploymentService.this.deploymentDir.getAbsolutePath());
                }
                finally {
                    FileSystemDeploymentService.this.releaseScanLock();
                }
            }
        }
    }

    private class DeploymentScanRunnable
    implements Runnable {
        private DeploymentScanRunnable() {
        }

        @Override
        public void run() {
            try {
                FileSystemDeploymentService.this.scan();
            }
            catch (RejectedExecutionException e) {
            }
            catch (Exception e) {
                DeploymentScannerLogger.ROOT_LOGGER.scanException(e, FileSystemDeploymentService.this.deploymentDir.getAbsolutePath());
            }
        }
    }
}

