/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.access.management.AccessConstraintDescriptionProviderUtil;
import org.jboss.as.controller.capability.Capability;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;

public class DefaultResourceDescriptionProvider
implements DescriptionProvider {
    private final ImmutableManagementResourceRegistration registration;
    private final ResourceDescriptionResolver descriptionResolver;
    private final DeprecationData deprecationData;

    public DefaultResourceDescriptionProvider(ImmutableManagementResourceRegistration registration, ResourceDescriptionResolver descriptionResolver) {
        this(registration, descriptionResolver, null);
    }

    public DefaultResourceDescriptionProvider(ImmutableManagementResourceRegistration registration, ResourceDescriptionResolver descriptionResolver, DeprecationData deprecationData) {
        this.registration = registration;
        this.descriptionResolver = descriptionResolver;
        this.deprecationData = deprecationData;
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        int n;
        ModelNode cap;
        ModelNode result = new ModelNode();
        ResourceBundle bundle = this.descriptionResolver.getResourceBundle(locale);
        result.get("description").set(this.descriptionResolver.getResourceDescription(locale, bundle));
        int minOccurs = this.registration.getMinOccurs();
        if (minOccurs > 0) {
            result.get("min-occurs").set(minOccurs);
        }
        int maxOccurs = this.registration.getMaxOccurs();
        PathAddress pa = this.registration.getPathAddress();
        if (pa == null || pa.size() == 0) {
            result.get("max-occurs").set(maxOccurs);
        } else {
            int defaultMax;
            int n2 = defaultMax = pa.getLastElement().isWildcard() ? Integer.MAX_VALUE : 1;
            if (maxOccurs != defaultMax) {
                result.get("max-occurs").set(maxOccurs);
            }
        }
        Set<RuntimeCapability> capabilities = this.registration.getCapabilities();
        if (capabilities != null && !capabilities.isEmpty()) {
            for (Capability capability : capabilities) {
                String[] elements;
                String[] stringArray;
                cap = result.get("capabilities").add();
                cap.get("name").set(capability.getName());
                cap.get("dynamic").set(capability.isDynamicallyNamed());
                if (!capability.isDynamicallyNamed() || (stringArray = Arrays.copyOfRange(elements = capability.getDynamicName(this.createAliasPathAddress(pa)).split("\\.\\$"), 1, elements.length)).length <= 0) continue;
                String[] stringArray2 = stringArray;
                n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    String patternElement = stringArray2[i];
                    cap.get("dynamic-elements").add(patternElement);
                }
            }
        }
        for (CapabilityReferenceRecorder capabilityReferenceRecorder : this.registration.getRequirements()) {
            cap = result.get("capabilities").add();
            cap.get("required").set(true);
            cap.get("name").set(capabilityReferenceRecorder.getBaseRequirementName());
            String[] segments = capabilityReferenceRecorder.getRequirementPatternSegments(null, this.createAliasPathAddress(pa));
            if (segments != null && segments.length > 0) {
                cap.get("dynamic").set(true);
                String[] stringArray = segments;
                int n3 = stringArray.length;
                for (n = 0; n < n3; ++n) {
                    Object segment;
                    Object elt = segment = stringArray[n];
                    if (((String)segment).charAt(0) == '$') {
                        elt = ((String)segment).substring(1);
                    }
                    cap.get("dynamic-elements").add((String)elt);
                }
                continue;
            }
            cap.get("dynamic").set(false);
        }
        if (this.deprecationData != null) {
            ModelNode deprecated = this.addDeprecatedInfo(result);
            deprecated.get("reason").set(this.descriptionResolver.getResourceDeprecatedDescription(locale, bundle));
        }
        if (this.registration.isRuntimeOnly()) {
            result.get("storage").set("runtime-only");
        }
        AccessConstraintDescriptionProviderUtil.addAccessConstraints(result, this.registration.getAccessConstraints(), locale);
        Set<String> attributeNames = this.registration.getAttributeNames(PathAddress.EMPTY_ADDRESS);
        Comparator<AttributeDefinition.NameAndGroup> comparator = new Comparator<AttributeDefinition.NameAndGroup>(){

            @Override
            public int compare(AttributeDefinition.NameAndGroup o1, AttributeDefinition.NameAndGroup o2) {
                int attrCompare = o1.getName().compareTo(o2.getName());
                if (attrCompare != 0) {
                    return attrCompare;
                }
                return o1.compareTo(o2);
            }
        };
        TreeMap<AttributeDefinition.NameAndGroup, ModelNode> sortedDescriptions = new TreeMap<AttributeDefinition.NameAndGroup, ModelNode>(comparator);
        for (String string : attributeNames) {
            AttributeAccess attributeAccess = this.registration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, string);
            AttributeDefinition def = attributeAccess.getAttributeDefinition();
            if (def != null) {
                ModelNode attrDesc = new ModelNode();
                def.addResourceAttributeDescription(attrDesc, this.descriptionResolver, locale, bundle);
                sortedDescriptions.put(new AttributeDefinition.NameAndGroup(def), attrDesc.get(new String[]{"attributes", string}));
                continue;
            }
            sortedDescriptions.put(new AttributeDefinition.NameAndGroup(string), new ModelNode());
        }
        ModelNode attributes = result.get("attributes").setEmptyObject();
        for (Map.Entry entry : sortedDescriptions.entrySet()) {
            attributes.get(((AttributeDefinition.NameAndGroup)entry.getKey()).getName()).set((ModelNode)entry.getValue());
        }
        result.get("operations");
        result.get("notifications");
        ModelNode modelNode = result.get("children").setEmptyObject();
        Set<PathElement> set = this.registration.getChildAddresses(PathAddress.EMPTY_ADDRESS);
        HashSet<String> childTypes = new HashSet<String>();
        for (PathElement childAddress : set) {
            String key = childAddress.getKey();
            if (!childTypes.add(key)) continue;
            ModelNode childNode = modelNode.get(key);
            childNode.get("description").set(this.descriptionResolver.getChildTypeDescription(key, locale, bundle));
            childNode.get("model-description");
        }
        return result;
    }

    private ModelNode addDeprecatedInfo(ModelNode model) {
        ModelNode deprecated = model.get("deprecated");
        deprecated.get("since").set(this.deprecationData.getSince().toString());
        deprecated.get("reason");
        return deprecated;
    }

    private PathAddress createAliasPathAddress(PathAddress pa) {
        ImmutableManagementResourceRegistration registry = this.registration.getParent();
        ArrayList<PathElement> elements = new ArrayList<PathElement>();
        for (int i = pa.size() - 1; i >= 0; --i) {
            PathElement elt = pa.getElement(i);
            ImmutableManagementResourceRegistration childRegistration = registry.getSubModel(PathAddress.pathAddress(PathElement.pathElement(elt.getKey())));
            if (childRegistration == null) {
                elements.add(elt);
            } else {
                elements.add(PathElement.pathElement(elt.getKey(), "$" + elt.getKey()));
            }
            registry = registry.getParent();
        }
        Collections.reverse(elements);
        return PathAddress.pathAddress(elements.toArray(new PathElement[elements.size()]));
    }
}

