/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SetValidator<T>
extends ModelTypeValidator
implements AllowedValuesValidator {
    private final Function<ModelNode, T> resolver;
    private final Function<T, ModelNode> formatter;
    private final Set<T> allowed;

    public SetValidator(Function<String, T> resolver, Set<T> allowed) {
        this(ModelType.STRING, resolver.compose(ModelNode::asString), UnaryOperator.identity().andThen(Object::toString).andThen(ModelNode::new), allowed);
    }

    public SetValidator(ModelType type, Function<ModelNode, T> resolver, Function<T, ModelNode> formatter, Set<T> allowed) {
        super(type);
        this.resolver = resolver;
        this.formatter = formatter;
        this.allowed = Set.copyOf(allowed);
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined() && value.getType() != ModelType.EXPRESSION) {
            try {
                T resolved = this.resolver.apply(value);
                if (!this.allowed.contains(resolved)) {
                    throw new OperationFailedException(ControllerLogger.MGMT_OP_LOGGER.invalidValue(value.asString(), parameterName, this.allowed.stream().map(this.formatter).map(ModelNode::asString).toList()));
                }
            }
            catch (RuntimeException e) {
                throw new OperationFailedException(e);
            }
        }
    }

    @Override
    public List<ModelNode> getAllowedValues() {
        return this.allowed.stream().map(this.formatter).toList();
    }
}

