/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import java.util.Comparator;
import java.util.function.Function;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.Bound;
import org.jboss.as.controller.operations.validation.Bounded;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public interface BoundedParameterValidator<T>
extends Bounded<T>,
ParameterValidator {
    public static Builder<Integer> integerBuilder() {
        return BoundedParameterValidator.builder(ModelType.INT, ModelNode::asIntOrNull);
    }

    public static Builder<Long> longBuilder() {
        return BoundedParameterValidator.builder(ModelType.LONG, ModelNode::asLongOrNull);
    }

    public static Builder<Double> doubleBuilder() {
        return BoundedParameterValidator.builder(ModelType.DOUBLE, ModelNode::asDoubleOrNull);
    }

    public static <T extends Comparable<T>> Builder<T> builder(ModelType type, Function<ModelNode, T> resolver) {
        return BoundedParameterValidator.builder(type, resolver, Comparator.naturalOrder());
    }

    public static <T> Builder<T> builder(final ModelType type, final Function<ModelNode, T> resolver, final Comparator<T> comparator) {
        return new Builder<T>(){
            private Bound<T> lower = null;
            private Bound<T> upper = null;

            @Override
            public Builder<T> withLowerBound(Bound<T> bound) {
                int result;
                if (this.upper != null && ((result = comparator.compare(bound.get(), this.upper.get())) > 0 || result == 0 && (bound.isExclusive() || this.upper.isExclusive()))) {
                    throw new IllegalArgumentException(bound.get().toString());
                }
                this.lower = bound;
                return this;
            }

            @Override
            public Builder<T> withUpperBound(Bound<T> bound) {
                int result;
                if (this.lower != null && ((result = comparator.compare(this.lower.get(), bound.get())) > 0 || result == 0 && (this.lower.isExclusive() || bound.isExclusive()))) {
                    throw new IllegalArgumentException(bound.get().toString());
                }
                this.upper = bound;
                return this;
            }

            @Override
            public Bound<T> getLowerBound() {
                return this.lower;
            }

            @Override
            public Bound<T> getUpperBound() {
                return this.upper;
            }

            @Override
            public BoundedParameterValidator<T> build() {
                return new BoundedValidator(type, resolver, comparator, this.lower, this.upper);
            }

            static class BoundedValidator<T>
            extends ModelTypeValidator
            implements BoundedParameterValidator<T> {
                private final Function<ModelNode, T> resolver;
                private final Comparator<T> comparator;
                private final Bound<T> lowerBound;
                private final Bound<T> upperBound;

                BoundedValidator(ModelType type, Function<ModelNode, T> resolver, Comparator<T> comparator, Bound<T> lowerBound, Bound<T> upperBound) {
                    super(type);
                    this.resolver = resolver;
                    this.comparator = comparator;
                    this.lowerBound = lowerBound;
                    this.upperBound = upperBound;
                }

                @Override
                public Bound<T> getLowerBound() {
                    return this.lowerBound;
                }

                @Override
                public Bound<T> getUpperBound() {
                    return this.upperBound;
                }

                @Override
                public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
                    super.validateParameter(parameterName, value);
                    if (value.isDefined() && value.getType() != ModelType.EXPRESSION) {
                        try {
                            int result;
                            T resolved = this.resolver.apply(value);
                            if (this.lowerBound != null) {
                                result = this.comparator.compare(this.lowerBound.get(), resolved);
                                if (this.lowerBound.isExclusive()) {
                                    if (result >= 0) {
                                        throw ControllerLogger.MGMT_OP_LOGGER.exclusiveLowerBoundExceeded(parameterName, resolved, this.lowerBound.get());
                                    }
                                } else if (result > 0) {
                                    throw ControllerLogger.MGMT_OP_LOGGER.inclusiveLowerBoundExceeded(parameterName, resolved, this.lowerBound.get());
                                }
                            }
                            if (this.upperBound != null) {
                                result = this.comparator.compare(resolved, this.upperBound.get());
                                if (this.upperBound.isExclusive()) {
                                    if (result >= 0) {
                                        throw ControllerLogger.MGMT_OP_LOGGER.exclusiveUpperBoundExceeded(parameterName, resolved, this.upperBound.get());
                                    }
                                } else if (result > 0) {
                                    throw ControllerLogger.MGMT_OP_LOGGER.inclusiveUpperBoundExceeded(parameterName, resolved, this.upperBound.get());
                                }
                            }
                        }
                        catch (RuntimeException e) {
                            throw new OperationFailedException(e);
                        }
                    }
                }
            }
        };
    }

    public static interface Builder<T>
    extends Bounded<T> {
        public Builder<T> withLowerBound(Bound<T> var1);

        public Builder<T> withUpperBound(Bound<T> var1);

        public BoundedParameterValidator<T> build();
    }
}

