/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import java.util.Objects;
import java.util.function.Supplier;

public interface Bound<T>
extends Supplier<T> {
    public boolean isExclusive();

    default public boolean isInclusive() {
        return !this.isExclusive();
    }

    public static <T> Bound<T> inclusive(T value) {
        return new AbstractBound<T>((Object)value){

            @Override
            public boolean isExclusive() {
                return false;
            }
        };
    }

    public static <T> Bound<T> exclusive(T value) {
        return new AbstractBound<T>((Object)value){

            @Override
            public boolean isExclusive() {
                return true;
            }
        };
    }

    public static abstract class AbstractBound<T>
    implements Bound<T> {
        private T value;

        AbstractBound(T value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public T get() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object object) {
            boolean bl;
            if (object instanceof Bound) {
                Bound bound = (Bound)object;
                bl = this.get().equals(bound.get()) && this.isExclusive() == bound.isExclusive();
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return String.format("%s, %s", this.value, this.isExclusive() ? "exclusive" : "inclusive");
        }
    }
}

