/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.management;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.management.BaseHttpInterfaceResourceDefinition;
import org.jboss.as.controller.management.HttpInterfaceCommonPolicy;
import org.jboss.as.controller.management.ManagementInterfaceAddStepHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.remoting3.RemotingOptions;
import org.xnio.OptionMap;

public abstract class BaseHttpInterfaceAddStepHandler
extends ManagementInterfaceAddStepHandler {
    private static final String PROPERTY_BASE = "org.wildfly.management.";
    private static final String BACKLOG_PROPERTY = "org.wildfly.management.backlog";
    private static final String CONNECTION_HIGH_WATER_PROPERTY = "org.wildfly.management.connection-high-water";
    private static final String CONNECTION_LOW_WATER_PROPERTY = "org.wildfly.management.connection-low-water";
    private static final String NO_REQUEST_TIMEOUT_PROPERTY = "org.wildfly.management.no-request-timeout";
    public static final long DEFAULT_UPLOAD_LIMIT = 0x40000000L;
    public static final String DEFAULT_UPLOAD_LIMIT_PROPERTY = "org.wildfly.management.upload.limit";
    protected static final String HTTP_AUTHENTICATION_FACTORY_CAPABILITY = "org.wildfly.security.http-authentication-factory";
    protected static final String SASL_AUTHENTICATION_FACTORY_CAPABILITY = "org.wildfly.security.sasl-authentication-factory";
    protected static final String SSL_CONTEXT_CAPABILITY = "org.wildfly.security.ssl-context";

    @Override
    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        if (operation.hasDefined("http-upgrade-enabled")) {
            boolean httpUpgradeEnabled = operation.remove("http-upgrade-enabled").asBoolean();
            ModelNode httpUpgrade = operation.get("http-upgrade");
            if (httpUpgrade.hasDefined("enabled")) {
                boolean httpUpgradeDotEnabled = httpUpgrade.require("enabled").asBoolean();
                if (httpUpgradeEnabled != httpUpgradeDotEnabled) {
                    throw ControllerLogger.ROOT_LOGGER.deprecatedAndCurrentParameterMismatch("http-upgrade-enabled", "enabled");
                }
            } else {
                httpUpgrade.set("enabled", httpUpgradeEnabled);
            }
        }
        super.populateModel(context, operation, resource);
    }

    @Override
    public void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        LinkedHashMap constantHeaders;
        String saslAuthenticationFactory;
        boolean httpUpgradeEnabled;
        final String httpAuthenticationFactory = this.asStringIfDefined(context, BaseHttpInterfaceResourceDefinition.HTTP_AUTHENTICATION_FACTORY, model);
        final String sslContext = this.asStringIfDefined(context, BaseHttpInterfaceResourceDefinition.SSL_CONTEXT, model);
        final boolean consoleEnabled = BaseHttpInterfaceResourceDefinition.CONSOLE_ENABLED.resolveModelAttribute(context, model).asBoolean();
        if (model.hasDefined("http-upgrade")) {
            ModelNode httpUpgrade = model.require("http-upgrade");
            httpUpgradeEnabled = BaseHttpInterfaceResourceDefinition.ENABLED.resolveModelAttribute(context, httpUpgrade).asBoolean();
            saslAuthenticationFactory = this.asStringIfDefined(context, BaseHttpInterfaceResourceDefinition.SASL_AUTHENTICATION_FACTORY, httpUpgrade);
        } else {
            httpUpgradeEnabled = false;
            saslAuthenticationFactory = null;
        }
        final List<String> allowedOrigins = BaseHttpInterfaceResourceDefinition.ALLOWED_ORIGINS.unwrap(context, model);
        String serverName = this.asStringIfDefined(context, BaseHttpInterfaceResourceDefinition.SERVER_NAME, model);
        OptionMap.Builder builder = OptionMap.builder();
        builder.set(RemotingOptions.SASL_PROTOCOL, (Object)BaseHttpInterfaceResourceDefinition.SASL_PROTOCOL.resolveModelAttribute(context, model).asString());
        if (serverName != null) {
            builder.set(RemotingOptions.SERVER_NAME, (Object)serverName);
        }
        final OptionMap options = builder.getMap();
        LinkedHashMap linkedHashMap = constantHeaders = model.hasDefined("constant-headers") ? new LinkedHashMap() : null;
        if (constantHeaders != null) {
            for (ModelNode headerMapping : model.require("constant-headers").asList()) {
                String path = BaseHttpInterfaceResourceDefinition.PATH.resolveModelAttribute(context, headerMapping).asString();
                ArrayList<HttpInterfaceCommonPolicy.Header> headers = new ArrayList<HttpInterfaceCommonPolicy.Header>();
                for (ModelNode header : headerMapping.require("headers").asList()) {
                    headers.add(new HttpInterfaceCommonPolicy.Header(BaseHttpInterfaceResourceDefinition.HEADER_NAME.resolveModelAttribute(context, header).asString(), BaseHttpInterfaceResourceDefinition.HEADER_VALUE.resolveModelAttribute(context, header).asString()));
                }
                if (constantHeaders.containsKey(path)) {
                    ((List)constantHeaders.get(path)).addAll(headers);
                    continue;
                }
                constantHeaders.put(path, headers);
            }
        }
        final int backlog = BaseHttpInterfaceAddStepHandler.resolveIntProperty(BACKLOG_PROPERTY, BaseHttpInterfaceResourceDefinition.BACKLOG, context, model);
        final int noRequestTimeout = BaseHttpInterfaceAddStepHandler.resolveIntProperty(NO_REQUEST_TIMEOUT_PROPERTY, BaseHttpInterfaceResourceDefinition.NO_REQUEST_TIMEOUT, context, model);
        final int connectionHighWater = BaseHttpInterfaceAddStepHandler.resolveIntProperty(CONNECTION_HIGH_WATER_PROPERTY, BaseHttpInterfaceResourceDefinition.CONNECTION_HIGH_WATER, context, model);
        final int connectionLowWater = BaseHttpInterfaceAddStepHandler.resolveIntProperty(CONNECTION_LOW_WATER_PROPERTY, BaseHttpInterfaceResourceDefinition.CONNECTION_LOW_WATER, context, model);
        List<ServiceName> requiredServices = this.installServices(context, new HttpInterfaceCommonPolicy(){

            @Override
            public String getHttpAuthenticationFactory() {
                return httpAuthenticationFactory;
            }

            @Override
            public String getSSLContext() {
                return sslContext;
            }

            @Override
            public String getSaslAuthenticationFactory() {
                return saslAuthenticationFactory;
            }

            @Override
            public boolean isHttpUpgradeEnabled() {
                return httpUpgradeEnabled;
            }

            @Override
            public boolean isConsoleEnabled() {
                return consoleEnabled;
            }

            @Override
            public OptionMap getConnectorOptions() {
                return options;
            }

            @Override
            public List<String> getAllowedOrigins() {
                return allowedOrigins;
            }

            @Override
            public Map<String, List<HttpInterfaceCommonPolicy.Header>> getConstantHeaders() {
                return constantHeaders;
            }

            @Override
            public int getBacklog() {
                return backlog;
            }

            @Override
            public int getNoRequestTimeoutMs() {
                return noRequestTimeout;
            }

            @Override
            public int getConnectionHighWater() {
                return connectionHighWater;
            }

            @Override
            public int getConnectionLowWater() {
                return connectionLowWater;
            }
        }, model);
        this.addVerifyInstallationStep(context, requiredServices);
    }

    protected abstract List<ServiceName> installServices(OperationContext var1, HttpInterfaceCommonPolicy var2, ModelNode var3) throws OperationFailedException;

    private static int resolveIntProperty(String systemProperty, AttributeDefinition attributeDefinition, OperationContext context, ModelNode model) throws OperationFailedException {
        if (System.getProperty(systemProperty) != null) {
            if (context.enables(attributeDefinition)) {
                ControllerLogger.DEPRECATED_LOGGER.systemPropertyDeprecated(systemProperty, attributeDefinition.getName(), context.getCurrentAddress().toCLIStyleString());
            }
            return Integer.parseInt(System.getProperty(systemProperty));
        }
        return attributeDefinition.resolveModelAttribute(context, model).asInt();
    }
}

