/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.xml;

import java.util.List;
import java.util.function.Function;
import org.jboss.as.controller.xml.VersionedNamespace;
import org.jboss.as.controller.xml.VersionedSchema;
import org.jboss.as.version.Stability;
import org.jboss.staxmapper.IntVersion;

public interface IntVersionSchema<S extends IntVersionSchema<S>>
extends VersionedSchema<IntVersion, S> {
    public static final String JBOSS_IDENTIFIER = "jboss";
    public static final String WILDFLY_IDENTIFIER = "wildfly";
    public static final Function<IntVersion, String> MAJOR = new IntVersionFormatter(1);
    public static final Function<IntVersion, String> MAJOR_MINOR = new IntVersionFormatter(2);
    public static final Function<IntVersion, String> MAJOR_MINOR_MICRO = new IntVersionFormatter(3);

    public static <S extends IntVersionSchema<S>> VersionedNamespace<IntVersion, S> createURN(List<String> identifiers, IntVersion version) {
        return IntVersionSchema.createURN(identifiers, Stability.DEFAULT, version);
    }

    public static <S extends IntVersionSchema<S>> VersionedNamespace<IntVersion, S> createURN(List<String> identifiers, Stability stability, IntVersion version) {
        return VersionedNamespace.createURN(identifiers, stability, version, MAJOR_MINOR);
    }

    public static class IntVersionFormatter
    implements Function<IntVersion, String> {
        private final int segments;

        IntVersionFormatter(int segments) {
            this.segments = segments;
        }

        @Override
        public String apply(IntVersion version) {
            return version.toString(this.segments);
        }
    }
}

