/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform.description;

import java.util.Map;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationRejectionPolicy;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeTransformationDescription;
import org.jboss.as.controller.transform.description.RejectedAttributesLogContext;
import org.jboss.as.controller.transform.description.TransformationRule;
import org.jboss.dmr.ModelNode;

class OperationTransformationRules {
    static final ModelNode UNDEFINED = new ModelNode();

    OperationTransformationRules() {
    }

    static OperationTransformer createWriteOperation(Map<String, AttributeTransformationDescription> attributeTransformations) {
        return new DefaultTransformer(new WriteAttributeRule(attributeTransformations));
    }

    static OperationTransformer createUndefinedOperation(Map<String, AttributeTransformationDescription> attributeTransformations) {
        return new DefaultTransformer(new UndefineAttributeRule(attributeTransformations));
    }

    static class DefaultTransformer
    implements OperationTransformer {
        private final TransformationRule rule;

        DefaultTransformer(TransformationRule rule) {
            this.rule = rule;
        }

        @Override
        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            TransformationRule.ChainedOperationContext ctx = new TransformationRule.ChainedOperationContext(context){

                @Override
                void invokeNext(OperationTransformer.TransformedOperation transformedOperation) throws OperationFailedException {
                    this.recordTransformedOperation(transformedOperation);
                }
            };
            this.rule.transformOperation(operation, address, ctx);
            return ctx.createOp();
        }
    }

    static class WriteAttributeRule
    extends TransformationRule {
        private final Map<String, AttributeTransformationDescription> attributeTransformations;

        WriteAttributeRule(Map<String, AttributeTransformationDescription> attributeTransformations) {
            this.attributeTransformations = attributeTransformations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void transformOperation(ModelNode operation, PathAddress address, TransformationRule.ChainedOperationContext context) throws OperationFailedException {
            String attributeName = operation.require("name").asString();
            AttributeTransformationDescription description = this.attributeTransformations.get(attributeName);
            if (description == null) {
                context.invokeNext(operation);
                return;
            }
            TransformationContext ctx = context.getContext();
            ModelNode attributeValue = operation.get("value");
            if (description.shouldDiscard(address, attributeValue, operation, context)) {
                context.recordTransformedOperation(OperationTransformer.DISCARD.transformOperation(ctx, address, operation));
                return;
            }
            context.setImmutableResource(true);
            try {
                final RejectedAttributesLogContext rejectedAttributes = new RejectedAttributesLogContext(context, address, TransformationRule.cloneAndProtect(operation));
                description.rejectAttributes(rejectedAttributes, attributeValue);
                OperationRejectionPolicy policy = rejectedAttributes.hasRejections() ? new OperationRejectionPolicy(){

                    @Override
                    public boolean rejectOperation(ModelNode preparedResult) {
                        return true;
                    }

                    @Override
                    public String getFailureDescription() {
                        return rejectedAttributes.getOperationRejectDescription();
                    }
                } : OperationTransformer.DEFAULT_REJECTION_POLICY;
                description.convertValue(address, attributeValue, TransformationRule.cloneAndProtect(operation), context);
                String newName = description.getNewName();
                if (newName != null) {
                    operation.get("name").set(newName);
                }
                context.invokeNext(new OperationTransformer.TransformedOperation(operation, policy, OperationResultTransformer.ORIGINAL_RESULT));
            }
            finally {
                context.setImmutableResource(false);
            }
        }

        @Override
        void transformResource(Resource resource, PathAddress address, TransformationRule.ChainedResourceContext context) throws OperationFailedException {
        }
    }

    static class UndefineAttributeRule
    extends TransformationRule {
        private final Map<String, AttributeTransformationDescription> attributeTransformations;

        UndefineAttributeRule(Map<String, AttributeTransformationDescription> attributeTransformations) {
            this.attributeTransformations = attributeTransformations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void transformOperation(ModelNode operation, PathAddress address, TransformationRule.ChainedOperationContext context) throws OperationFailedException {
            String attributeName = operation.require("name").asString();
            AttributeTransformationDescription description = this.attributeTransformations.get(attributeName);
            if (description == null) {
                context.invokeNext(operation);
                return;
            }
            ModelNode originalModel = operation.clone();
            context.setImmutableResource(true);
            try {
                if (description.shouldDiscard(address, UNDEFINED, originalModel, context)) {
                    context.invokeNext(OperationTransformer.DISCARD.transformOperation(context.getContext(), address, operation));
                } else {
                    context.invokeNext(operation);
                }
            }
            finally {
                context.setImmutableResource(false);
            }
        }

        @Override
        void transformResource(Resource resource, PathAddress address, TransformationRule.ChainedResourceContext context) throws OperationFailedException {
        }
    }
}

