/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import javax.xml.namespace.QName;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.NotificationDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.access.Authorizer;
import org.jboss.as.controller.access.Caller;
import org.jboss.as.controller.access.Environment;
import org.jboss.as.controller.access.JmxAction;
import org.jboss.as.controller.access.JmxTarget;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.JmxAuthorizer;
import org.jboss.as.controller.audit.AuditLogger;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.NonResolvingResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.extension.ExtensionContextSupplement;
import org.jboss.as.controller.extension.ExtensionRegistryType;
import org.jboss.as.controller.extension.RuntimeHostControllerInfoAccessor;
import org.jboss.as.controller.extension.SubsystemInformation;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.NotificationEntry;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.transform.CombinedTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.controller.transform.TransformersSubRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLMapper;
import org.wildfly.security.auth.server.SecurityIdentity;

public class ExtensionRegistry {
    private static final Set<String> legallySupplemented;
    private final ProcessType processType;
    private SubsystemXmlWriterRegistry writerRegistry;
    private volatile PathManager pathManager;
    private final ConcurrentMap<String, ExtensionInfo> extensions = new ConcurrentHashMap<String, ExtensionInfo>();
    private final ConcurrentMap<String, String> reverseMap = new ConcurrentHashMap<String, String>();
    private final RunningModeControl runningModeControl;
    private final ManagedAuditLogger auditLogger;
    private final JmxAuthorizer authorizer;
    private final Supplier<SecurityIdentity> securityIdentitySupplier;
    private final ConcurrentHashMap<String, SubsystemInformation> subsystemsInfo = new ConcurrentHashMap();
    private volatile TransformerRegistry transformerRegistry = TransformerRegistry.Factory.create();
    private final RuntimeHostControllerInfoAccessor hostControllerInfoAccessor;
    private static final JmxAuthorizer NO_OP_AUTHORIZER;

    public ExtensionRegistry(ProcessType processType, RunningModeControl runningModeControl, ManagedAuditLogger auditLogger, JmxAuthorizer authorizer, Supplier<SecurityIdentity> securityIdentitySupplier, RuntimeHostControllerInfoAccessor hostControllerInfoAccessor) {
        this.processType = processType;
        this.runningModeControl = runningModeControl;
        this.auditLogger = auditLogger != null ? auditLogger : AuditLogger.NO_OP_LOGGER;
        this.authorizer = authorizer != null ? authorizer : NO_OP_AUTHORIZER;
        this.securityIdentitySupplier = securityIdentitySupplier;
        this.hostControllerInfoAccessor = hostControllerInfoAccessor;
    }

    @Deprecated
    public ExtensionRegistry(ProcessType processType, RunningModeControl runningModeControl) {
        this(processType, runningModeControl, null, null, null, RuntimeHostControllerInfoAccessor.SERVER);
    }

    public void setWriterRegistry(SubsystemXmlWriterRegistry writerRegistry) {
        this.writerRegistry = writerRegistry;
    }

    public void setPathManager(PathManager pathManager) {
        this.pathManager = pathManager;
    }

    public SubsystemInformation getSubsystemInfo(String name) {
        return this.subsystemsInfo.get(name);
    }

    public Set<String> getExtensionModuleNames() {
        return Collections.unmodifiableSet(this.extensions.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SubsystemInformation> getAvailableSubsystems(String moduleName) {
        Map result = null;
        ExtensionInfo info = (ExtensionInfo)this.extensions.get(moduleName);
        if (info != null) {
            ExtensionInfo extensionInfo = info;
            synchronized (extensionInfo) {
                result = Collections.unmodifiableMap(new HashMap(info.subsystems));
            }
        }
        return result;
    }

    public ExtensionParsingContext getExtensionParsingContext(String moduleName, XMLMapper xmlMapper) {
        return new ExtensionParsingContextImpl(moduleName, xmlMapper);
    }

    @Deprecated
    public ExtensionContext getExtensionContext(String moduleName, ManagementResourceRegistration rootRegistration, boolean isMasterDomainController) {
        ExtensionRegistryType type = isMasterDomainController ? ExtensionRegistryType.MASTER : ExtensionRegistryType.SLAVE;
        return this.getExtensionContext(moduleName, rootRegistration, type);
    }

    public ExtensionContext getExtensionContext(String moduleName, ManagementResourceRegistration rootRegistration, ExtensionRegistryType extensionRegistryType) {
        ManagementResourceRegistration profileRegistration = rootRegistration.getSubModel(PathAddress.pathAddress(PathElement.pathElement("profile")));
        if (profileRegistration == null) {
            profileRegistration = rootRegistration;
        }
        ManagementResourceRegistration deploymentsRegistration = this.processType.isServer() ? rootRegistration.getSubModel(PathAddress.pathAddress(PathElement.pathElement("deployment"))) : null;
        boolean allowSupplement = legallySupplemented.contains(moduleName);
        ManagedAuditLogger al = allowSupplement ? this.auditLogger : null;
        return new ExtensionContextImpl(moduleName, profileRegistration, deploymentsRegistration, this.pathManager, extensionRegistryType, al);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ProfileParsingCompletionHandler> getProfileParsingCompletionHandlers() {
        HashSet<ProfileParsingCompletionHandler> result = new HashSet<ProfileParsingCompletionHandler>();
        Iterator iterator = this.extensions.values().iterator();
        while (iterator.hasNext()) {
            ExtensionInfo extensionInfo;
            ExtensionInfo extensionInfo2 = extensionInfo = (ExtensionInfo)iterator.next();
            synchronized (extensionInfo2) {
                if (extensionInfo.parsingCompletionHandler != null) {
                    result.add(extensionInfo.parsingCompletionHandler);
                }
            }
        }
        return Collections.unmodifiableSet(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExtension(Resource rootResource, String moduleName, ManagementResourceRegistration rootRegistration) throws IllegalStateException {
        ManagementResourceRegistration profileReg;
        if (rootRegistration.getPathAddress().size() == 0) {
            ManagementResourceRegistration reg = rootRegistration.getSubModel(PathAddress.pathAddress(PathElement.pathElement("profile")));
            if (reg == null) {
                reg = rootRegistration;
            }
            profileReg = reg;
        } else {
            profileReg = rootRegistration;
        }
        ManagementResourceRegistration deploymentsReg = this.processType.isServer() ? rootRegistration.getSubModel(PathAddress.pathAddress(PathElement.pathElement("deployment"))) : null;
        ExtensionInfo extension = (ExtensionInfo)this.extensions.remove(moduleName);
        if (extension != null) {
            ExtensionInfo extensionInfo = extension;
            synchronized (extensionInfo) {
                Set subsystemNames = extension.subsystems.keySet();
                boolean dcExtension = this.processType.isHostController() ? rootRegistration.getPathAddress().size() == 0 : false;
                for (String string : subsystemNames) {
                    if (!this.hasSubsystemsRegistered(rootResource, string, dcExtension)) continue;
                    this.extensions.put(moduleName, extension);
                    throw ControllerLogger.ROOT_LOGGER.removingExtensionWithRegisteredSubsystem(moduleName, string);
                }
                for (Map.Entry entry : extension.subsystems.entrySet()) {
                    String subsystem = (String)entry.getKey();
                    profileReg.unregisterSubModel(PathElement.pathElement("subsystem", subsystem));
                    if (deploymentsReg != null) {
                        deploymentsReg.unregisterSubModel(PathElement.pathElement("subsystem", subsystem));
                        deploymentsReg.unregisterSubModel(PathElement.pathElement("subdeployment", subsystem));
                    }
                    if (extension.xmlMapper == null) continue;
                    SubsystemInformationImpl subsystemInformation = (SubsystemInformationImpl)SubsystemInformationImpl.class.cast(entry.getValue());
                    for (String namespace : subsystemInformation.getXMLNamespaces()) {
                        extension.xmlMapper.unregisterRootElement(new QName(namespace, "subsystem"));
                    }
                }
            }
        }
    }

    private boolean hasSubsystemsRegistered(Resource rootResource, String subsystem, boolean dcExtension) {
        if (!dcExtension) {
            return rootResource.getChild(PathElement.pathElement("subsystem", subsystem)) != null;
        }
        for (Resource resource : rootResource.getChildren("profile")) {
            if (resource.getChild(PathElement.pathElement("subsystem", subsystem)) == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ConcurrentMap<String, ExtensionInfo> concurrentMap = this.extensions;
        synchronized (concurrentMap) {
            this.transformerRegistry = TransformerRegistry.Factory.create();
            this.extensions.clear();
            this.reverseMap.clear();
            this.subsystemsInfo.clear();
        }
    }

    public void recordSubsystemVersions(String moduleName, ModelNode subsystems) {
        Map<String, SubsystemInformation> subsystemsInfo = this.getAvailableSubsystems(moduleName);
        if (subsystemsInfo != null && !subsystemsInfo.isEmpty()) {
            for (Map.Entry<String, SubsystemInformation> entry : subsystemsInfo.entrySet()) {
                SubsystemInformation subsystem = entry.getValue();
                subsystems.add(entry.getKey(), subsystem.getManagementInterfaceMajorVersion() + "." + subsystem.getManagementInterfaceMinorVersion() + "." + subsystem.getManagementInterfaceMicroVersion());
            }
        }
    }

    private ExtensionInfo getExtensionInfo(String extensionModuleName) {
        ExtensionInfo result = (ExtensionInfo)this.extensions.get(extensionModuleName);
        if (result == null) {
            result = new ExtensionInfo(extensionModuleName);
            ExtensionInfo existing = this.extensions.putIfAbsent(extensionModuleName, result);
            result = existing == null ? result : existing;
        }
        return result;
    }

    private void checkNewSubystem(String extensionModuleName, String subsystemName) {
        String existingModule = this.reverseMap.putIfAbsent(subsystemName, extensionModuleName);
        if (existingModule != null && !extensionModuleName.equals(existingModule)) {
            throw ControllerLogger.ROOT_LOGGER.duplicateSubsystem(subsystemName, extensionModuleName, existingModule);
        }
    }

    public TransformerRegistry getTransformerRegistry() {
        return this.transformerRegistry;
    }

    static {
        HashSet<String> set = new HashSet<String>(4);
        set.add("org.jboss.as.jmx");
        set.add("Test");
        legallySupplemented = Collections.unmodifiableSet(set);
        NO_OP_AUTHORIZER = new JmxAuthorizer(){

            @Override
            public AuthorizationResult authorize(Caller caller, Environment callEnvironment, Action action, TargetResource target) {
                return AuthorizationResult.PERMITTED;
            }

            @Override
            public Authorizer.AuthorizerDescription getDescription() {
                return new Authorizer.AuthorizerDescription(){

                    @Override
                    public boolean isRoleBased() {
                        return false;
                    }

                    @Override
                    public Set<String> getStandardRoles() {
                        return Collections.emptySet();
                    }
                };
            }

            @Override
            public AuthorizationResult authorize(Caller caller, Environment callEnvironment, Action action, TargetAttribute target) {
                return AuthorizationResult.PERMITTED;
            }

            @Override
            public AuthorizationResult authorizeJmxOperation(Caller caller, Environment callEnvironment, JmxAction action, JmxTarget target) {
                return AuthorizationResult.PERMITTED;
            }

            @Override
            public Set<String> getCallerRoles(Caller caller, Environment callEnvironment, Set<String> runAsRoles) {
                return null;
            }

            @Override
            public void setNonFacadeMBeansSensitive(boolean sensitive) {
            }

            @Override
            public boolean isNonFacadeMBeansSensitive() {
                return false;
            }
        };
    }

    private static class DeploymentManagementResourceRegistration
    implements ManagementResourceRegistration {
        private final ManagementResourceRegistration deployments;
        private final ManagementResourceRegistration subdeployments;

        @Override
        public boolean isOrderedChildResource() {
            return false;
        }

        @Override
        public Set<String> getOrderedChildTypes() {
            return Collections.emptySet();
        }

        private DeploymentManagementResourceRegistration(ManagementResourceRegistration deployments, ManagementResourceRegistration subdeployments) {
            this.deployments = deployments;
            this.subdeployments = subdeployments;
        }

        @Override
        public PathAddress getPathAddress() {
            return this.deployments.getPathAddress();
        }

        @Override
        public ProcessType getProcessType() {
            return this.deployments.getProcessType();
        }

        @Override
        public ImmutableManagementResourceRegistration getParent() {
            ManagementResourceRegistration deplParent = (ManagementResourceRegistration)this.deployments.getParent();
            ManagementResourceRegistration subParent = (ManagementResourceRegistration)this.subdeployments.getParent();
            if (this.deployments == subParent) {
                return deplParent;
            }
            return new DeploymentManagementResourceRegistration(deplParent, subParent);
        }

        @Override
        public int getMaxOccurs() {
            return this.deployments.getMaxOccurs();
        }

        @Override
        public int getMinOccurs() {
            return this.deployments.getMinOccurs();
        }

        @Override
        public boolean isRuntimeOnly() {
            return this.deployments.isRuntimeOnly();
        }

        @Override
        public void setRuntimeOnly(boolean runtimeOnly) {
            this.deployments.setRuntimeOnly(runtimeOnly);
            this.subdeployments.setRuntimeOnly(runtimeOnly);
        }

        @Override
        public boolean isRemote() {
            return this.deployments.isRemote();
        }

        @Override
        public OperationStepHandler getOperationHandler(PathAddress address, String operationName) {
            return this.deployments.getOperationHandler(address, operationName);
        }

        @Override
        public DescriptionProvider getOperationDescription(PathAddress address, String operationName) {
            return this.deployments.getOperationDescription(address, operationName);
        }

        @Override
        public Set<OperationEntry.Flag> getOperationFlags(PathAddress address, String operationName) {
            return this.deployments.getOperationFlags(address, operationName);
        }

        @Override
        public OperationEntry getOperationEntry(PathAddress address, String operationName) {
            return this.deployments.getOperationEntry(address, operationName);
        }

        @Override
        public Set<String> getAttributeNames(PathAddress address) {
            return this.deployments.getAttributeNames(address);
        }

        @Override
        public AttributeAccess getAttributeAccess(PathAddress address, String attributeName) {
            return this.deployments.getAttributeAccess(address, attributeName);
        }

        @Override
        public Map<String, NotificationEntry> getNotificationDescriptions(PathAddress address, boolean inherited) {
            return this.deployments.getNotificationDescriptions(address, inherited);
        }

        @Override
        public Set<String> getChildNames(PathAddress address) {
            return this.deployments.getChildNames(address);
        }

        @Override
        public Set<PathElement> getChildAddresses(PathAddress address) {
            return this.deployments.getChildAddresses(address);
        }

        @Override
        public DescriptionProvider getModelDescription(PathAddress address) {
            return this.deployments.getModelDescription(address);
        }

        @Override
        public Map<String, OperationEntry> getOperationDescriptions(PathAddress address, boolean inherited) {
            return this.deployments.getOperationDescriptions(address, inherited);
        }

        @Override
        public ProxyController getProxyController(PathAddress address) {
            return this.deployments.getProxyController(address);
        }

        @Override
        public Set<ProxyController> getProxyControllers(PathAddress address) {
            return this.deployments.getProxyControllers(address);
        }

        @Override
        public ManagementResourceRegistration getOverrideModel(String name) {
            return this.deployments.getOverrideModel(name);
        }

        @Override
        public ManagementResourceRegistration getSubModel(PathAddress address) {
            return this.deployments.getSubModel(address);
        }

        @Override
        public List<AccessConstraintDefinition> getAccessConstraints() {
            return this.deployments.getAccessConstraints();
        }

        @Override
        public ManagementResourceRegistration registerSubModel(ResourceDefinition resourceDefinition) {
            ManagementResourceRegistration depl = this.deployments.registerSubModel(resourceDefinition);
            ManagementResourceRegistration subdepl = this.subdeployments.registerSubModel(resourceDefinition);
            return new DeploymentManagementResourceRegistration(depl, subdepl);
        }

        @Override
        public void unregisterSubModel(PathElement address) {
            this.deployments.unregisterSubModel(address);
            this.subdeployments.unregisterSubModel(address);
        }

        @Override
        public boolean isAllowsOverride() {
            return this.deployments.isAllowsOverride();
        }

        @Override
        public ManagementResourceRegistration registerOverrideModel(String name, OverrideDescriptionProvider descriptionProvider) {
            ManagementResourceRegistration depl = this.deployments.registerOverrideModel(name, descriptionProvider);
            ManagementResourceRegistration subdepl = this.subdeployments.registerOverrideModel(name, descriptionProvider);
            return new DeploymentManagementResourceRegistration(depl, subdepl);
        }

        @Override
        public void unregisterOverrideModel(String name) {
            this.deployments.unregisterOverrideModel(name);
            this.subdeployments.unregisterOverrideModel(name);
        }

        @Override
        public void registerOperationHandler(OperationDefinition definition, OperationStepHandler handler) {
            this.registerOperationHandler(definition, handler, false);
        }

        @Override
        public void registerOperationHandler(OperationDefinition definition, OperationStepHandler handler, boolean inherited) {
            this.deployments.registerOperationHandler(definition, handler, inherited);
            this.subdeployments.registerOperationHandler(definition, handler, inherited);
        }

        @Override
        public void unregisterOperationHandler(String operationName) {
            this.deployments.unregisterOperationHandler(operationName);
            this.subdeployments.unregisterOperationHandler(operationName);
        }

        @Override
        public void registerReadWriteAttribute(AttributeDefinition definition, OperationStepHandler readHandler, OperationStepHandler writeHandler) {
            this.deployments.registerReadWriteAttribute(definition, readHandler, writeHandler);
            this.subdeployments.registerReadWriteAttribute(definition, readHandler, writeHandler);
        }

        @Override
        public void registerReadOnlyAttribute(AttributeDefinition definition, OperationStepHandler readHandler) {
            this.deployments.registerReadOnlyAttribute(definition, readHandler);
            this.subdeployments.registerReadOnlyAttribute(definition, readHandler);
        }

        @Override
        public void registerMetric(AttributeDefinition definition, OperationStepHandler metricHandler) {
            this.deployments.registerMetric(definition, metricHandler);
            this.subdeployments.registerMetric(definition, metricHandler);
        }

        @Override
        public void unregisterAttribute(String attributeName) {
            this.deployments.unregisterAttribute(attributeName);
            this.subdeployments.unregisterAttribute(attributeName);
        }

        @Override
        public void registerNotification(NotificationDefinition notification, boolean inherited) {
            this.deployments.registerNotification(notification, inherited);
            this.subdeployments.registerNotification(notification, inherited);
        }

        @Override
        public void registerNotification(NotificationDefinition notification) {
            this.deployments.registerNotification(notification);
            this.subdeployments.registerNotification(notification);
        }

        @Override
        public void unregisterNotification(String notificationType) {
            this.deployments.unregisterNotification(notificationType);
            this.subdeployments.unregisterNotification(notificationType);
        }

        @Override
        public void registerProxyController(PathElement address, ProxyController proxyController) {
            this.deployments.registerProxyController(address, proxyController);
            this.subdeployments.registerProxyController(address, proxyController);
        }

        @Override
        public void unregisterProxyController(PathElement address) {
            this.deployments.unregisterProxyController(address);
            this.subdeployments.unregisterProxyController(address);
        }

        @Override
        public void registerAlias(PathElement address, AliasEntry alias) {
            this.deployments.registerAlias(address, alias);
            this.subdeployments.registerAlias(address, alias);
        }

        @Override
        public void unregisterAlias(PathElement address) {
            this.deployments.unregisterAlias(address);
            this.subdeployments.unregisterAlias(address);
        }

        @Override
        public void registerCapability(RuntimeCapability capability) {
            this.deployments.registerCapability(capability);
            this.subdeployments.registerCapability(capability);
        }

        @Override
        public void registerIncorporatingCapabilities(Set<RuntimeCapability> capabilities) {
            this.deployments.registerIncorporatingCapabilities(capabilities);
            this.subdeployments.registerIncorporatingCapabilities(capabilities);
        }

        @Override
        public AliasEntry getAliasEntry() {
            return this.deployments.getAliasEntry();
        }

        @Override
        public boolean isAlias() {
            return this.deployments.isAlias();
        }

        @Override
        public Set<RuntimeCapability> getCapabilities() {
            return this.deployments.getCapabilities();
        }

        @Override
        public Set<RuntimeCapability> getIncorporatingCapabilities() {
            return this.deployments.getIncorporatingCapabilities();
        }
    }

    private class ExtensionInfo {
        private final Map<String, SubsystemInformation> subsystems = new HashMap<String, SubsystemInformation>();
        private final String extensionModuleName;
        private XMLMapper xmlMapper;
        private ProfileParsingCompletionHandler parsingCompletionHandler;

        public ExtensionInfo(String extensionModuleName) {
            this.extensionModuleName = extensionModuleName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SubsystemInformationImpl getSubsystemInfo(String subsystemName) {
            ExtensionRegistry.this.checkNewSubystem(this.extensionModuleName, subsystemName);
            ExtensionInfo extensionInfo = this;
            synchronized (extensionInfo) {
                SubsystemInformationImpl subsystem = (SubsystemInformationImpl)SubsystemInformationImpl.class.cast(this.subsystems.get(subsystemName));
                if (subsystem == null) {
                    subsystem = new SubsystemInformationImpl();
                    this.subsystems.put(subsystemName, subsystem);
                }
                return subsystem;
            }
        }
    }

    private class SubsystemRegistrationImpl
    implements SubsystemRegistration {
        private final String name;
        private final ModelVersion version;
        private final ManagementResourceRegistration profileRegistration;
        private final ManagementResourceRegistration deploymentsRegistration;
        private final ExtensionRegistryType extensionRegistryType;
        private final String extensionModuleName;
        private volatile boolean hostCapable;
        private volatile boolean modelsRegistered;

        private SubsystemRegistrationImpl(String name, ModelVersion version, ManagementResourceRegistration profileRegistration, ManagementResourceRegistration deploymentsRegistration, ExtensionRegistryType extensionRegistryType, String extensionModuleName, ProcessType processType) {
            assert (profileRegistration != null);
            this.name = name;
            this.profileRegistration = profileRegistration;
            this.deploymentsRegistration = deploymentsRegistration == null ? ManagementResourceRegistration.Factory.forProcessType(processType).createRegistration(new SimpleResourceDefinition(null, NonResolvingResourceDescriptionResolver.INSTANCE)) : deploymentsRegistration;
            this.version = version;
            this.extensionRegistryType = extensionRegistryType;
            this.extensionModuleName = extensionModuleName;
        }

        @Override
        public void setHostCapable() {
            if (this.modelsRegistered) {
                throw ControllerLogger.ROOT_LOGGER.registerHostCapableMustHappenFirst(this.name);
            }
            this.hostCapable = true;
        }

        @Override
        public ManagementResourceRegistration registerSubsystemModel(ResourceDefinition resourceDefinition) {
            assert (resourceDefinition != null) : "resourceDefinition is null";
            this.checkHostCapable();
            return this.profileRegistration.registerSubModel(resourceDefinition);
        }

        @Override
        public ManagementResourceRegistration registerDeploymentModel(ResourceDefinition resourceDefinition) {
            assert (resourceDefinition != null) : "resourceDefinition is null";
            return this.deploymentsRegistration.registerSubModel(resourceDefinition);
        }

        @Override
        public void registerXMLElementWriter(XMLElementWriter<SubsystemMarshallingContext> writer) {
            ExtensionRegistry.this.writerRegistry.registerSubsystemWriter(this.name, writer);
        }

        @Override
        public void registerXMLElementWriter(Supplier<XMLElementWriter<SubsystemMarshallingContext>> writer) {
            ExtensionRegistry.this.writerRegistry.registerSubsystemWriter(this.name, writer);
        }

        @Override
        public TransformersSubRegistration registerModelTransformers(ModelVersionRange range, ResourceTransformer subsystemTransformer) {
            this.modelsRegistered = true;
            this.checkHostCapable();
            return ExtensionRegistry.this.transformerRegistry.registerSubsystemTransformers(this.name, range, subsystemTransformer);
        }

        @Override
        public TransformersSubRegistration registerModelTransformers(ModelVersionRange version, ResourceTransformer resourceTransformer, OperationTransformer operationTransformer, boolean placeholder) {
            this.modelsRegistered = true;
            this.checkHostCapable();
            return ExtensionRegistry.this.transformerRegistry.registerSubsystemTransformers(this.name, version, resourceTransformer, operationTransformer, placeholder);
        }

        @Override
        @Deprecated
        public TransformersSubRegistration registerModelTransformers(ModelVersionRange version, ResourceTransformer resourceTransformer, OperationTransformer operationTransformer) {
            this.modelsRegistered = true;
            this.checkHostCapable();
            return ExtensionRegistry.this.transformerRegistry.registerSubsystemTransformers(this.name, version, resourceTransformer, operationTransformer, false);
        }

        @Override
        public TransformersSubRegistration registerModelTransformers(ModelVersionRange version, CombinedTransformer combinedTransformer) {
            this.modelsRegistered = true;
            this.checkHostCapable();
            return ExtensionRegistry.this.transformerRegistry.registerSubsystemTransformers(this.name, version, combinedTransformer, combinedTransformer, false);
        }

        @Override
        public ModelVersion getSubsystemVersion() {
            return this.version;
        }

        private void checkHostCapable() {
            if (this.extensionRegistryType == ExtensionRegistryType.HOST && !this.hostCapable) {
                throw ControllerLogger.ROOT_LOGGER.nonHostCapableSubsystemInHostModel(this.name, this.extensionModuleName);
            }
        }
    }

    private class SubsystemInformationImpl
    implements SubsystemInformation {
        private ModelVersion version;
        private final List<String> parsingNamespaces = new ArrayList<String>();

        private SubsystemInformationImpl() {
        }

        @Override
        public List<String> getXMLNamespaces() {
            return Collections.unmodifiableList(this.parsingNamespaces);
        }

        void addParsingNamespace(String namespace) {
            this.parsingNamespaces.add(namespace);
        }

        @Override
        public Integer getManagementInterfaceMajorVersion() {
            return this.version != null ? Integer.valueOf(this.version.getMajor()) : null;
        }

        @Override
        public Integer getManagementInterfaceMinorVersion() {
            return this.version != null ? Integer.valueOf(this.version.getMinor()) : null;
        }

        @Override
        public Integer getManagementInterfaceMicroVersion() {
            return this.version != null ? Integer.valueOf(this.version.getMicro()) : null;
        }

        @Override
        public ModelVersion getManagementInterfaceVersion() {
            return this.version;
        }

        private void setVersion(ModelVersion version) {
            this.version = version;
        }
    }

    private class ExtensionContextImpl
    implements ExtensionContext,
    ExtensionContextSupplement {
        private final ExtensionInfo extension;
        private final PathManager pathManager;
        private final boolean registerTransformers;
        private final ManagedAuditLogger auditLogger;
        private final boolean allowSupplement;
        private final ManagementResourceRegistration profileRegistration;
        private final ManagementResourceRegistration deploymentsRegistration;
        private final ExtensionRegistryType extensionRegistryType;

        private ExtensionContextImpl(String extensionName, ManagementResourceRegistration profileResourceRegistration, ManagementResourceRegistration deploymentsResourceRegistration, PathManager pathManager, ExtensionRegistryType extensionRegistryType, ManagedAuditLogger auditLogger) {
            PathAddress subdepAddress;
            ManagementResourceRegistration subdeployments;
            assert (pathManager != null || !ExtensionRegistry.this.processType.isServer()) : "pathManager is null";
            this.pathManager = pathManager;
            this.extension = ExtensionRegistry.this.getExtensionInfo(extensionName);
            this.registerTransformers = extensionRegistryType == ExtensionRegistryType.MASTER;
            this.auditLogger = auditLogger;
            this.allowSupplement = auditLogger != null;
            this.profileRegistration = profileResourceRegistration;
            this.deploymentsRegistration = deploymentsResourceRegistration != null ? ((subdeployments = deploymentsResourceRegistration.getSubModel(subdepAddress = PathAddress.pathAddress(PathElement.pathElement("subdeployment")))) == null ? deploymentsResourceRegistration : new DeploymentManagementResourceRegistration(deploymentsResourceRegistration, subdeployments)) : null;
            this.extensionRegistryType = extensionRegistryType;
        }

        @Override
        public SubsystemRegistration registerSubsystem(String name, ModelVersion version) {
            return this.registerSubsystem(name, version, false);
        }

        @Override
        @Deprecated
        public SubsystemRegistration registerSubsystem(String name, int majorVersion, int minorVersion) throws IllegalArgumentException, IllegalStateException {
            return this.registerSubsystem(name, majorVersion, minorVersion, 0);
        }

        @Override
        @Deprecated
        public SubsystemRegistration registerSubsystem(String name, int majorVersion, int minorVersion, int microVersion) {
            return this.registerSubsystem(name, majorVersion, minorVersion, microVersion, false);
        }

        @Override
        @Deprecated
        public SubsystemRegistration registerSubsystem(String name, int majorVersion, int minorVersion, int microVersion, boolean deprecated) {
            return this.registerSubsystem(name, ModelVersion.create(majorVersion, minorVersion, microVersion), deprecated);
        }

        @Override
        public SubsystemRegistration registerSubsystem(String name, ModelVersion version, boolean deprecated) {
            assert (name != null) : "name is null";
            ExtensionRegistry.this.checkNewSubystem(this.extension.extensionModuleName, name);
            SubsystemInformationImpl info = this.extension.getSubsystemInfo(name);
            info.setVersion(version);
            ExtensionRegistry.this.subsystemsInfo.put(name, info);
            if (deprecated) {
                ControllerLogger.DEPRECATED_LOGGER.extensionDeprecated(name);
            }
            SubsystemRegistrationImpl result = new SubsystemRegistrationImpl(name, version, this.profileRegistration, this.deploymentsRegistration, this.extensionRegistryType, this.extension.extensionModuleName, ExtensionRegistry.this.processType);
            if (this.registerTransformers) {
                ExtensionRegistry.this.transformerRegistry.loadAndRegisterTransformers(name, version, this.extension.extensionModuleName);
            }
            return result;
        }

        @Override
        public ProcessType getProcessType() {
            return ExtensionRegistry.this.processType;
        }

        @Override
        public RunningMode getRunningMode() {
            return ExtensionRegistry.this.runningModeControl.getRunningMode();
        }

        @Override
        public boolean isRuntimeOnlyRegistrationValid() {
            if (ExtensionRegistry.this.processType.isServer()) {
                return true;
            }
            return ExtensionRegistry.this.processType.isHostController() && this.extensionRegistryType == ExtensionRegistryType.HOST;
        }

        @Override
        public PathManager getPathManager() {
            if (!ExtensionRegistry.this.processType.isServer()) {
                throw ControllerLogger.ROOT_LOGGER.pathManagerNotAvailable(ExtensionRegistry.this.processType);
            }
            return this.pathManager;
        }

        @Override
        @Deprecated
        public boolean isRegisterTransformers() {
            return this.registerTransformers;
        }

        @Override
        public AuditLogger getAuditLogger(boolean inheritConfiguration, boolean manualCommit) {
            if (!this.allowSupplement) {
                throw new UnsupportedOperationException();
            }
            if (inheritConfiguration) {
                return this.auditLogger;
            }
            return this.auditLogger.createNewConfiguration(manualCommit);
        }

        @Override
        public JmxAuthorizer getAuthorizer() {
            if (!this.allowSupplement) {
                throw new UnsupportedOperationException();
            }
            return ExtensionRegistry.this.authorizer;
        }

        @Override
        public Supplier<SecurityIdentity> getSecurityIdentitySupplier() {
            if (!this.allowSupplement) {
                throw new UnsupportedOperationException();
            }
            return ExtensionRegistry.this.securityIdentitySupplier;
        }

        @Override
        public RuntimeHostControllerInfoAccessor getHostControllerInfoAccessor() {
            if (!this.allowSupplement) {
                throw new UnsupportedOperationException();
            }
            return ExtensionRegistry.this.hostControllerInfoAccessor;
        }
    }

    private class ExtensionParsingContextImpl
    implements ExtensionParsingContext {
        private final ExtensionInfo extension;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ExtensionParsingContextImpl(String extensionName, XMLMapper xmlMapper) {
            this.extension = ExtensionRegistry.this.getExtensionInfo(extensionName);
            if (xmlMapper != null) {
                ExtensionInfo extensionInfo = this.extension;
                synchronized (extensionInfo) {
                    this.extension.xmlMapper = xmlMapper;
                }
            }
        }

        @Override
        public ProcessType getProcessType() {
            return ExtensionRegistry.this.processType;
        }

        @Override
        public RunningMode getRunningMode() {
            return ExtensionRegistry.this.runningModeControl.getRunningMode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSubsystemXmlMapping(String subsystemName, String namespaceUri, XMLElementReader<List<ModelNode>> reader) {
            assert (subsystemName != null) : "subsystemName is null";
            assert (namespaceUri != null) : "namespaceUri is null";
            ExtensionInfo extensionInfo = this.extension;
            synchronized (extensionInfo) {
                this.extension.getSubsystemInfo(subsystemName).addParsingNamespace(namespaceUri);
                if (this.extension.xmlMapper != null) {
                    this.extension.xmlMapper.registerRootElement(new QName(namespaceUri, "subsystem"), reader);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSubsystemXmlMapping(String subsystemName, String namespaceUri, Supplier<XMLElementReader<List<ModelNode>>> supplier) {
            assert (subsystemName != null) : "subsystemName is null";
            assert (namespaceUri != null) : "namespaceUri is null";
            ExtensionInfo extensionInfo = this.extension;
            synchronized (extensionInfo) {
                this.extension.getSubsystemInfo(subsystemName).addParsingNamespace(namespaceUri);
                if (this.extension.xmlMapper != null) {
                    this.extension.xmlMapper.registerRootElement(new QName(namespaceUri, "subsystem"), supplier);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setProfileParsingCompletionHandler(ProfileParsingCompletionHandler handler) {
            assert (handler != null) : "handler is null";
            ExtensionInfo extensionInfo = this.extension;
            synchronized (extensionInfo) {
                this.extension.parsingCompletionHandler = handler;
            }
        }
    }
}

