/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.services.path;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.security.manager.WildFlySecurityManager;

public class PathInfoHandler
extends AbstractRuntimeOnlyHandler {
    private static final DateTimeFormatter DATE_FORMAT = new DateTimeFormatterBuilder().appendInstant().appendZoneId().toFormatter(Locale.ENGLISH);
    private static final ZoneId ZONE_ID = ZoneId.of(Calendar.getInstance().getTimeZone().getID());
    private static final String USED_SPACE = "used-space";
    private static final String AVAILABLE_SPACE = "available-space";
    private static final String RESOLVED_PATH = "resolved-path";
    private static final String LAST_MODIFIED = "last-modified";
    private static final String CREATION_TIME = "creation-time";
    private static final String OPERATION_NAME = "path-info";
    private static final String FILESYSTEM = "filesystem";
    private static final AttributeDefinition UNIT_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("unit", ModelType.STRING, true).setAllowedValues(MeasurementUnit.BYTES.getName(), MeasurementUnit.KILOBYTES.getName(), MeasurementUnit.MEGABYTES.getName(), MeasurementUnit.GIGABYTES.getName(), MeasurementUnit.TERABYTES.getName(), MeasurementUnit.PETABYTES.getName(), MeasurementUnit.BITS.getName(), MeasurementUnit.KILOBITS.getName(), MeasurementUnit.MEGABITS.getName(), MeasurementUnit.GIGABITS.getName(), MeasurementUnit.TERABITS.getName(), MeasurementUnit.PETABITS.getName())).setDefaultValue(new ModelNode(MeasurementUnit.BYTES.getName()))).build();
    private final List<RelativePathSizeAttribute> relativePathAttributes;
    private final PathManager pathManager;
    private final AttributeDefinition parentAttribute;

    private PathInfoHandler(PathManager pathManager, AttributeDefinition parentAttribute, List<RelativePathSizeAttribute> relativePathAttributes) {
        this.relativePathAttributes = relativePathAttributes;
        this.parentAttribute = parentAttribute;
        this.pathManager = pathManager;
    }

    @Override
    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode unitModelNode = UNIT_ATTRIBUTE.resolveModelAttribute(context, operation);
        MeasurementUnit sizeUnit = MeasurementUnit.BYTES;
        if (unitModelNode.isDefined()) {
            try {
                sizeUnit = MeasurementUnit.valueOf((String)unitModelNode.asString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        ModelNode metric = new ModelNode();
        for (RelativePathSizeAttribute relativePathAttribute : this.relativePathAttributes) {
            String result;
            ModelNode path;
            ModelNode relativeTo;
            String replyParameterName = relativePathAttribute.pathAttribute.getName();
            try {
                relativeTo = this.readAttributeValue(context, relativePathAttribute.relativeToAttribute);
                path = this.readAttributeValue(context, relativePathAttribute.pathAttribute);
            }
            catch (OperationFailedException ex) {
                return;
            }
            if (relativeTo.isDefined()) {
                result = path.isDefined() ? this.pathManager.resolveRelativePathEntry(path.asString(), relativeTo.asString()) : this.pathManager.getPathEntry(relativeTo.asString()).resolvePath();
            } else if (path.isDefined()) {
                result = this.pathManager != null ? this.pathManager.resolveRelativePathEntry(path.asString(), null) : path.asString();
            } else {
                throw ControllerLogger.ROOT_LOGGER.noPathToResolve(relativePathAttribute.relativeToAttribute.getName(), replyParameterName, model);
            }
            Double offset = MeasurementUnit.calculateOffset((MeasurementUnit)MeasurementUnit.BYTES, (MeasurementUnit)sizeUnit);
            try {
                Path folder = new File(result).toPath();
                PathSizeWalker walker = new PathSizeWalker();
                Files.walkFileTree(folder, walker);
                ModelNode replyParameterNode = this.parentAttribute != null ? metric.get(this.parentAttribute.getName()).get(replyParameterName) : metric.get(replyParameterName);
                replyParameterNode.get(USED_SPACE).set(new ModelNode(offset * walker.getSize().doubleValue()));
                if (!Files.exists(folder, new LinkOption[0])) continue;
                BasicFileAttributes attributes = Files.getFileAttributeView(folder, BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
                replyParameterNode.get(RESOLVED_PATH).set(folder.toAbsolutePath().toString());
                replyParameterNode.get(CREATION_TIME).set(DATE_FORMAT.format(attributes.creationTime().toInstant().atZone(ZONE_ID)));
                replyParameterNode.get(LAST_MODIFIED).set(DATE_FORMAT.format(attributes.lastModifiedTime().toInstant().atZone(ZONE_ID)));
                replyParameterNode.get(AVAILABLE_SPACE).set(new ModelNode(offset * (double)Files.getFileStore(folder).getUsableSpace()));
            }
            catch (IOException ex) {
                throw new OperationFailedException(ex);
            }
        }
        context.getResult().set(metric);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelNode readAttributeValue(OperationContext context, AttributeDefinition attribute) throws OperationFailedException {
        ModelNode path;
        String attributeName;
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        if (this.parentAttribute != null && !this.parentAttribute.equals(attribute)) {
            model = this.readAttributeValue(context, this.parentAttribute);
        }
        if (model.hasDefined(attributeName = attribute.getName())) {
            return attribute.resolveModelAttribute(context, model);
        }
        AttributeAccess access = context.getResourceRegistration().getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName);
        if (access == null) {
            return new ModelNode();
        }
        OperationStepHandler handler = access.getReadHandler();
        if (handler != null) {
            ClassLoader oldTccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(handler.getClass());
            try {
                handler.execute(context, Util.getReadAttributeOperation(context.getCurrentAddress(), attributeName));
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
            }
            path = context.getResult().clone();
            context.getResult().setEmptyObject();
        } else {
            path = new ModelNode();
        }
        return path;
    }

    public static void registerOperation(ManagementResourceRegistration resourceRegistration, PathInfoHandler handler) {
        PathInfoHandler.registerOperation(resourceRegistration, MeasurementUnit.BYTES, handler);
    }

    private static void registerOperation(ManagementResourceRegistration resourceRegistration, MeasurementUnit unit, PathInfoHandler handler) {
        List<AttributeDefinition> replyParameters = handler.relativePathAttributes.stream().map(att -> ObjectTypeAttributeDefinition.Builder.of(((RelativePathSizeAttribute)att).pathAttribute.getName(), ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create(USED_SPACE, ModelType.DOUBLE, false).setUndefinedMetricValue(new ModelNode(0.0))).setMeasurementUnit(unit)).setStorageRuntime()).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create(CREATION_TIME, ModelType.STRING, false).setStorageRuntime()).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create(LAST_MODIFIED, ModelType.STRING, false).setStorageRuntime()).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create(RESOLVED_PATH, ModelType.STRING, false).setStorageRuntime()).build(), ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create(AVAILABLE_SPACE, ModelType.DOUBLE, false).setMeasurementUnit(unit)).setStorageRuntime()).build()).build()).collect(Collectors.toList());
        SimpleOperationDefinition operation = new SimpleOperationDefinitionBuilder(OPERATION_NAME, new DiskUsagePathResourceDescriptionResolver(OPERATION_NAME, replyParameters)).addParameter(UNIT_ATTRIBUTE).setReadOnly().setRuntimeOnly().setReplyType(ModelType.OBJECT).setReplyParameters(replyParameters.toArray(new AttributeDefinition[replyParameters.size()])).build();
        resourceRegistration.registerOperationHandler(operation, handler);
    }

    private static class DiskUsagePathResourceDescriptionResolver
    extends StandardResourceDescriptionResolver {
        private final String operationName;
        private final Set<String> replyParameterKeys;

        public DiskUsagePathResourceDescriptionResolver(String operationName, List<AttributeDefinition> replyParameters) {
            super(PathInfoHandler.FILESYSTEM, ControllerResolver.RESOURCE_NAME, ResolvePathHandler.class.getClassLoader(), false, false);
            this.operationName = operationName;
            this.replyParameterKeys = replyParameters.stream().map(AttributeDefinition::getName).collect(Collectors.toSet());
        }

        @Override
        public String getOperationDescription(String operationName, Locale locale, ResourceBundle bundle) {
            if (this.operationName.equals(operationName)) {
                return bundle.getString(this.getKey());
            }
            return super.getOperationParameterDescription(operationName, operationName, locale, bundle);
        }

        @Override
        public String getOperationParameterDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle) {
            if (this.operationName.equals(operationName)) {
                return bundle.getString(this.getKey(paramName));
            }
            return super.getOperationParameterDescription(operationName, paramName, locale, bundle);
        }

        @Override
        public String getOperationReplyDescription(String operationName, Locale locale, ResourceBundle bundle) {
            if (this.operationName.equals(operationName)) {
                return bundle.getString(this.getKey("path"));
            }
            return super.getOperationReplyDescription(operationName, locale, bundle);
        }

        @Override
        public String getResourceAttributeDescription(String attributeName, Locale locale, ResourceBundle bundle) {
            String key;
            String attribute = attributeName;
            if (attributeName.endsWith(PathInfoHandler.USED_SPACE)) {
                String key2 = attributeName.substring(0, attributeName.length() - PathInfoHandler.USED_SPACE.length() - 1);
                if (this.replyParameterKeys.contains(key2)) {
                    attribute = "path.used-space";
                }
            } else if (attributeName.endsWith(PathInfoHandler.AVAILABLE_SPACE)) {
                String key3 = attributeName.substring(0, attributeName.length() - PathInfoHandler.AVAILABLE_SPACE.length() - 1);
                if (this.replyParameterKeys.contains(key3)) {
                    attribute = "path.available-space";
                }
            } else if (attributeName.endsWith(PathInfoHandler.CREATION_TIME)) {
                String key4 = attributeName.substring(0, attributeName.length() - PathInfoHandler.CREATION_TIME.length() - 1);
                if (this.replyParameterKeys.contains(key4)) {
                    attribute = "path.creation-time";
                }
            } else if (attributeName.endsWith(PathInfoHandler.RESOLVED_PATH)) {
                String key5 = attributeName.substring(0, attributeName.length() - PathInfoHandler.RESOLVED_PATH.length() - 1);
                if (this.replyParameterKeys.contains(key5)) {
                    attribute = "path.resolved-path";
                }
            } else if (attributeName.endsWith(PathInfoHandler.LAST_MODIFIED) && this.replyParameterKeys.contains(key = attributeName.substring(0, attributeName.length() - PathInfoHandler.LAST_MODIFIED.length() - 1))) {
                attribute = "path.last-modified";
            }
            return super.getResourceAttributeDescription(attribute, locale, bundle);
        }

        private String getKey() {
            return String.format("%s.%s", PathInfoHandler.FILESYSTEM, PathInfoHandler.OPERATION_NAME);
        }

        private String getKey(String key) {
            if (this.replyParameterKeys.contains(key)) {
                return String.format("%s.%s.%s", PathInfoHandler.FILESYSTEM, PathInfoHandler.OPERATION_NAME, "path");
            }
            return String.format("%s.%s.%s", PathInfoHandler.FILESYSTEM, PathInfoHandler.OPERATION_NAME, key);
        }
    }

    private static class RelativePathSizeAttribute {
        private final AttributeDefinition relativeToAttribute;
        private final AttributeDefinition pathAttribute;

        RelativePathSizeAttribute(AttributeDefinition pathAttribute, AttributeDefinition relativeToAttribute) {
            this.relativeToAttribute = relativeToAttribute == null ? PathResourceDefinition.RELATIVE_TO : relativeToAttribute;
            this.pathAttribute = pathAttribute == null ? PathResourceDefinition.PATH : pathAttribute;
        }
    }

    public static class Builder {
        private final List<RelativePathSizeAttribute> attributes = new ArrayList<RelativePathSizeAttribute>();
        private AttributeDefinition parentAttribute = null;
        private final PathManager pathManager;

        private Builder(PathManager pathManager) {
            this.pathManager = pathManager;
        }

        public static Builder of(PathManager pathManager) {
            return new Builder(pathManager);
        }

        public Builder setParentAttribute(AttributeDefinition parentAttribute) {
            this.parentAttribute = parentAttribute;
            return this;
        }

        public Builder addAttribute(AttributeDefinition pathAttribute, AttributeDefinition relativeToAttribute) {
            this.attributes.add(new RelativePathSizeAttribute(pathAttribute, relativeToAttribute));
            return this;
        }

        public PathInfoHandler build() {
            if (this.attributes.isEmpty()) {
                this.attributes.add(new RelativePathSizeAttribute(null, null));
            }
            return new PathInfoHandler(this.pathManager, this.parentAttribute, this.attributes);
        }
    }

    private class PathSizeWalker
    implements FileVisitor<Path> {
        private final AtomicLong size = new AtomicLong(0L);

        private PathSizeWalker() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (attrs.isRegularFile()) {
                this.size.addAndGet(attrs.size());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        public AtomicLong getSize() {
            return this.size;
        }
    }
}

