/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartException;

class ServiceVerificationHelper
extends AbstractServiceListener<Object>
implements ServiceListener<Object>,
OperationStepHandler {
    private final StabilityMonitor monitor = new StabilityMonitor();

    ServiceVerificationHelper() {
    }

    public void listenerAdded(ServiceController<?> controller) {
        this.monitor.addController(controller);
        controller.removeListener((ServiceListener)this);
    }

    StabilityMonitor getMonitor() {
        return this.monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void execute(OperationContext context, ModelNode operation) {
        HashSet failed = new HashSet();
        HashSet problems = new HashSet();
        try {
            this.monitor.awaitStability(failed, problems);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            context.getFailureDescription().set(ControllerLogger.ROOT_LOGGER.operationCancelled());
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            return;
        }
        finally {
            this.monitor.clear();
        }
        if (!failed.isEmpty() || !problems.isEmpty()) {
            SortedSet<ServiceName> allMissing;
            HashSet<ServiceController> missingTransitive = null;
            ModelNode failureDescription = context.getFailureDescription();
            HashSet<ServiceName> unavailableServices = new HashSet<ServiceName>();
            HashSet<ServiceName> failedSet = new HashSet<ServiceName>();
            ModelNode failedList = null;
            for (Object controller : failed) {
                if (failedList == null) {
                    failedList = failureDescription.get(ControllerLogger.ROOT_LOGGER.failedServices());
                }
                ServiceName serviceName = controller.getName();
                failedSet.add(serviceName);
                failedList.get(serviceName.getCanonicalName()).set(ServiceVerificationHelper.getServiceFailureDescription(controller.getStartException()));
            }
            ArrayList<String> problemList = new ArrayList<String>();
            for (ServiceController controller : problems) {
                Set immediatelyUnavailable = controller.getImmediateUnavailableDependencies();
                if (!immediatelyUnavailable.isEmpty()) {
                    StringBuilder missing = new StringBuilder();
                    Iterator i = immediatelyUnavailable.iterator();
                    while (i.hasNext()) {
                        ServiceName missingSvc = (ServiceName)i.next();
                        if (!failedSet.contains(missingSvc)) {
                            unavailableServices.add(missingSvc);
                        }
                        missing.append(missingSvc.getCanonicalName());
                        if (!i.hasNext()) continue;
                        missing.append(", ");
                    }
                    Iterator problem = new StringBuilder();
                    ((StringBuilder)((Object)problem)).append(controller.getName().getCanonicalName());
                    ((StringBuilder)((Object)problem)).append(" ").append(ControllerLogger.ROOT_LOGGER.servicesMissing(missing));
                    problemList.add(((StringBuilder)((Object)problem)).toString());
                    continue;
                }
                if (missingTransitive == null) {
                    missingTransitive = new HashSet<ServiceController>();
                }
                missingTransitive.add(controller);
            }
            ServiceVerificationHelper.reportUnavailableRequiredServices(unavailableServices, failureDescription);
            ServiceVerificationHelper.reportImmediateDependants(problemList, failureDescription);
            if (missingTransitive != null && !(allMissing = ServiceVerificationHelper.findAllMissingServices(missingTransitive, unavailableServices)).isEmpty()) {
                ModelNode missingTransitiveDesc = failureDescription.get(ControllerLogger.ROOT_LOGGER.missingTransitiveDependencyProblem());
                ModelNode missingTransitiveDeps = missingTransitiveDesc.get(ControllerLogger.ROOT_LOGGER.missingTransitiveDependents());
                TreeSet<ServiceName> sortedNames = new TreeSet<ServiceName>();
                for (ServiceController serviceController : missingTransitive) {
                    sortedNames.add(serviceController.getName());
                }
                for (ServiceName serviceName : sortedNames) {
                    missingTransitiveDeps.add(serviceName.getCanonicalName());
                }
                ModelNode allMissingList = missingTransitiveDesc.get(ControllerLogger.ROOT_LOGGER.missingTransitiveDependencies());
                for (ServiceName serviceName : allMissing) {
                    allMissingList.add(serviceName.getCanonicalName());
                }
            }
            if (context.isRollbackOnRuntimeFailure()) {
                context.setRollbackOnly();
            }
        }
    }

    private static void reportUnavailableRequiredServices(Set<ServiceName> unavailableServices, ModelNode failureDescription) {
        if (!unavailableServices.isEmpty()) {
            ModelNode requiredServicesNode = failureDescription.get(ControllerLogger.ROOT_LOGGER.missingRequiredServices());
            for (ServiceName serviceName : unavailableServices) {
                requiredServicesNode.add(serviceName.getCanonicalName());
            }
        }
    }

    private static void reportImmediateDependants(List<String> problemList, ModelNode failureDescription) {
        if (!problemList.isEmpty()) {
            ModelNode problemListNode = failureDescription.get(ControllerLogger.ROOT_LOGGER.servicesMissingDependencies());
            for (String problem : problemList) {
                problemListNode.add(problem);
            }
        }
    }

    private static ModelNode getServiceFailureDescription(StartException exception) {
        ModelNode result = new ModelNode();
        if (exception != null) {
            String msg = exception.getLocalizedMessage();
            if (msg == null || msg.length() == 0) {
                msg = exception.toString();
            }
            StringBuilder sb = new StringBuilder(msg);
            for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
                sb.append("\n    Caused by: ");
                sb.append(cause.toString());
            }
            result.set(sb.toString());
        }
        return result;
    }

    private static SortedSet<ServiceName> findAllMissingServices(Set<ServiceController<?>> missingTransitive, Set<ServiceName> alreadyTracked) {
        HashSet<ServiceContainer> examined = new HashSet<ServiceContainer>();
        TreeSet<ServiceName> allMissingServices = new TreeSet<ServiceName>();
        for (ServiceController<?> controller : missingTransitive) {
            ServiceContainer container = controller.getServiceContainer();
            if (!examined.add(container)) continue;
            allMissingServices.addAll(ServiceVerificationHelper.findAllMissingServices(container));
        }
        HashSet retain = new HashSet(allMissingServices);
        retain.removeAll(alreadyTracked);
        if (retain.size() == 0) {
            allMissingServices.clear();
        }
        return allMissingServices;
    }

    private static Set<ServiceName> findAllMissingServices(ServiceContainer container) {
        HashSet<ServiceName> result = new HashSet<ServiceName>();
        for (ServiceName serviceName : container.getServiceNames()) {
            ServiceController controller = container.getService(serviceName);
            if (controller == null || controller.getMode() == ServiceController.Mode.NEVER || controller.getMode() == ServiceController.Mode.REMOVE || controller.getSubstate() != ServiceController.Substate.PROBLEM) continue;
            result.addAll(controller.getImmediateUnavailableDependencies());
        }
        return result;
    }

    static ModelNode extractFailedServicesDescription(ModelNode failureDescription) {
        return ServiceVerificationHelper.extractIfPresent(ControllerLogger.ROOT_LOGGER.failedServices(), failureDescription);
    }

    static ModelNode extractMissingServicesDescription(ModelNode failureDescription) {
        return ServiceVerificationHelper.extractIfPresent(ControllerLogger.ROOT_LOGGER.servicesMissingDependencies(), failureDescription);
    }

    static ModelNode extractTransitiveDependencyProblemDescription(ModelNode failureDescription) {
        ModelNode transitiveDependencyProblemDescription = null;
        ModelNode missingTransitiveDesc = ServiceVerificationHelper.extractIfPresent(ControllerLogger.ROOT_LOGGER.missingTransitiveDependencyProblem(), failureDescription);
        if (missingTransitiveDesc != null) {
            ModelNode missingTransitiveDeps = ServiceVerificationHelper.extractIfPresent(ControllerLogger.ROOT_LOGGER.missingTransitiveDependents(), missingTransitiveDesc);
            ModelNode allMissingList = ServiceVerificationHelper.extractIfPresent(ControllerLogger.ROOT_LOGGER.missingTransitiveDependencies(), missingTransitiveDesc);
            if (allMissingList != null || missingTransitiveDeps != null) {
                transitiveDependencyProblemDescription = new ModelNode();
                if (missingTransitiveDeps != null) {
                    transitiveDependencyProblemDescription.get("services-missing-transitive-dependencies").set(missingTransitiveDeps);
                }
                if (allMissingList != null) {
                    transitiveDependencyProblemDescription.get("possible-causes").set(allMissingList);
                }
            }
        }
        return transitiveDependencyProblemDescription;
    }

    private static ModelNode extractIfPresent(String key, ModelNode modelNode) {
        ModelNode result = null;
        if (modelNode.hasDefined(key)) {
            result = modelNode.get(key);
        }
        return result;
    }
}

