/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.EnumSet;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ModelTypeValidator
implements ParameterValidator {
    protected static final BigDecimal BIGDECIMAL_MAX = BigDecimal.valueOf(Integer.MAX_VALUE);
    protected static final BigDecimal BIGDECIMAL_MIN = BigDecimal.valueOf(Integer.MIN_VALUE);
    protected static final BigInteger BIGINTEGER_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    protected static final BigInteger BIGINTEGER_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    protected final EnumSet<ModelType> validTypes;
    protected final boolean nullable;
    protected final boolean strictType;

    public ModelTypeValidator(ModelType type) {
        this(false, false, false, type, new ModelType[0]);
    }

    public ModelTypeValidator(ModelType type, boolean nullable) {
        this(nullable, false, false, type, new ModelType[0]);
    }

    public ModelTypeValidator(ModelType type, boolean nullable, boolean allowExpressions) {
        this(nullable, allowExpressions, false, type, new ModelType[0]);
    }

    public ModelTypeValidator(ModelType type, boolean nullable, boolean allowExpressions, boolean strictType) {
        this(nullable, allowExpressions, strictType, type, new ModelType[0]);
    }

    public ModelTypeValidator(boolean nullable, boolean allowExpressions, boolean strictType, ModelType firstValidType, ModelType ... otherValidTypes) {
        this.validTypes = EnumSet.of(firstValidType, otherValidTypes);
        this.nullable = nullable;
        if (allowExpressions) {
            this.validTypes.add(ModelType.EXPRESSION);
        }
        this.strictType = strictType;
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        RuntimeException cause = null;
        if (!value.isDefined()) {
            if (!this.nullable) {
                throw ControllerLogger.ROOT_LOGGER.nullNotAllowed(parameterName);
            }
        } else {
            boolean matched = false;
            if (this.strictType) {
                matched = this.validTypes.contains(value.getType());
            } else {
                for (ModelType validType : this.validTypes) {
                    try {
                        if (!this.matches(value, validType)) continue;
                        matched = true;
                        break;
                    }
                    catch (RuntimeException e) {
                        cause = e;
                    }
                }
            }
            if (!matched) {
                if (cause == null) {
                    throw ControllerLogger.ROOT_LOGGER.incorrectType(parameterName, this.validTypes, value.getType());
                }
                String message = String.format("%s. %s", ControllerLogger.ROOT_LOGGER.incorrectType(parameterName, this.validTypes, value.getType()).getLocalizedMessage(), ControllerLogger.ROOT_LOGGER.typeConversionError(value, this.validTypes));
                throw new OperationFailedException(message, cause);
            }
        }
    }

    @Override
    public void validateResolvedParameter(String parameterName, ModelNode value) throws OperationFailedException {
        this.validateParameter(parameterName, value.resolve());
    }

    private boolean matches(ModelNode value, ModelType validType) {
        if (validType == value.getType()) {
            return true;
        }
        switch (validType) {
            case BIG_DECIMAL: {
                value.asBigDecimal();
                return true;
            }
            case BIG_INTEGER: {
                value.asBigInteger();
                return true;
            }
            case DOUBLE: {
                value.asDouble();
                return true;
            }
            case INT: {
                switch (value.getType()) {
                    case BIG_DECIMAL: {
                        BigDecimal valueBigDecimal = value.asBigDecimal();
                        return valueBigDecimal.compareTo(BIGDECIMAL_MAX) <= 0 && valueBigDecimal.compareTo(BIGDECIMAL_MIN) >= 0;
                    }
                    case BIG_INTEGER: {
                        BigInteger valueBigInteger = value.asBigInteger();
                        return valueBigInteger.compareTo(BIGINTEGER_MAX) <= 0 && valueBigInteger.compareTo(BIGINTEGER_MIN) >= 0;
                    }
                    case LONG: {
                        Long valueLong = value.asLong();
                        return valueLong <= Integer.MAX_VALUE && valueLong >= Integer.MIN_VALUE;
                    }
                    case DOUBLE: {
                        Double valueDouble = value.asDouble();
                        return valueDouble <= 2.147483647E9 && valueDouble >= -2.147483648E9;
                    }
                    case STRING: {
                        value.asInt();
                        return true;
                    }
                }
                return false;
            }
            case LONG: {
                switch (value.getType()) {
                    case BIG_DECIMAL: {
                        BigDecimal valueBigDecimal = value.asBigDecimal();
                        return valueBigDecimal.compareTo(BIGDECIMAL_MAX) <= 0 && valueBigDecimal.compareTo(BIGDECIMAL_MIN) >= 0;
                    }
                    case BIG_INTEGER: {
                        BigInteger valueBigInteger = value.asBigInteger();
                        return valueBigInteger.compareTo(BIGINTEGER_MAX) <= 0 && valueBigInteger.compareTo(BIGINTEGER_MIN) >= 0;
                    }
                    case DOUBLE: {
                        Double valueDouble = value.asDouble();
                        return valueDouble <= 9.223372036854776E18 && valueDouble >= -9.223372036854776E18;
                    }
                    case INT: {
                        value.asLong();
                        return true;
                    }
                    case STRING: {
                        value.asLong();
                        return true;
                    }
                }
                return false;
            }
            case PROPERTY: {
                value.asProperty();
                return true;
            }
            case BOOLEAN: {
                switch (value.getType()) {
                    case STRING: {
                        String s = value.asString();
                        if ("false".equalsIgnoreCase(s) || "true".equalsIgnoreCase(s)) {
                            return true;
                        }
                        throw new RuntimeException();
                    }
                    case BOOLEAN: {
                        return true;
                    }
                }
                return false;
            }
            case OBJECT: {
                switch (value.getType()) {
                    case PROPERTY: 
                    case OBJECT: {
                        return true;
                    }
                    case LIST: {
                        for (ModelNode node : value.asList()) {
                            if (node.getType() == ModelType.PROPERTY) continue;
                            return false;
                        }
                        return true;
                    }
                }
                return false;
            }
            case STRING: {
                switch (value.getType()) {
                    case BIG_DECIMAL: 
                    case BIG_INTEGER: 
                    case LONG: 
                    case DOUBLE: 
                    case STRING: 
                    case INT: 
                    case BOOLEAN: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }
}

