/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeParsers;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.MapAttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public abstract class AttributeParser {
    public static final AttributeParser SIMPLE = new AttributeParser(){};
    public static final AttributeParser LIST = new AttributeParser(){

        @Override
        public void parseAndSetParameter(AttributeDefinition attribute, String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
            ModelNode paramVal = this.parse(attribute, value, reader);
            operation.get(attribute.getName()).add(paramVal);
        }
    };
    public static final AttributeParser STRING_LIST = new AttributeParser(){

        @Override
        public void parseAndSetParameter(AttributeDefinition attribute, String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
            if (value == null) {
                return;
            }
            ModelNode node = operation.get(attribute.getName()).setEmptyList();
            if (!value.isEmpty()) {
                for (String element : value.split("\\s+")) {
                    node.add(this.parse(attribute, element, reader));
                }
            }
        }
    };
    public static final AttributeParser COMMA_DELIMITED_STRING_LIST = new AttributeParser(){

        @Override
        public void parseAndSetParameter(AttributeDefinition attribute, String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
            if (value == null) {
                return;
            }
            ModelNode node = operation.get(attribute.getName()).setEmptyList();
            if (!value.isEmpty()) {
                for (String element : value.split(",")) {
                    node.add(this.parse(attribute, element, reader));
                }
            }
        }
    };
    public static final AttributeParser OBJECT_LIST_PARSER = new AttributeParser(){

        @Override
        public boolean isParseAsElement() {
            return true;
        }

        @Override
        public void parseElement(AttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
            assert (attribute instanceof ObjectListAttributeDefinition);
            ObjectListAttributeDefinition list = (ObjectListAttributeDefinition)attribute;
            ObjectTypeAttributeDefinition objectType = list.getValueType();
            AttributeDefinition[] valueTypes = objectType.getValueTypes();
            Map attributes = Arrays.asList(valueTypes).stream().collect(Collectors.toMap(AttributeDefinition::getXmlName, Function.identity()));
            ModelNode listValue = new ModelNode();
            listValue.setEmptyList();
            while (reader.hasNext() && reader.nextTag() != 2) {
                if (objectType.getXmlName().equals(reader.getLocalName())) {
                    ModelNode op = listValue.add();
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        AttributeParser parser;
                        AttributeDefinition def;
                        String attributeName = reader.getAttributeLocalName(i);
                        String value = reader.getAttributeValue(i);
                        if (attributes.containsKey(attributeName)) {
                            def = (AttributeDefinition)attributes.get(attributeName);
                            parser = def.getParser();
                            assert (parser != null);
                        } else {
                            throw ParseUtils.unexpectedAttribute(reader, i, attributes.keySet());
                        }
                        parser.parseAndSetParameter(def, value, op, (XMLStreamReader)reader);
                    }
                } else {
                    throw ParseUtils.unexpectedElement(reader, Collections.singleton(objectType.getXmlName()));
                }
                ParseUtils.requireNoContent(reader);
            }
            operation.get(attribute.getName()).set(listValue);
        }
    };
    public static final AttributeParser PROPERTIES_PARSER = new AttributeParsers.PropertiesParser();
    public static final AttributeParser PROPERTIES_PARSER_UNWRAPPED = new AttributeParsers.PropertiesParser(false);
    public static final AttributeParser OBJECT_PARSER = new AttributeParsers.ObjectParser();

    public void parseAndSetParameter(AttributeDefinition attribute, String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
        ModelNode paramVal = this.parse(attribute, value, reader);
        operation.get(attribute.getName()).set(paramVal);
    }

    public ModelNode parse(AttributeDefinition attribute, String value, XMLStreamReader reader) throws XMLStreamException {
        try {
            return this.parse(attribute, value);
        }
        catch (OperationFailedException e) {
            throw new XMLStreamException(e.getFailureDescription().toString(), reader.getLocation());
        }
    }

    private ModelNode parse(AttributeDefinition attribute, String value) throws OperationFailedException {
        ModelNode node = ParseUtils.parseAttributeValue(value, attribute.isAllowExpression(), attribute.getType());
        ParameterValidator validator = attribute instanceof ListAttributeDefinition ? ((ListAttributeDefinition)attribute).getElementValidator() : (attribute instanceof MapAttributeDefinition ? ((MapAttributeDefinition)attribute).getElementValidator() : attribute.getValidator());
        validator.validateParameter(attribute.getXmlName(), node);
        return node;
    }

    public boolean isParseAsElement() {
        return false;
    }

    public void parseElement(AttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
    }

    public String getXmlName(AttributeDefinition attribute) {
        return attribute.getXmlName();
    }

    public static final class DiscardOldDefaultValueParser
    extends AttributeParser {
        private final String value;

        public DiscardOldDefaultValueParser(String value) {
            this.value = value;
        }

        @Override
        public ModelNode parse(AttributeDefinition attribute, String value, XMLStreamReader reader) throws XMLStreamException {
            if (!this.value.equals(value)) {
                return super.parse(attribute, value, reader);
            }
            return new ModelNode();
        }
    }
}

