/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.audit;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.PortUnreachableException;
import java.security.KeyStore;
import java.util.logging.ErrorManager;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.as.controller.audit.AuditLogHandler;
import org.jboss.as.controller.interfaces.InetAddressUtil;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.handlers.SyslogHandler;
import org.jboss.logmanager.handlers.TcpOutputStream;
import org.xnio.IoUtils;

public class SyslogAuditLogHandler
extends AuditLogHandler {
    private final PathManagerService pathManager;
    private volatile SyslogHandler handler;
    private volatile String appName;
    private volatile String hostName;
    private volatile SyslogHandler.SyslogType syslogType = SyslogHandler.SyslogType.RFC5424;
    private volatile boolean truncate;
    private volatile int maxLength;
    private volatile InetAddress syslogServerAddress;
    private volatile int port = 514;
    private volatile Transport transport = Transport.UDP;
    private volatile MessageTransfer messageTransfer = MessageTransfer.NON_TRANSPARENT_FRAMING;
    private volatile Facility facility;
    private volatile String tlsTrustStorePath;
    private volatile String tlsTrustStoreRelativeTo;
    private volatile String tlsTrustStorePassword;
    private volatile String tlsClientCertStorePath;
    private volatile String tlsClientCertStoreRelativeTo;
    private volatile String tlsClientCertStorePassword;
    private volatile String tlsClientCertStoreKeyPassword;
    private volatile TransportErrorManager errorManager;
    private volatile int reconnectTimeout = -1;
    private volatile long lastErrorTime = -1L;
    private boolean connected;

    public SyslogAuditLogHandler(String name, String formatterName, int maxFailureCount, PathManagerService pathManager) {
        super(name, formatterName, maxFailureCount);
        this.pathManager = pathManager;
        this.connected = false;
    }

    public void setHostName(String hostName) {
        assert (hostName != null);
        this.hostName = hostName;
    }

    public void setAppName(String appName) {
        assert (appName != null);
        this.appName = appName;
        if (this.handler != null) {
            this.handler.setAppName(appName);
        }
    }

    public void setFacility(Facility facility) {
        assert (facility != null);
        this.facility = facility;
        if (this.handler != null) {
            this.handler.setFacility(facility.convert());
        }
    }

    public void setSyslogType(SyslogHandler.SyslogType syslogType) {
        assert (syslogType != null);
        this.syslogType = syslogType;
    }

    public void setTruncate(boolean truncate) {
        this.truncate = truncate;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setMessageTransfer(MessageTransfer messageTransfer) {
        assert (messageTransfer != null);
        this.messageTransfer = messageTransfer;
    }

    public void setSyslogServerAddress(InetAddress syslogServerAddress) {
        assert (syslogServerAddress != null);
        this.syslogServerAddress = syslogServerAddress;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setTransport(Transport transport) {
        assert (transport != null);
        this.transport = transport;
    }

    public void setTlsTrustStorePath(String tlsTrustStorePath) {
        this.tlsTrustStorePath = tlsTrustStorePath;
    }

    public void setTlsTrustStoreRelativeTo(String tlsTrustStoreRelativeTo) {
        this.tlsTrustStoreRelativeTo = tlsTrustStoreRelativeTo;
    }

    public void setTlsTruststorePassword(String tlsTrustStorePassword) {
        this.tlsTrustStorePassword = tlsTrustStorePassword;
    }

    public void setTlsClientCertStorePath(String tlsClientCertStorePath) {
        this.tlsClientCertStorePath = tlsClientCertStorePath;
    }

    public void setTlsClientCertStoreRelativeTo(String tlsClientCertStoreRelativeTo) {
        this.tlsClientCertStoreRelativeTo = tlsClientCertStoreRelativeTo;
    }

    public void setTlsClientCertStorePassword(String tlsClientCertStorePassword) {
        this.tlsClientCertStorePassword = tlsClientCertStorePassword;
    }

    public void setTlsClientCertStoreKeyPassword(String tlsClientCertStoreKeyPassword) {
        this.tlsClientCertStoreKeyPassword = tlsClientCertStoreKeyPassword;
    }

    public void setReconnectTimeout(int reconnectTimeout) {
        this.reconnectTimeout = reconnectTimeout;
    }

    @Override
    boolean isActive() {
        if (this.hasTooManyFailures()) {
            if (this.reconnectTimeout >= 0) {
                long end = this.lastErrorTime + (long)(this.reconnectTimeout * 1000);
                return System.currentTimeMillis() > end;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initialize() {
        if (this.connected) {
            return;
        }
        SyslogHandler handler = this.handler;
        if (handler != null) {
            ControllerLogger.MGMT_OP_LOGGER.debug("Stopping a previously initialized syslog handler.");
            this.stop();
        }
        try {
            SyslogHandler.Protocol protocol;
            switch (this.transport) {
                case UDP: {
                    protocol = SyslogHandler.Protocol.UDP;
                    break;
                }
                case TCP: {
                    protocol = SyslogHandler.Protocol.TCP;
                    break;
                }
                case TLS: {
                    protocol = SyslogHandler.Protocol.SSL_TCP;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown protocol");
                }
            }
            handler = new SyslogHandler(this.syslogServerAddress, this.port, this.facility.convert(), this.syslogType, protocol, this.hostName == null ? InetAddressUtil.getLocalHostName() : this.hostName);
            handler.setAppName(this.appName);
            handler.setTruncate(this.truncate);
            if (this.maxLength != 0) {
                handler.setMaxLength(this.maxLength);
            }
            handler.setSyslogType(this.syslogType);
            TransportErrorManager errorManager = new TransportErrorManager();
            handler.setErrorManager((ErrorManager)errorManager);
            if (this.transport != Transport.UDP) {
                if (this.messageTransfer == MessageTransfer.NON_TRANSPARENT_FRAMING) {
                    handler.setUseCountingFraming(false);
                    handler.setMessageDelimiter("\n");
                    handler.setUseMessageDelimiter(true);
                } else {
                    handler.setUseCountingFraming(true);
                    handler.setMessageDelimiter(null);
                    handler.setUseMessageDelimiter(false);
                }
                if (this.transport == Transport.TLS) {
                    SSLContext context = SSLContext.getInstance("TLS");
                    KeyManager[] keyManagers = null;
                    if (this.tlsClientCertStorePath != null) {
                        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        FileInputStream in = new FileInputStream(this.pathManager.resolveRelativePathEntry(this.tlsClientCertStorePath, this.tlsClientCertStoreRelativeTo));
                        try {
                            KeyStore ks = KeyStore.getInstance("JKS");
                            ks.load(in, this.tlsClientCertStorePassword.toCharArray());
                            kmf.init(ks, this.tlsClientCertStoreKeyPassword != null ? this.tlsClientCertStoreKeyPassword.toCharArray() : this.tlsClientCertStorePassword.toCharArray());
                            keyManagers = kmf.getKeyManagers();
                        }
                        finally {
                            IoUtils.safeClose((Closeable)in);
                        }
                    }
                    TrustManager[] trustManagers = null;
                    if (this.tlsTrustStorePath != null) {
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        FileInputStream in = new FileInputStream(this.pathManager.resolveRelativePathEntry(this.tlsTrustStorePath, this.tlsTrustStoreRelativeTo));
                        try {
                            KeyStore ks = KeyStore.getInstance("JKS");
                            ks.load(in, this.tlsTrustStorePassword.toCharArray());
                            tmf.init(ks);
                            trustManagers = tmf.getTrustManagers();
                        }
                        finally {
                            IoUtils.safeClose((Closeable)in);
                        }
                    }
                    context.init(keyManagers, trustManagers, null);
                    handler.setOutputStream((OutputStream)((Object)new SSLContextOutputStream(context, this.syslogServerAddress, this.port)));
                } else {
                    handler.setOutputStream((OutputStream)((Object)new AuditLogTcpOutputStream(this.syslogServerAddress, this.port)));
                    handler.setProtocol(this.transport == Transport.TCP ? SyslogHandler.Protocol.TCP : SyslogHandler.Protocol.SSL_TCP);
                }
            }
            this.handler = handler;
            this.errorManager = errorManager;
            this.connected = true;
        }
        catch (Exception e) {
            this.connected = false;
            if (handler != null) {
                try {
                    handler.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    void stop() {
        this.connected = false;
        SyslogHandler handler = this.handler;
        this.handler = null;
        if (handler != null) {
            handler.close();
        }
    }

    private boolean isReconnect() {
        return this.hasTooManyFailures() && this.isActive();
    }

    @Override
    AuditLogHandler.FailureCountHandler getFailureCountHandler() {
        return this.isReconnect() ? new AuditLogHandler.ReconnectFailureCountHandler(this) : super.getFailureCountHandler();
    }

    @Override
    void writeLogItem(String formattedItem) throws IOException {
        boolean reconnect = this.isReconnect();
        if (!reconnect) {
            this.handler.publish(new ExtLogRecord((java.util.logging.Level)Level.WARN, formattedItem, SyslogAuditLogHandler.class.getName()));
            this.errorManager.getAndThrowError();
        } else {
            ControllerLogger.MGMT_OP_LOGGER.attemptingReconnectToSyslog(this.name, this.reconnectTimeout);
            try {
                if (!this.connected) {
                    this.stop();
                    this.initialize();
                }
                this.handler.publish(new ExtLogRecord((java.util.logging.Level)Level.WARN, formattedItem, SyslogAuditLogHandler.class.getName()));
                this.errorManager.getAndThrowError();
                this.lastErrorTime = -1L;
            }
            catch (Exception e) {
                this.connected = false;
                this.lastErrorTime = System.currentTimeMillis();
                this.errorManager.throwAsIoOrRuntimeException(e);
            }
        }
    }

    @Override
    boolean isDifferent(AuditLogHandler other) {
        if (!(other instanceof SyslogAuditLogHandler)) {
            return true;
        }
        SyslogAuditLogHandler otherHandler = (SyslogAuditLogHandler)other;
        if (!this.name.equals(otherHandler.name)) {
            return true;
        }
        if (!this.getFormatterName().equals(otherHandler.getFormatterName())) {
            return true;
        }
        if (!this.hostName.equals(otherHandler.hostName)) {
            return true;
        }
        if (!this.syslogType.equals((Object)otherHandler.syslogType)) {
            return true;
        }
        if (!this.truncate == otherHandler.truncate) {
            return true;
        }
        if (this.maxLength != otherHandler.maxLength) {
            return true;
        }
        if (!this.syslogServerAddress.equals(otherHandler.syslogServerAddress)) {
            return true;
        }
        if (this.port != otherHandler.port) {
            return true;
        }
        if (!this.transport.equals((Object)otherHandler.transport)) {
            return true;
        }
        if (!this.compare((Object)this.messageTransfer, (Object)otherHandler.messageTransfer)) {
            return true;
        }
        if (!this.compare(this.tlsTrustStorePath, otherHandler.tlsTrustStorePath)) {
            return true;
        }
        if (!this.compare(this.tlsTrustStoreRelativeTo, otherHandler.tlsTrustStoreRelativeTo)) {
            return true;
        }
        if (!this.compare(this.tlsTrustStorePassword, otherHandler.tlsTrustStorePassword)) {
            return true;
        }
        if (!this.compare(this.tlsClientCertStorePath, otherHandler.tlsClientCertStorePath)) {
            return true;
        }
        if (!this.compare(this.tlsClientCertStoreRelativeTo, otherHandler.tlsClientCertStoreRelativeTo)) {
            return true;
        }
        if (!this.compare(this.tlsClientCertStorePassword, otherHandler.tlsClientCertStorePassword)) {
            return true;
        }
        return !this.compare(this.tlsClientCertStoreKeyPassword, otherHandler.tlsClientCertStoreKeyPassword);
    }

    private boolean compare(Object one, Object two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null && two != null) {
            return false;
        }
        if (one != null && two == null) {
            return false;
        }
        return one.equals(two);
    }

    private class TransportErrorManager
    extends ErrorManager {
        private volatile Exception error;

        @Override
        public synchronized void error(String msg, Exception ex, int code) {
            this.error = ex;
            SyslogAuditLogHandler.this.lastErrorTime = System.currentTimeMillis();
        }

        void getAndThrowError() throws IOException {
            Exception error = this.error;
            this.error = null;
            if (error != null) {
                SyslogAuditLogHandler.this.connected = false;
                this.throwAsIoOrRuntimeException(error);
            }
        }

        void throwAsIoOrRuntimeException(Throwable t) throws IOException {
            if (t instanceof PortUnreachableException && SyslogAuditLogHandler.this.transport == Transport.UDP) {
                ControllerLogger.MGMT_OP_LOGGER.udpSyslogServerUnavailable(SyslogAuditLogHandler.this.getName(), t.getLocalizedMessage());
                return;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private static class SSLContextOutputStream
    extends TcpOutputStream {
        protected SSLContextOutputStream(SSLContext sslContext, InetAddress host, int port) throws IOException {
            super(sslContext.getSocketFactory().createSocket(host, port));
        }
    }

    private static class AuditLogTcpOutputStream
    extends TcpOutputStream {
        protected AuditLogTcpOutputStream(InetAddress host, int port) throws IOException {
            super(SocketFactory.getDefault().createSocket(host, port));
        }
    }

    public static enum Facility {
        KERNEL(SyslogHandler.Facility.KERNEL),
        USER_LEVEL(SyslogHandler.Facility.USER_LEVEL),
        MAIL_SYSTEM(SyslogHandler.Facility.MAIL_SYSTEM),
        SYSTEM_DAEMONS(SyslogHandler.Facility.SYSTEM_DAEMONS),
        SECURITY(SyslogHandler.Facility.SECURITY),
        SYSLOGD(SyslogHandler.Facility.SYSLOGD),
        LINE_PRINTER(SyslogHandler.Facility.LINE_PRINTER),
        NETWORK_NEWS(SyslogHandler.Facility.NETWORK_NEWS),
        UUCP(SyslogHandler.Facility.UUCP),
        CLOCK_DAEMON(SyslogHandler.Facility.CLOCK_DAEMON),
        SECURITY2(SyslogHandler.Facility.SECURITY2),
        FTP_DAEMON(SyslogHandler.Facility.FTP_DAEMON),
        NTP(SyslogHandler.Facility.NTP),
        LOG_AUDIT(SyslogHandler.Facility.LOG_AUDIT),
        LOG_ALERT(SyslogHandler.Facility.LOG_ALERT),
        CLOCK_DAEMON2(SyslogHandler.Facility.CLOCK_DAEMON2),
        LOCAL_USE_0(SyslogHandler.Facility.LOCAL_USE_0),
        LOCAL_USE_1(SyslogHandler.Facility.LOCAL_USE_1),
        LOCAL_USE_2(SyslogHandler.Facility.LOCAL_USE_2),
        LOCAL_USE_3(SyslogHandler.Facility.LOCAL_USE_3),
        LOCAL_USE_4(SyslogHandler.Facility.LOCAL_USE_4),
        LOCAL_USE_5(SyslogHandler.Facility.LOCAL_USE_5),
        LOCAL_USE_6(SyslogHandler.Facility.LOCAL_USE_6),
        LOCAL_USE_7(SyslogHandler.Facility.LOCAL_USE_7);

        private final SyslogHandler.Facility realFacility;

        private Facility(SyslogHandler.Facility realFacility) {
            this.realFacility = realFacility;
        }

        public SyslogHandler.Facility convert() {
            return this.realFacility;
        }
    }

    public static enum MessageTransfer {
        OCTET_COUNTING,
        NON_TRANSPARENT_FRAMING;

    }

    public static enum Transport {
        UDP,
        TCP,
        TLS;

    }
}

