/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDescriptor;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentResourceHandlerBase;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public abstract class RestartParentResourceAddHandler
extends RestartParentResourceHandlerBase
implements OperationDescriptor {
    protected final Collection<? extends AttributeDefinition> attributes;

    protected RestartParentResourceAddHandler(String parentKeyName) {
        this(parentKeyName, List.of());
    }

    protected RestartParentResourceAddHandler(String parentKeyName, Collection<? extends AttributeDefinition> attributes) {
        super(parentKeyName);
        this.attributes = attributes.isEmpty() ? List.of() : List.copyOf(attributes);
    }

    @Deprecated(forRemoval=true)
    protected RestartParentResourceAddHandler(String parentKeyName, RuntimeCapability ... capabilities) {
        this(parentKeyName);
    }

    @Deprecated(forRemoval=true)
    public RestartParentResourceAddHandler(String parentKeyName, Set<RuntimeCapability> capabilities, Collection<? extends AttributeDefinition> attributes) {
        this(parentKeyName, attributes);
    }

    @Override
    public Collection<? extends AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    @Override
    protected void updateModel(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        this.populateModel(operation, resource.getModel());
        this.recordCapabilitiesAndRequirements(context, operation, resource);
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        for (RuntimeCapability capability : context.getResourceRegistration().getCapabilities()) {
            if (capability.isDynamicallyNamed()) {
                context.registerCapability(capability.fromBaseCapability(context.getCurrentAddress()));
                continue;
            }
            context.registerCapability(capability);
        }
        ModelNode model = resource.getModel();
        for (AttributeDefinition attributeDefinition : this.attributes) {
            if (!model.hasDefined(attributeDefinition.getName()) && !attributeDefinition.hasCapabilityRequirements()) continue;
            attributeDefinition.addCapabilityRequirements(context, resource, model.get(attributeDefinition.getName()));
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attributeDefinition : this.attributes) {
            attributeDefinition.validateAndSet(operation, model);
        }
    }
}

