/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.xml;

import javax.xml.namespace.QName;
import org.jboss.as.controller.FeatureRegistry;
import org.jboss.as.controller.xml.XMLAll;
import org.jboss.as.controller.xml.XMLChoice;
import org.jboss.as.controller.xml.XMLElement;
import org.jboss.as.controller.xml.XMLSequence;
import org.jboss.as.version.Stability;

public interface XMLParticleFactory<RC, WC>
extends FeatureRegistry {
    public static <RC, WC> XMLParticleFactory<RC, WC> newInstance(FeatureRegistry registry) {
        return new DefaultXMLParticleFactory(registry);
    }

    default public XMLElement.Builder<RC, WC> element(QName name) {
        return this.element(name, this.getStability());
    }

    public XMLElement.Builder<RC, WC> element(QName var1, Stability var2);

    public XMLChoice.Builder<RC, WC> choice();

    public XMLAll.Builder<RC, WC> all();

    public XMLSequence.Builder<RC, WC> sequence();

    public static class DefaultXMLParticleFactory<RC, WC>
    implements XMLParticleFactory<RC, WC> {
        private final FeatureRegistry registry;

        DefaultXMLParticleFactory(FeatureRegistry registry) {
            this.registry = registry;
        }

        @Override
        public Stability getStability() {
            return this.registry.getStability();
        }

        @Override
        public XMLElement.Builder<RC, WC> element(QName name, Stability stability) {
            return new XMLElement.DefaultBuilder(name, stability);
        }

        @Override
        public XMLChoice.Builder<RC, WC> choice() {
            return new XMLChoice.DefaultBuilder(this.registry);
        }

        @Override
        public XMLAll.Builder<RC, WC> all() {
            return new XMLAll.DefaultBuilder(this.registry);
        }

        @Override
        public XMLSequence.Builder<RC, WC> sequence() {
            return new XMLSequence.DefaultBuilder(this.registry);
        }
    }
}

