/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.xml;

import org.jboss.as.controller.Feature;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.xml.XMLCardinality;
import org.jboss.as.controller.xml.XMLContentWriter;
import org.jboss.as.controller.xml.XMLElementReader;
import org.jboss.as.version.Stability;

public interface XMLParticle<RC, WC>
extends Feature {
    public XMLCardinality getCardinality();

    public XMLElementReader<RC> getReader();

    public XMLContentWriter<WC> getWriter();

    public static class DefaultXMLParticle<RC, WC>
    implements XMLParticle<RC, WC> {
        private final XMLElementReader<RC> reader;
        private final XMLContentWriter<WC> writer;
        private final XMLCardinality cardinality;
        private final Stability stability;

        protected DefaultXMLParticle(XMLCardinality cardinality, XMLElementReader<RC> reader, XMLContentWriter<WC> writer, Stability stability) {
            this.cardinality = cardinality;
            this.reader = reader;
            this.writer = writer;
            this.stability = stability;
        }

        @Override
        public XMLCardinality getCardinality() {
            return this.cardinality;
        }

        @Override
        public XMLElementReader<RC> getReader() {
            return this.reader;
        }

        @Override
        public XMLContentWriter<WC> getWriter() {
            return this.writer;
        }

        @Override
        public Stability getStability() {
            return this.stability;
        }
    }

    public static abstract class AbstractBuilder<RC, WC, T extends XMLParticle<RC, WC>, B extends Builder<RC, WC, T, B>>
    implements Builder<RC, WC, T, B> {
        private volatile XMLCardinality cardinality = XMLCardinality.Single.REQUIRED;

        @Override
        public B withCardinality(XMLCardinality cardinality) {
            if (cardinality.getMinOccurs() < 0 || cardinality.getMinOccurs() > cardinality.getMaxOccurs().orElse(Integer.MAX_VALUE)) {
                throw ControllerLogger.ROOT_LOGGER.illegalXMLCardinality(cardinality);
            }
            this.cardinality = cardinality;
            return this.builder();
        }

        protected XMLCardinality getCardinality() {
            return this.cardinality;
        }

        protected abstract B builder();
    }

    public static interface Builder<RC, WC, T extends XMLParticle<RC, WC>, B extends Builder<RC, WC, T, B>> {
        public B withCardinality(XMLCardinality var1);

        public T build();
    }
}

