/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.xml;

import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.xml.XMLParticle;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public interface XMLContentWriter<C>
extends XMLElementWriter<C> {
    public boolean isEmpty(C var1);

    default public XMLContentWriter<C> andThen(final XMLContentWriter<C> after) {
        return new XMLContentWriter<C>(){

            public void writeContent(XMLExtendedStreamWriter writer, C value) throws XMLStreamException {
                XMLContentWriter.this.writeContent(writer, value);
                after.writeContent(writer, value);
            }

            @Override
            public boolean isEmpty(C content) {
                return XMLContentWriter.this.isEmpty(content) && after.isEmpty(content);
            }
        };
    }

    default public XMLContentWriter<C> compose(final XMLContentWriter<C> before) {
        return new XMLContentWriter<C>(){

            public void writeContent(XMLExtendedStreamWriter writer, C value) throws XMLStreamException {
                before.writeContent(writer, value);
                XMLContentWriter.this.writeContent(writer, value);
            }

            @Override
            public boolean isEmpty(C content) {
                return before.isEmpty(content) && XMLContentWriter.this.isEmpty(content);
            }
        };
    }

    public static <C> XMLContentWriter<C> empty() {
        return new XMLContentWriter<C>(){

            public void writeContent(XMLExtendedStreamWriter streamWriter, C value) throws XMLStreamException {
            }

            @Override
            public boolean isEmpty(C content) {
                return true;
            }
        };
    }

    public static <RC, WC> XMLContentWriter<WC> composite(final Collection<? extends XMLParticle<RC, WC>> particles) {
        return new XMLContentWriter<WC>(){

            public void writeContent(XMLExtendedStreamWriter writer, WC content) throws XMLStreamException {
                for (XMLParticle particle : particles) {
                    particle.getWriter().writeContent(writer, content);
                }
            }

            @Override
            public boolean isEmpty(WC content) {
                for (XMLParticle particle : particles) {
                    XMLContentWriter contentWriter = particle.getWriter();
                    if (contentWriter.isEmpty(content)) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

