/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.xml.XMLContentWriter;
import org.jboss.as.controller.xml.XMLElementGroup;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.common.Assert;

public interface XMLContent<RC, WC>
extends XMLContentWriter<WC> {
    public void readContent(XMLExtendedStreamReader var1, RC var2) throws XMLStreamException;

    public static <RC, WC> XMLContent<RC, WC> empty() {
        return new XMLContent<RC, WC>(){

            @Override
            public void readContent(XMLExtendedStreamReader reader, RC value) throws XMLStreamException {
                Assert.assertTrue((boolean)reader.isStartElement());
                ParseUtils.requireNoContent(reader);
            }

            @Override
            public boolean isEmpty(WC content) {
                return true;
            }

            public void writeContent(XMLExtendedStreamWriter streamWriter, WC value) throws XMLStreamException {
            }
        };
    }

    public static <RC, WC> XMLContent<RC, WC> of(XMLElementGroup<RC, WC> group) {
        return !group.getReaderNames().isEmpty() ? new DefaultXMLContent<RC, WC>(group) : XMLContent.empty();
    }

    public static class DefaultXMLContent<RC, WC>
    implements XMLContent<RC, WC> {
        private final XMLElementGroup<RC, WC> group;

        DefaultXMLContent(XMLElementGroup<RC, WC> group) {
            this.group = group;
        }

        @Override
        public void readContent(XMLExtendedStreamReader reader, RC context) throws XMLStreamException {
            Assert.assertTrue((boolean)reader.isStartElement());
            QName parentElementName = reader.getName();
            int occurrences = 0;
            int maxOccurs = this.group.getCardinality().getMaxOccurs().orElse(Integer.MAX_VALUE);
            if (reader.hasNext() && reader.nextTag() != 2) {
                do {
                    if (!this.group.getReaderNames().contains(reader.getName())) {
                        throw ParseUtils.unexpectedElement(reader, this.group.getReaderNames());
                    }
                    if (++occurrences > maxOccurs) {
                        throw ParseUtils.maxOccursExceeded(reader, this.group.getNames(), this.group.getCardinality());
                    }
                    this.group.getReader().readElement(reader, context);
                } while (reader.getEventType() != 2);
            } else {
                this.group.getReader().handleAbsentElement(context);
            }
            if (occurrences < this.group.getCardinality().getMinOccurs()) {
                throw ParseUtils.minOccursNotReached(reader, this.group.getNames(), this.group.getCardinality());
            }
            if (!reader.isEndElement()) {
                throw ParseUtils.unexpectedElement(reader);
            }
            if (!reader.getName().equals(parentElementName)) {
                throw ParseUtils.unexpectedEndElement(reader);
            }
        }

        @Override
        public boolean isEmpty(WC content) {
            return this.group.getWriter().isEmpty(content);
        }

        public void writeContent(XMLExtendedStreamWriter writer, WC content) throws XMLStreamException {
            this.group.getWriter().writeContent(writer, content);
        }
    }
}

