/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.xml;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.FeatureRegistry;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.xml.QNameResolver;
import org.jboss.as.controller.xml.XMLCardinality;
import org.jboss.as.controller.xml.XMLContentWriter;
import org.jboss.as.controller.xml.XMLElement;
import org.jboss.as.controller.xml.XMLElementReader;
import org.jboss.as.controller.xml.XMLParticleGroup;
import org.jboss.as.version.Stability;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionFunction;

public interface XMLChoice<RC, WC>
extends XMLParticleGroup<RC, WC> {

    public static class DefaultXMLElementChoice<RC, WC>
    extends XMLParticleGroup.DefaultXMLParticleGroup<RC, WC>
    implements XMLChoice<RC, WC> {
        private static <RC, WC> Map<QName, XMLElement<RC, WC>> collect(Collection<? extends XMLElement<RC, WC>> elements) {
            TreeMap<QName, XMLElement<RC, WC>> result = new TreeMap<QName, XMLElement<RC, WC>>(QNameResolver.COMPARATOR);
            for (XMLElement<RC, WC> element : elements) {
                if (result.put(element.getName(), element) == null) continue;
                throw ControllerLogger.ROOT_LOGGER.duplicateElements(element.getName());
            }
            return Collections.unmodifiableMap(result);
        }

        DefaultXMLElementChoice(XMLElement<RC, WC> element) {
            this(Map.of(element.getName(), element), element.getCardinality(), element.getReader()::handleAbsentElement, List.of(element), element.getStability());
        }

        protected DefaultXMLElementChoice(Collection<? extends XMLElement<RC, WC>> elements, XMLCardinality cardinality, Consumer<RC> absenteeHandler, Stability stability) {
            this(DefaultXMLElementChoice.collect(elements), cardinality, absenteeHandler, Collections.unmodifiableCollection(elements), stability);
        }

        private DefaultXMLElementChoice(final Map<QName, XMLElement<RC, WC>> choices, XMLCardinality cardinality, Consumer<RC> absenteeHandler, Collection<XMLElement<RC, WC>> elements, Stability stability) {
            this(choices.keySet(), cardinality, new ExceptionFunction<XMLExtendedStreamReader, XMLElement<RC, WC>, XMLStreamException>(){

                public XMLElement<RC, WC> apply(XMLExtendedStreamReader reader) throws XMLStreamException {
                    return (XMLElement)choices.get(reader.getName());
                }
            }, absenteeHandler, XMLContentWriter.composite(elements), stability);
        }

        protected DefaultXMLElementChoice(final Set<QName> names, final XMLCardinality cardinality, final ExceptionFunction<XMLExtendedStreamReader, XMLElement<RC, WC>, XMLStreamException> elementReader, final Consumer<RC> absenteeHandler, XMLContentWriter<WC> writer, Stability stability) {
            super(names, cardinality, new XMLElementReader<RC>(){

                public void readElement(XMLExtendedStreamReader reader, RC context) throws XMLStreamException {
                    Assert.assertTrue((boolean)reader.isStartElement());
                    XMLElement element = (XMLElement)elementReader.apply((Object)reader);
                    if (element != null) {
                        if (!cardinality.isEnabled()) {
                            throw ParseUtils.unexpectedElement(reader);
                        }
                        int occurrences = 0;
                        int maxOccurs = element.getCardinality().getMaxOccurs().orElse(Integer.MAX_VALUE);
                        do {
                            element.getReader().readElement(reader, context);
                        } while (reader.hasNext() && reader.nextTag() != 2 && ++occurrences < maxOccurs && elementReader.apply((Object)reader) == element);
                        if (occurrences < element.getCardinality().getMinOccurs()) {
                            throw ParseUtils.minOccursNotReached(reader, Set.of(element.getName()), element.getCardinality());
                        }
                    } else {
                        if (cardinality.isRequired()) {
                            throw ParseUtils.unexpectedElement(reader, names);
                        }
                        this.handleAbsentElement((RC)context);
                    }
                }

                @Override
                public void handleAbsentElement(RC context) {
                    absenteeHandler.accept(context);
                }
            }, writer, stability);
        }
    }

    public static class DefaultXMLChoice<RC, WC>
    extends XMLParticleGroup.DefaultXMLParticleGroup<RC, WC>
    implements XMLChoice<RC, WC> {
        private static <RC, WC> Map<QName, XMLParticleGroup<RC, WC>> collect(Collection<? extends XMLParticleGroup<RC, WC>> groups) {
            TreeMap<QName, XMLParticleGroup<RC, WC>> result = new TreeMap<QName, XMLParticleGroup<RC, WC>>(QNameResolver.COMPARATOR);
            for (XMLParticleGroup<RC, WC> group : groups) {
                for (QName name : group.getReaderNames()) {
                    if (result.put(name, group) == null) continue;
                    throw ControllerLogger.ROOT_LOGGER.duplicateElements(name);
                }
            }
            return Collections.unmodifiableMap(result);
        }

        DefaultXMLChoice(XMLParticleGroup<RC, WC> group) {
            this(group.getReaderNames().stream().collect(Collectors.toMap(Function.identity(), name -> group)), List.of(group), group.getCardinality());
        }

        protected DefaultXMLChoice(Collection<? extends XMLParticleGroup<RC, WC>> groups, XMLCardinality cardinality) {
            this(DefaultXMLChoice.collect(groups), Collections.unmodifiableCollection(groups), cardinality);
        }

        private DefaultXMLChoice(final Map<QName, XMLParticleGroup<RC, WC>> choices, final Collection<XMLParticleGroup<RC, WC>> groups, final XMLCardinality cardinality) {
            super(choices.keySet(), groups, cardinality, new XMLElementReader<RC>(){

                public void readElement(XMLExtendedStreamReader reader, RC context) throws XMLStreamException {
                    Assert.assertTrue((boolean)reader.isStartElement());
                    QName name = reader.getName();
                    XMLParticleGroup choice = (XMLParticleGroup)choices.get(name);
                    if (choice != null) {
                        if (!cardinality.isEnabled()) {
                            throw ParseUtils.unexpectedElement(reader);
                        }
                        int occurrences = 0;
                        int maxOccurs = choice.getCardinality().getMaxOccurs().orElse(Integer.MAX_VALUE);
                        do {
                            choice.getReader().readElement(reader, context);
                        } while (reader.getEventType() != 2 && ++occurrences < maxOccurs && reader.getName().equals(name));
                        if (occurrences < choice.getCardinality().getMinOccurs()) {
                            throw ParseUtils.minOccursNotReached(reader, choice.getNames(), choice.getCardinality());
                        }
                    } else {
                        if (cardinality.isRequired()) {
                            throw ParseUtils.unexpectedElement(reader, choices.keySet());
                        }
                        this.handleAbsentElement((RC)context);
                    }
                }

                @Override
                public void handleAbsentElement(RC context) {
                    for (XMLParticleGroup choice : groups) {
                        choice.getReader().handleAbsentElement(context);
                    }
                }
            });
        }
    }

    public static class DefaultBuilder<RC, WC>
    extends XMLParticleGroup.AbstractBuilder<RC, WC, XMLElement<RC, WC>, XMLChoice<RC, WC>, Builder<RC, WC>>
    implements Builder<RC, WC> {
        DefaultBuilder(FeatureRegistry registry) {
            super(registry);
        }

        @Override
        public XMLChoice<RC, WC> build() {
            return new DefaultXMLChoice(this.getGroups(), this.getCardinality());
        }

        @Override
        protected Builder<RC, WC> builder() {
            return this;
        }
    }

    public static interface Builder<RC, WC>
    extends XMLParticleGroup.Builder<RC, WC, XMLElement<RC, WC>, XMLChoice<RC, WC>, Builder<RC, WC>> {
    }
}

