/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.management;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.management.ManagementWriteAttributeHandler;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class BaseHttpInterfaceResourceDefinition
extends SimpleResourceDefinition {
    public static final RuntimeCapability<Void> HTTP_MANAGEMENT_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of("org.wildfly.management.http-interface").build();
    protected static final PathElement RESOURCE_PATH = PathElement.pathElement("management-interface", "http-interface");
    public static final SimpleAttributeDefinition HTTP_AUTHENTICATION_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("http-authentication-factory", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.http-authentication-factory", HTTP_MANAGEMENT_RUNTIME_CAPABILITY)).setAccessConstraints(SensitiveTargetAccessConstraintDefinition.AUTHENTICATION_FACTORY_REF)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition SSL_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ssl-context", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.ssl-context", HTTP_MANAGEMENT_RUNTIME_CAPABILITY)).setAccessConstraints(SensitiveTargetAccessConstraintDefinition.SSL_REF)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition CONSOLE_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("console-enabled", ModelType.BOOLEAN, true).setAllowExpression(true)).setXmlName(Attribute.CONSOLE_ENABLED.getLocalName())).setDefaultValue(ModelNode.TRUE)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition HTTP_UPGRADE_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("http-upgrade-enabled", ModelType.BOOLEAN, true).setXmlName(Attribute.HTTP_UPGRADE_ENABLED.getLocalName())).setDeprecated(ModelVersion.create(5), true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enabled", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.FALSE)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition SASL_AUTHENTICATION_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sasl-authentication-factory", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.sasl-authentication-factory", HTTP_MANAGEMENT_RUNTIME_CAPABILITY)).setRestartAllServices()).build();
    public static final ObjectTypeAttributeDefinition HTTP_UPGRADE = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("http-upgrade", ENABLED, SASL_AUTHENTICATION_FACTORY).setRestartAllServices()).setAccessConstraints(SensitiveTargetAccessConstraintDefinition.AUTHENTICATION_FACTORY_REF)).build();
    public static final SimpleAttributeDefinition SERVER_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("server-name", ModelType.STRING, true).setAllowExpression(true)).setValidator(new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setDeprecated(ModelVersion.create(5))).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition SASL_PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sasl-protocol", ModelType.STRING, true).setAllowExpression(true)).setValidator(new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setDefaultValue(new ModelNode("remote"))).setDeprecated(ModelVersion.create(5))).setRestartAllServices()).build();
    public static final StringListAttributeDefinition ALLOWED_ORIGINS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("allowed-origins").setAllowExpression(true)).setRequired(false)).setValidator(new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).setAttributeMarshaller(AttributeMarshaller.STRING_LIST)).setRestartAllServices()).build();
    private static final Set<String> disallowedValues = new HashSet<String>(Arrays.asList("connection", "content-type", "content-length", "date", "transfer-encoding"));
    public static final SimpleAttributeDefinition HEADER_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, false).setMinSize(1)).setValidator(new ParameterValidator(){
        private static final String NAME_PATTERN = "^([\\p{ASCII}&&[^\\(\\)\\<\\>\\@\\,\\;\\:\\\\/\\[\\]\\?\\=\\{\\}\\p{Cntrl}\\x{20}]])+\\z";
        private final Predicate<String> VALID_NAME = Pattern.compile("^([\\p{ASCII}&&[^\\(\\)\\<\\>\\@\\,\\;\\:\\\\/\\[\\]\\?\\=\\{\\}\\p{Cntrl}\\x{20}]])+\\z").asPredicate();

        @Override
        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            String name = value.asString();
            if (disallowedValues.contains(name.toLowerCase(Locale.ENGLISH))) {
                throw ControllerLogger.ROOT_LOGGER.disallowedHeaderName(name);
            }
            if (!this.VALID_NAME.test(name)) {
                throw ControllerLogger.ROOT_LOGGER.invalidHeaderName(name);
            }
        }
    })).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition HEADER_VALUE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("value", ModelType.STRING, false).setMinSize(1)).setAllowExpression(true)).setRestartAllServices()).build();
    static final ObjectTypeAttributeDefinition HEADER_PAIR = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("header-pair", HEADER_NAME, HEADER_VALUE).setRestartAllServices()).build();
    static final ObjectListAttributeDefinition HEADERS = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("headers", HEADER_PAIR).setRequired(true)).setMinSize(1)).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES)).build();
    public static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", ModelType.STRING, false).setMinSize(1)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final ObjectTypeAttributeDefinition HEADER_MAPPING = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("header-mapping", PATH, HEADERS).setRestartAllServices()).build();
    public static final ObjectListAttributeDefinition CONSTANT_HEADERS = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("constant-headers", HEADER_MAPPING).setRequired(false)).setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES)).build();
    protected static final AttributeDefinition[] COMMON_ATTRIBUTES = new AttributeDefinition[]{HTTP_AUTHENTICATION_FACTORY, SSL_CONTEXT, CONSOLE_ENABLED, HTTP_UPGRADE_ENABLED, HTTP_UPGRADE, SASL_PROTOCOL, SERVER_NAME, ALLOWED_ORIGINS, CONSTANT_HEADERS};

    protected BaseHttpInterfaceResourceDefinition(SimpleResourceDefinition.Parameters parameters) {
        super(((SimpleResourceDefinition.Parameters)parameters.addAccessConstraints(SensitiveTargetAccessConstraintDefinition.MANAGEMENT_INTERFACES)).addCapabilities(HTTP_MANAGEMENT_RUNTIME_CAPABILITY).setDeprecatedSince(ModelVersion.create(1, 7)));
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        AttributeDefinition[] attributeDefinitions = this.getAttributeDefinitions();
        ManagementWriteAttributeHandler defaultWriteHandler = new ManagementWriteAttributeHandler(this.getValidationConsumer());
        for (AttributeDefinition attr : attributeDefinitions) {
            if (attr.equals(HTTP_UPGRADE_ENABLED)) {
                HttpUpgradeAttributeHandler handler = new HttpUpgradeAttributeHandler();
                resourceRegistration.registerReadWriteAttribute(attr, handler, handler);
                continue;
            }
            resourceRegistration.registerReadWriteAttribute(attr, null, defaultWriteHandler);
        }
    }

    protected abstract Consumer<OperationContext> getValidationConsumer();

    protected abstract AttributeDefinition[] getAttributeDefinitions();

    protected static AttributeDefinition[] combine(AttributeDefinition[] commonAttributes, AttributeDefinition ... additionalAttributes) {
        AttributeDefinition[] combined = new AttributeDefinition[commonAttributes.length + additionalAttributes.length];
        System.arraycopy(commonAttributes, 0, combined, 0, commonAttributes.length);
        System.arraycopy(additionalAttributes, 0, combined, commonAttributes.length, additionalAttributes.length);
        return combined;
    }

    protected class HttpUpgradeAttributeHandler
    implements OperationStepHandler {
        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String operationName = operation.require("operation").asString();
            assert ("http-upgrade-enabled".equals(operation.require("name").asString()));
            switch (operationName) {
                case "read-attribute": {
                    ModelNode httpUpgrade = context.readResource(PathAddress.EMPTY_ADDRESS, false).getModel().get("http-upgrade");
                    context.getResult().set(ENABLED.resolveModelAttribute(context, httpUpgrade));
                    break;
                }
                case "write-attribute": {
                    ModelNode httpUpgrade = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel().get("http-upgrade");
                    httpUpgrade.get("enabled").set(operation.require("value").asBoolean());
                    context.reloadRequired();
                    context.completeStep(OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER);
                }
            }
        }
    }
}

