/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.extension;

import java.util.Iterator;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.ExtensionRegistryType;
import org.jboss.as.controller.extension.ExtensionResource;
import org.jboss.as.controller.extension.MutableRootResourceRegistrationProvider;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleNotFoundException;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ExtensionAddHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "add";
    private final ExtensionRegistry extensionRegistry;
    private final boolean parallelBoot;
    private final ExtensionRegistryType extensionRegistryType;
    private final MutableRootResourceRegistrationProvider rootResourceRegistrationProvider;

    public ExtensionAddHandler(ExtensionRegistry extensionRegistry, boolean parallelBoot, ExtensionRegistryType extensionRegistryType, MutableRootResourceRegistrationProvider rootResourceRegistrationProvider) {
        assert (extensionRegistry != null) : "extensionRegistry is null";
        this.extensionRegistry = extensionRegistry;
        this.parallelBoot = parallelBoot;
        this.extensionRegistryType = extensionRegistryType;
        this.rootResourceRegistrationProvider = rootResourceRegistrationProvider;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ManagementResourceRegistration rootRegistration;
        boolean install;
        final String moduleName = context.getCurrentAddressValue();
        ExtensionResource resource = new ExtensionResource(moduleName, this.extensionRegistry);
        context.addResource(PathAddress.EMPTY_ADDRESS, resource);
        boolean bl = install = !this.parallelBoot || !context.isBooting();
        if (install) {
            rootRegistration = this.rootResourceRegistrationProvider.getRootResourceRegistrationForUpdate(context);
            ExtensionAddHandler.initializeExtension(this.extensionRegistry, moduleName, rootRegistration, this.extensionRegistryType);
            if (this.extensionRegistryType == ExtensionRegistryType.SLAVE && !context.isBooting()) {
                ModelNode subsystems = new ModelNode();
                this.extensionRegistry.recordSubsystemVersions(moduleName, subsystems);
                context.getResult().set(subsystems);
            }
        } else {
            rootRegistration = null;
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            @Override
            public void handleRollback(OperationContext context, ModelNode operation) {
                if (install) {
                    ExtensionAddHandler.this.extensionRegistry.removeExtension(context.readResourceFromRoot(rootRegistration.getPathAddress()), moduleName, rootRegistration);
                }
            }
        });
    }

    void initializeExtension(String module, ManagementResourceRegistration rootRegistration) {
        ExtensionAddHandler.initializeExtension(this.extensionRegistry, module, rootRegistration, this.extensionRegistryType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initializeExtension(ExtensionRegistry extensionRegistry, String module, ManagementResourceRegistration rootRegistration, ExtensionRegistryType extensionRegistryType) {
        try {
            boolean unknownModule = false;
            Iterator extensions = Module.loadServiceFromCallerModuleLoader((String)module, Extension.class).iterator();
            if (!extensions.hasNext()) {
                throw ControllerLogger.ROOT_LOGGER.notFound("META-INF/services/", Extension.class.getName(), module);
            }
            while (extensions.hasNext()) {
                Extension extension = (Extension)extensions.next();
                if (!rootRegistration.enables(extension)) continue;
                ClassLoader oldTccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(extension.getClass());
                try {
                    if (unknownModule || !extensionRegistry.getExtensionModuleNames().contains(module)) {
                        extensionRegistry.initializeParsers(extension, module, null);
                        unknownModule = true;
                    }
                    extension.initialize(extensionRegistry.getExtensionContext(module, rootRegistration, extensionRegistryType));
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
                }
            }
        }
        catch (ModuleNotFoundException e) {
            throw ControllerLogger.ROOT_LOGGER.extensionModuleNotFound(e, module);
        }
        catch (ModuleLoadException e) {
            throw ControllerLogger.ROOT_LOGGER.extensionModuleLoadingFailure(e, module);
        }
    }
}

