/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.security.InetAddressPrincipal;
import org.jboss.as.core.security.RealmGroup;
import org.jboss.as.core.security.RealmRole;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.protocol.mgmt.ProtocolUtils;

class SubjectProtocolUtil {
    private static final byte REALM_USER_PRINCIPAL = 1;
    private static final byte REALM_GROUP_PRINCIPAL = 2;
    private static final byte REALM_ROLE_PRINCIPAL = 3;
    private static final byte INET_ADDRESS_PRINCIPAL = 4;
    private static final byte PRINCIPALS_PARAM = 5;
    private static final byte REALM_PARAM = 6;
    private static final byte NAME_PARAM = 7;
    private static final byte HOST_PARAM = 8;
    private static final byte ADDR_PARAM = 9;
    private static final Map<Byte, PrincipalHandlerFactory> HANDLERS;

    SubjectProtocolUtil() {
    }

    static void write(DataOutput output, Subject subject) throws IOException {
        output.writeByte(80);
        if (subject != null) {
            Set<Principal> principals = subject.getPrincipals();
            ArrayList<PrincipalWriter> writers = new ArrayList<PrincipalWriter>(principals.size());
            for (Principal principal : principals) {
                PrincipalWriter writer = SubjectProtocolUtil.findWriter(principal);
                if (writer == null) continue;
                writers.add(writer);
            }
            output.writeInt(1);
            output.write(5);
            output.writeInt(writers.size());
            for (PrincipalWriter principalWriter : writers) {
                principalWriter.write(output);
            }
        } else {
            output.writeInt(0);
        }
    }

    private static PrincipalWriter findWriter(Principal principal) {
        PrincipalWriter writer = null;
        Iterator<PrincipalHandlerFactory> it = HANDLERS.values().iterator();
        while (it.hasNext() && writer == null) {
            writer = it.next().handlerFor(principal);
        }
        return writer;
    }

    static Subject read(DataInput input) throws IOException {
        Subject subject;
        ProtocolUtils.expectHeader((DataInput)input, (int)80);
        int size = input.readInt();
        if (size == 1) {
            subject = new Subject();
            Set<Principal> principals = subject.getPrincipals();
            ProtocolUtils.expectHeader((DataInput)input, (int)5);
            int principalCount = input.readInt();
            for (int i = 0; i < principalCount; ++i) {
                byte type = input.readByte();
                PrincipalReader reader = SubjectProtocolUtil.findReader(type);
                if (reader == null) {
                    throw ControllerLogger.ROOT_LOGGER.unsupportedPrincipalType(type);
                }
                principals.add(reader.read(input));
            }
        } else {
            subject = null;
        }
        return subject;
    }

    private static PrincipalReader findReader(byte type) {
        PrincipalReader reader = null;
        PrincipalHandlerFactory handlerFactory = HANDLERS.get(type);
        if (handlerFactory != null) {
            reader = handlerFactory.handlerFor(type);
        }
        return reader;
    }

    static {
        HashMap<Byte, PrincipalHandlerFactory> handlers = new HashMap<Byte, PrincipalHandlerFactory>(4);
        handlers.put((byte)1, new RealmUserHandlerFactory());
        handlers.put((byte)2, new RealmGroupHandlerFactory());
        handlers.put((byte)3, new RealmRoleHandlerFactory());
        handlers.put((byte)4, new InetAddressHandlerFactory());
        HANDLERS = Collections.unmodifiableMap(handlers);
    }

    private static class InetAddressHandlerFactory
    implements PrincipalHandlerFactory {
        private PrincipalReader READER = new PrincipalReader(){

            @Override
            public Principal read(DataInput in) throws IOException {
                byte paramType = in.readByte();
                if (paramType != 8) {
                    throw ControllerLogger.ROOT_LOGGER.unsupportedPrincipalParameter(paramType, (byte)4);
                }
                String host = in.readUTF();
                paramType = in.readByte();
                if (paramType != 9) {
                    throw ControllerLogger.ROOT_LOGGER.unsupportedPrincipalParameter(paramType, (byte)4);
                }
                int length = in.readInt();
                byte[] addr = new byte[length];
                in.readFully(addr);
                InetAddress address = InetAddress.getByAddress(host, addr);
                return new InetAddressPrincipal(address);
            }
        };

        private InetAddressHandlerFactory() {
        }

        @Override
        public PrincipalWriter handlerFor(final Principal principal) {
            if (principal instanceof InetAddressPrincipal) {
                return new PrincipalWriter(){

                    @Override
                    public void write(DataOutput out) throws IOException {
                        InetAddressPrincipal inetPrin = (InetAddressPrincipal)principal;
                        out.write(4);
                        InetAddress address = inetPrin.getInetAddress();
                        String host = address.getHostName();
                        byte[] addr = address.getAddress();
                        out.write(8);
                        out.writeUTF(host);
                        out.write(9);
                        out.writeInt(addr.length);
                        out.write(addr);
                    }
                };
            }
            return null;
        }

        @Override
        public PrincipalReader handlerFor(byte value) {
            if (value == 4) {
                return this.READER;
            }
            return null;
        }
    }

    private static class RealmRoleHandlerFactory
    implements PrincipalHandlerFactory {
        private PrincipalReader READER = new PrincipalReader(){

            @Override
            public Principal read(DataInput in) throws IOException {
                byte paramType = in.readByte();
                String name = null;
                if (paramType != 7) {
                    throw ControllerLogger.ROOT_LOGGER.unsupportedPrincipalParameter(paramType, (byte)3);
                }
                name = in.readUTF();
                return new RealmRole(name);
            }
        };

        private RealmRoleHandlerFactory() {
        }

        @Override
        public PrincipalWriter handlerFor(final Principal principal) {
            if (principal instanceof RealmRole) {
                return new PrincipalWriter(){

                    @Override
                    public void write(DataOutput out) throws IOException {
                        RealmRole role = (RealmRole)principal;
                        out.write(3);
                        out.write(7);
                        out.writeUTF(role.getName());
                    }
                };
            }
            return null;
        }

        @Override
        public PrincipalReader handlerFor(byte value) {
            if (value == 3) {
                return this.READER;
            }
            return null;
        }
    }

    private static class RealmGroupHandlerFactory
    implements PrincipalHandlerFactory {
        private PrincipalReader READER = new PrincipalReader(){

            @Override
            public Principal read(DataInput in) throws IOException {
                byte paramType = in.readByte();
                String realm = null;
                String name = null;
                if (paramType == 6) {
                    realm = in.readUTF();
                    paramType = in.readByte();
                }
                if (paramType != 7) {
                    throw ControllerLogger.ROOT_LOGGER.unsupportedPrincipalParameter(paramType, (byte)2);
                }
                name = in.readUTF();
                return realm == null ? new RealmGroup(name) : new RealmGroup(realm, name);
            }
        };

        private RealmGroupHandlerFactory() {
        }

        @Override
        public PrincipalWriter handlerFor(final Principal principal) {
            if (principal instanceof RealmGroup) {
                return new PrincipalWriter(){

                    @Override
                    public void write(DataOutput out) throws IOException {
                        RealmGroup group = (RealmGroup)principal;
                        out.write(2);
                        String realm = group.getRealm();
                        if (realm != null) {
                            out.write(6);
                            out.writeUTF(realm);
                        }
                        out.write(7);
                        out.writeUTF(group.getName());
                    }
                };
            }
            return null;
        }

        @Override
        public PrincipalReader handlerFor(byte value) {
            if (value == 2) {
                return this.READER;
            }
            return null;
        }
    }

    private static class RealmUserHandlerFactory
    implements PrincipalHandlerFactory {
        private PrincipalReader READER = new PrincipalReader(){

            @Override
            public Principal read(DataInput in) throws IOException {
                byte paramType = in.readByte();
                String realm = null;
                String name = null;
                if (paramType == 6) {
                    realm = in.readUTF();
                    paramType = in.readByte();
                }
                if (paramType != 7) {
                    throw ControllerLogger.ROOT_LOGGER.unsupportedPrincipalParameter(paramType, (byte)1);
                }
                name = in.readUTF();
                return realm == null ? new RealmUser(name) : new RealmUser(realm, name);
            }
        };

        private RealmUserHandlerFactory() {
        }

        @Override
        public PrincipalWriter handlerFor(final Principal principal) {
            if (principal instanceof RealmUser) {
                return new PrincipalWriter(){

                    @Override
                    public void write(DataOutput out) throws IOException {
                        RealmUser user = (RealmUser)principal;
                        out.write(1);
                        String realm = user.getRealm();
                        if (realm != null) {
                            out.write(6);
                            out.writeUTF(realm);
                        }
                        out.write(7);
                        out.writeUTF(user.getName());
                    }
                };
            }
            return null;
        }

        @Override
        public PrincipalReader handlerFor(byte value) {
            if (value == 1) {
                return this.READER;
            }
            return null;
        }
    }

    private static interface PrincipalHandlerFactory {
        public PrincipalWriter handlerFor(Principal var1);

        public PrincipalReader handlerFor(byte var1);
    }

    private static interface PrincipalReader {
        public Principal read(DataInput var1) throws IOException;
    }

    private static interface PrincipalWriter {
        public void write(DataOutput var1) throws IOException;
    }
}

