/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.capability.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.capability.registry.CapabilityContext;
import org.jboss.as.controller.capability.registry.CapabilityResolutionContext;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

abstract class IncludingResourceCapabilityContext
implements CapabilityContext {
    final CapabilityResolutionContext.AttachmentKey<Map<String, Set<CapabilityContext>>> attachmentKey;
    final String type;
    final String value;

    IncludingResourceCapabilityContext(CapabilityResolutionContext.AttachmentKey<Map<String, Set<CapabilityContext>>> attachmentKey, String type, String value) {
        this.attachmentKey = attachmentKey;
        this.type = type;
        this.value = value;
    }

    @Override
    public String getName() {
        return this.type + "=" + this.value;
    }

    @Override
    public Set<CapabilityContext> getIncludingContexts(CapabilityResolutionContext context) {
        Set<CapabilityContext> result;
        Map<String, Set<CapabilityContext>> attached = context.getAttachment(this.attachmentKey);
        if (attached == null) {
            String name;
            attached = new HashMap<String, Set<CapabilityContext>>();
            HashMap<String, Set<String>> included = new HashMap<String, Set<String>>();
            Set<Resource.ResourceEntry> children = context.getResourceRoot().getChildren(this.type);
            for (Resource.ResourceEntry resource : children) {
                name = resource.getName();
                Set<String> includes = IncludingResourceCapabilityContext.getIncludes(resource);
                included.put(name, includes);
                attached.put(name, new HashSet());
            }
            for (Resource.ResourceEntry resource : children) {
                name = resource.getName();
                IncludingResourceCapabilityContext.storeIncludes(this.createIncludedContext(name), name, attached, included);
            }
            context.attach(this.attachmentKey, attached);
        }
        return (result = attached.get(this.value)) == null ? Collections.emptySet() : result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.getName() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncludingResourceCapabilityContext that = (IncludingResourceCapabilityContext)o;
        return this.type.equals(that.type) && this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    protected abstract CapabilityContext createIncludedContext(String var1);

    private static Set<String> getIncludes(Resource.ResourceEntry resource) {
        Set<String> result;
        ModelNode model = resource.getModel();
        if (model.hasDefined("includes")) {
            result = new HashSet();
            for (ModelNode node : model.get("includes").asList()) {
                result.add(node.asString());
            }
        } else {
            result = Collections.emptySet();
        }
        return result;
    }

    private static void storeIncludes(CapabilityContext includedContext, String key, Map<String, Set<CapabilityContext>> attached, Map<String, Set<String>> included) {
        for (String includer : included.get(key)) {
            if (includedContext.getName().equals(includer)) continue;
            Set<CapabilityContext> includees = attached.get(includer);
            includees.add(includedContext);
            IncludingResourceCapabilityContext.storeIncludes(includedContext, includer, attached, included);
        }
    }
}

