/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public abstract class AbstractRemoveStepHandler
implements OperationStepHandler {
    private final Set<RuntimeCapability> capabilities;

    protected AbstractRemoveStepHandler() {
        this(AbstractAddStepHandler.NULL_CAPABILITIES);
    }

    protected AbstractRemoveStepHandler(RuntimeCapability ... capabilities) {
        this((Set<RuntimeCapability>)(capabilities.length == 0 ? AbstractAddStepHandler.NULL_CAPABILITIES : new HashSet<RuntimeCapability>(Arrays.asList(capabilities))));
    }

    protected AbstractRemoveStepHandler(Set<RuntimeCapability> capabilities) {
        this.capabilities = capabilities == null ? AbstractAddStepHandler.NULL_CAPABILITIES : capabilities;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        final ModelNode model = Resource.Tools.readModel(resource);
        this.recordCapabilitiesAndRequirements(context, operation, resource);
        this.performRemove(context, operation, model);
        if (this.requiresRuntime(context)) {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    AbstractRemoveStepHandler.this.performRuntime(context, operation, model);
                    context.completeStep(new OperationContext.RollbackHandler(){

                        @Override
                        public void handleRollback(OperationContext context, ModelNode operation) {
                            try {
                                AbstractRemoveStepHandler.this.recoverServices(context, operation, model);
                            }
                            catch (Exception e) {
                                ControllerLogger.MGMT_OP_LOGGER.errorRevertingOperation(e, this.getClass().getSimpleName(), operation.require("operation").asString(), context.getCurrentAddress());
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        if (this.requireNoChildResources() && !resource.getChildTypes().isEmpty()) {
            List<PathElement> children = this.getChildren(resource);
            throw ControllerLogger.ROOT_LOGGER.cannotRemoveResourceWithChildren(children);
        }
        context.removeResource(PathAddress.EMPTY_ADDRESS);
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        for (RuntimeCapability capability : this.capabilities) {
            if (capability.isDynamicallyNamed()) {
                context.deregisterCapability(capability.getDynamicName(context.getCurrentAddressValue()));
                continue;
            }
            context.deregisterCapability(capability.getName());
        }
        ModelNode model = resource.getModel();
        ImmutableManagementResourceRegistration mrr = context.getResourceRegistration();
        for (String attr : mrr.getAttributeNames(PathAddress.EMPTY_ADDRESS)) {
            AttributeDefinition ad;
            AttributeAccess aa = mrr.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attr);
            if (aa == null || (ad = aa.getAttributeDefinition()) == null || !model.hasDefined(ad.getName())) continue;
            ad.removeCapabilityRequirements(context, model.get(ad.getName()));
        }
    }

    protected boolean requireNoChildResources() {
        return false;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.isDefaultRequiresRuntime();
    }

    private List<PathElement> getChildren(Resource resource) {
        ArrayList<PathElement> pes = new ArrayList<PathElement>();
        for (String childType : resource.getChildTypes()) {
            for (Resource.ResourceEntry entry : resource.getChildren(childType)) {
                pes.add(entry.getPathElement());
            }
        }
        return pes;
    }
}

