/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.UnauthorizedException;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.access.ResourceNotAddressableException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.FilteredData;
import org.jboss.as.controller.operations.global.GlobalOperationAttributes;
import org.jboss.as.controller.operations.global.ListOperations;
import org.jboss.as.controller.operations.global.LocaleResolver;
import org.jboss.as.controller.operations.global.MapOperations;
import org.jboss.as.controller.operations.global.ReadAttributeGroupHandler;
import org.jboss.as.controller.operations.global.ReadAttributeGroupNamesHandler;
import org.jboss.as.controller.operations.global.ReadAttributeHandler;
import org.jboss.as.controller.operations.global.ReadChildrenNamesHandler;
import org.jboss.as.controller.operations.global.ReadChildrenResourcesHandler;
import org.jboss.as.controller.operations.global.ReadChildrenTypesHandler;
import org.jboss.as.controller.operations.global.ReadOperationDescriptionHandler;
import org.jboss.as.controller.operations.global.ReadOperationNamesHandler;
import org.jboss.as.controller.operations.global.ReadResourceDescriptionHandler;
import org.jboss.as.controller.operations.global.ReadResourceHandler;
import org.jboss.as.controller.operations.global.UndefineAttributeHandler;
import org.jboss.as.controller.operations.global.WriteAttributeHandler;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class GlobalOperationHandlers {
    public static final String CHECK_DEFAULT_RESOURCE_ACCESS = "check-default-resource-access";
    public static final String CHECK_RESOURCE_ACCESS = "check-resource-access";

    public static void registerGlobalOperations(ManagementResourceRegistration root, ProcessType processType) {
        if (processType == ProcessType.HOST_CONTROLLER) {
            root.registerOperationHandler(ReadResourceHandler.DEFINITION, ReadResourceHandler.INSTANCE, true);
            root.registerOperationHandler(ReadAttributeHandler.DEFINITION, ReadAttributeHandler.INSTANCE, true);
            root.registerOperationHandler(ReadAttributeGroupHandler.DEFINITION, ReadAttributeGroupHandler.INSTANCE, true);
        } else {
            root.registerOperationHandler(ReadResourceHandler.RESOLVE_DEFINITION, ReadResourceHandler.RESOLVE_INSTANCE, true);
            root.registerOperationHandler(ReadAttributeHandler.RESOLVE_DEFINITION, ReadAttributeHandler.RESOLVE_INSTANCE, true);
            root.registerOperationHandler(ReadAttributeGroupHandler.RESOLVE_DEFINITION, ReadAttributeGroupHandler.RESOLVE_INSTANCE, true);
        }
        root.registerOperationHandler(ReadResourceDescriptionHandler.DEFINITION, ReadResourceDescriptionHandler.INSTANCE, true);
        root.registerOperationHandler(ReadAttributeGroupNamesHandler.DEFINITION, ReadAttributeGroupNamesHandler.INSTANCE, true);
        root.registerOperationHandler(ReadChildrenNamesHandler.DEFINITION, ReadChildrenNamesHandler.INSTANCE, true);
        root.registerOperationHandler(ReadChildrenTypesHandler.DEFINITION, ReadChildrenTypesHandler.INSTANCE, true);
        root.registerOperationHandler(ReadChildrenResourcesHandler.DEFINITION, ReadChildrenResourcesHandler.INSTANCE, true);
        root.registerOperationHandler(ReadOperationNamesHandler.DEFINITION, ReadOperationNamesHandler.INSTANCE, true);
        root.registerOperationHandler(ReadOperationDescriptionHandler.DEFINITION, ReadOperationDescriptionHandler.INSTANCE, true);
        root.registerOperationHandler(MapOperations.MAP_PUT_DEFINITION, MapOperations.MAP_PUT_HANDLER, true);
        root.registerOperationHandler(MapOperations.MAP_GET_DEFINITION, MapOperations.MAP_GET_HANDLER, true);
        root.registerOperationHandler(MapOperations.MAP_REMOVE_DEFINITION, MapOperations.MAP_REMOVE_HANDLER, true);
        root.registerOperationHandler(MapOperations.MAP_CLEAR_DEFINITION, MapOperations.MAP_CLEAR_HANDLER, true);
        root.registerOperationHandler(ListOperations.LIST_ADD_DEFINITION, ListOperations.LIST_ADD_HANDLER, true);
        root.registerOperationHandler(ListOperations.LIST_REMOVE_DEFINITION, ListOperations.LIST_REMOVE_HANDLER, true);
        root.registerOperationHandler(ListOperations.LIST_GET_DEFINITION, ListOperations.LIST_GET_HANDLER, true);
        root.registerOperationHandler(ListOperations.LIST_CLEAR_DEFINITION, ListOperations.LIST_CLEAR_HANDLER, true);
        root.registerOperationHandler(ReadResourceDescriptionHandler.CheckResourceAccessHandler.DEFINITION, new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                throw new OperationFailedException("This should never be called");
            }
        }, true);
        root.registerOperationHandler(ReadResourceDescriptionHandler.CheckResourceAccessHandler.DEFAULT_DEFINITION, new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                throw new OperationFailedException("This should never be called");
            }
        }, true);
        if (processType != ProcessType.DOMAIN_SERVER) {
            root.registerOperationHandler(WriteAttributeHandler.DEFINITION, WriteAttributeHandler.INSTANCE, true);
            root.registerOperationHandler(UndefineAttributeHandler.DEFINITION, UndefineAttributeHandler.INSTANCE, true);
        }
    }

    private GlobalOperationHandlers() {
    }

    static Map<String, Set<String>> getChildAddresses(OperationContext context, PathAddress addr, ImmutableManagementResourceRegistration registry, Resource resource, String validChildType) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        Set<PathElement> elements = registry.getChildAddresses(PathAddress.EMPTY_ADDRESS);
        for (PathElement element : elements) {
            ImmutableManagementResourceRegistration childReg;
            String childType = element.getKey();
            if (validChildType != null && !validChildType.equals(childType)) continue;
            ImmutableManagementResourceRegistration childRegistration = registry.getSubModel(PathAddress.pathAddress(element));
            AliasEntry aliasEntry = childRegistration.getAliasEntry();
            LinkedHashSet<String> set = (LinkedHashSet<String>)result.get(childType);
            if (set == null) {
                set = new LinkedHashSet<String>();
                result.put(childType, set);
            }
            if (aliasEntry == null) {
                if (resource != null && resource.hasChildren(childType)) {
                    Set<String> childNames = resource.getChildrenNames(childType);
                    if (element.isWildcard()) {
                        set.addAll(childNames);
                    } else if (childNames.contains(element.getValue())) {
                        set.add(element.getValue());
                    }
                }
            } else {
                PathAddress target = aliasEntry.convertToTargetAddress(addr.append(element));
                PathAddress targetParent = target.subAddress(0, target.size() - 1);
                Resource parentResource = context.readResourceFromRoot(targetParent, false);
                if (parentResource != null) {
                    PathElement targetElement = target.getLastElement();
                    if (targetElement.isWildcard()) {
                        set.addAll(parentResource.getChildrenNames(targetElement.getKey()));
                    } else if (parentResource.hasChild(targetElement)) {
                        set.add(element.getValue());
                    }
                }
            }
            if (element.isWildcard() || (childReg = registry.getSubModel(PathAddress.pathAddress(element))) == null || !childReg.isRemote()) continue;
            set.add(element.getValue());
        }
        for (String type : registry.getChildNames(PathAddress.EMPTY_ADDRESS)) {
            if (validChildType != null && !validChildType.equals(type) || result.containsKey(type)) continue;
            result.put(type, Collections.emptySet());
        }
        return result;
    }

    static Locale getLocale(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined(GlobalOperationAttributes.LOCALE.getName())) {
            return null;
        }
        String unparsed = GlobalOperationHandlers.normalizeLocale(operation.get(GlobalOperationAttributes.LOCALE.getName()).asString());
        try {
            return LocaleResolver.resolveLocale(unparsed);
        }
        catch (IllegalArgumentException e) {
            GlobalOperationHandlers.reportInvalidLocaleFormat(context, e.getMessage());
            return null;
        }
    }

    static boolean getRecursive(OperationContext context, ModelNode op) throws OperationFailedException {
        ModelNode recursiveNode = GlobalOperationAttributes.RECURSIVE.resolveModelAttribute(context, op);
        int recursiveValue = recursiveNode.isDefined() ? (recursiveNode.asBoolean() ? 1 : 0) : -1;
        int recursiveDepthValue = GlobalOperationAttributes.RECURSIVE_DEPTH.resolveModelAttribute(context, op).asInt(-1);
        return recursiveValue > 0 && recursiveDepthValue == -1 || recursiveValue != 0 && recursiveDepthValue > 0;
    }

    static void setNextRecursive(OperationContext context, ModelNode op, ModelNode nextOp) throws OperationFailedException {
        int recursiveDepthValue = GlobalOperationAttributes.RECURSIVE_DEPTH.resolveModelAttribute(context, op).asInt(-1);
        nextOp.get(GlobalOperationAttributes.RECURSIVE.getName()).set(op.get(GlobalOperationAttributes.RECURSIVE.getName()));
        switch (recursiveDepthValue) {
            case -1: {
                nextOp.get(GlobalOperationAttributes.RECURSIVE_DEPTH.getName()).set(op.get(GlobalOperationAttributes.RECURSIVE_DEPTH.getName()));
                break;
            }
            case 0: {
                nextOp.get(GlobalOperationAttributes.RECURSIVE_DEPTH.getName()).set(recursiveDepthValue);
                break;
            }
            default: {
                nextOp.get(GlobalOperationAttributes.RECURSIVE_DEPTH.getName()).set(recursiveDepthValue - 1);
            }
        }
    }

    private static String normalizeLocale(String toNormalize) {
        return "zh_Hans".equalsIgnoreCase(toNormalize) || "zh-Hans".equalsIgnoreCase(toNormalize) ? "zh_CN" : toNormalize;
    }

    private static void reportInvalidLocaleFormat(OperationContext context, String format) {
        String msg = ControllerLogger.ROOT_LOGGER.invalidLocaleString(format);
        ControllerLogger.MGMT_OP_LOGGER.debug(msg);
    }

    static class AvailableResponseWrapper
    implements OperationStepHandler {
        private final OperationStepHandler wrapped;
        private final AvailableResponse availableResponse;

        AvailableResponseWrapper(OperationStepHandler wrapped, AvailableResponse availableResponse) {
            this.wrapped = wrapped;
            this.availableResponse = availableResponse;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            try {
                this.wrapped.execute(context, operation);
            }
            catch (Resource.NoSuchResourceException e) {
                this.availableResponse.unavailable = true;
            }
        }
    }

    static class AvailableResponse {
        boolean unavailable;
        final ModelNode response;

        AvailableResponse(ModelNode response) {
            this.response = response;
        }
    }

    static class RegistrationAddressResolver
    implements OperationStepHandler {
        private final ModelNode operation;
        private final ModelNode result;
        private final OperationStepHandler handler;

        RegistrationAddressResolver(ModelNode operation, ModelNode result, OperationStepHandler delegate) {
            this.operation = operation;
            this.result = result;
            this.handler = delegate;
        }

        @Override
        public void execute(OperationContext context, ModelNode ignored) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress(this.operation.require("address"));
            this.execute(address, PathAddress.EMPTY_ADDRESS, context);
        }

        void execute(PathAddress address, PathAddress base, OperationContext context) {
            PathAddress current = address.subAddress(base.size());
            Iterator iterator = current.iterator();
            if (iterator.hasNext()) {
                PathElement element = (PathElement)iterator.next();
                if (element.isMultiTarget()) {
                    Set<PathElement> children = context.getResourceRegistration().getChildAddresses(base);
                    if (children == null || children.isEmpty()) {
                        return;
                    }
                    String childType = element.getKey().equals("*") ? null : element.getKey();
                    for (PathElement path : children) {
                        if (childType != null && !childType.equals(path.getKey())) continue;
                        this.execute(address, base.append(path), context);
                    }
                } else {
                    this.execute(address, base.append(element), context);
                }
            } else {
                ModelNode newOp = this.operation.clone();
                newOp.get("address").set(base.toModelNode());
                ModelNode result = this.result.add();
                result.get("address").set(base.toModelNode());
                context.addStep(result, newOp, this.handler, OperationContext.Stage.MODEL, true);
            }
        }
    }

    public static final class ModelAddressResolver
    implements OperationStepHandler {
        private final ModelNode operation;
        private final ModelNode result;
        private final FilteredData filteredData;
        private final OperationStepHandler handler;

        public ModelAddressResolver(ModelNode operation, ModelNode result, FilteredData filteredData, OperationStepHandler delegate) {
            this.operation = operation;
            this.result = result;
            this.handler = delegate;
            this.filteredData = filteredData;
        }

        @Override
        public void execute(OperationContext context, ModelNode ignored) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress(this.operation.require("address"));
            this.execute(PathAddress.EMPTY_ADDRESS, address, context, context.getRootResourceRegistration(), false);
            context.completeStep(new OperationContext.ResultHandler(){

                @Override
                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    if (result.getType() == ModelType.LIST) {
                        boolean replace = false;
                        ModelNode replacement = new ModelNode().setEmptyList();
                        for (ModelNode item : result.asList()) {
                            if (item.isDefined() && item.hasDefined("address")) {
                                replacement.add(item);
                                continue;
                            }
                            replace = true;
                        }
                        if (replace) {
                            result.set(replacement);
                        }
                    }
                }
            });
        }

        private void safeExecute(PathAddress base, PathAddress remaining, OperationContext context, ImmutableManagementResourceRegistration registration, boolean ignoreMissing) {
            block5: {
                try {
                    ControllerLogger.MGMT_OP_LOGGER.tracef("safeExecute for %s, remaining is %s", base, remaining);
                    this.execute(base, remaining, context, registration, ignoreMissing);
                }
                catch (UnauthorizedException e) {
                    this.filteredData.addReadRestrictedResource(base);
                    ControllerLogger.MGMT_OP_LOGGER.tracef("Caught UnauthorizedException in %s", this);
                }
                catch (ResourceNotAddressableException e) {
                    this.filteredData.addAccessRestrictedResource(base);
                    ControllerLogger.MGMT_OP_LOGGER.tracef("Caught ResourceNotAddressableException in %s", this);
                }
                catch (Resource.NoSuchResourceException e) {
                    ModelNode toAuthorize = Util.createEmptyOperation("read-resource", base);
                    AuthorizationResult.Decision decision = context.authorize(toAuthorize, EnumSet.of(Action.ActionEffect.ADDRESS)).getDecision();
                    ControllerLogger.MGMT_OP_LOGGER.tracef("Caught NoSuchResourceException in %s. Authorization decision is %s", this, (Object)decision);
                    if (decision == AuthorizationResult.Decision.DENY) {
                        this.filteredData.addAccessRestrictedResource(base);
                    }
                    if (ignoreMissing) break block5;
                    throw e;
                }
            }
        }

        private void execute(final PathAddress base, final PathAddress remaining, OperationContext context, ImmutableManagementResourceRegistration registration, final boolean ignoreMissing) {
            if (registration.isRemote()) {
                ModelNode remoteOp = this.operation.clone();
                final PathAddress fullAddress = base.append(remaining);
                remoteOp.get("address").set(fullAddress.toModelNode());
                final ModelNode resultItem = new ModelNode();
                final OperationStepHandler delegate = registration.getOperationHandler(PathAddress.EMPTY_ADDRESS, this.operation.require("operation").asString());
                context.addStep(resultItem, remoteOp, new OperationStepHandler(){

                    @Override
                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        try {
                            ControllerLogger.MGMT_OP_LOGGER.tracef("sending ModelAddressResolver request %s to remote process using %s", operation, delegate);
                            final AtomicBoolean filtered = new AtomicBoolean(false);
                            context.addStep(new OperationStepHandler(){

                                @Override
                                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                                    block5: {
                                        try {
                                            delegate.execute(context, operation);
                                        }
                                        catch (UnauthorizedException e) {
                                            filteredData.addReadRestrictedResource(base);
                                            filtered.set(true);
                                            ControllerLogger.MGMT_OP_LOGGER.tracef("Caught UnauthorizedException in remote execution from %s", delegate);
                                        }
                                        catch (ResourceNotAddressableException e) {
                                            filteredData.addAccessRestrictedResource(base);
                                            filtered.set(true);
                                            ControllerLogger.MGMT_OP_LOGGER.tracef("Caught ResourceNotAddressableException in remote execution from %s", delegate);
                                        }
                                        catch (Resource.NoSuchResourceException e) {
                                            ModelNode toAuthorize = Util.createEmptyOperation("read-resource", base);
                                            AuthorizationResult.Decision decision = context.authorize(toAuthorize, EnumSet.of(Action.ActionEffect.ADDRESS)).getDecision();
                                            ControllerLogger.MGMT_OP_LOGGER.tracef("Caught NoSuchResourceException in remote execution from %s. Authorization decision is %s", delegate, (Object)decision);
                                            if (decision == AuthorizationResult.Decision.DENY) {
                                                filteredData.addAccessRestrictedResource(base);
                                                filtered.set(true);
                                            }
                                            if (ignoreMissing) break block5;
                                            throw e;
                                        }
                                    }
                                }
                            }, OperationContext.Stage.MODEL, true);
                            context.completeStep(new OperationContext.ResultHandler(){

                                @Override
                                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                                    PathAddress rbacPrefix;
                                    ControllerLogger.MGMT_OP_LOGGER.tracef("ModelAddressResolver response from remote process is %s", resultItem);
                                    if (filtered.get()) {
                                        ControllerLogger.MGMT_OP_LOGGER.trace("Response was filtered");
                                        return;
                                    }
                                    PathAddress pathAddress = rbacPrefix = base.size() > 1 && base.getElement(1).getKey().equals("server") ? base : PathAddress.EMPTY_ADDRESS;
                                    if (remaining.isMultiTarget()) {
                                        if (resultItem.has("result") && resultItem.get("result").getType() == ModelType.LIST) {
                                            for (ModelNode rr : resultItem.get("result").asList()) {
                                                ModelNode nr = result.add();
                                                PathAddress address = PathAddress.pathAddress(rr.get("address"));
                                                int max = Math.min(base.size(), address.size());
                                                int match = 0;
                                                for (int i = 0; i < max; ++i) {
                                                    PathElement eb = base.getElement(i);
                                                    PathElement ea = address.getElement(i);
                                                    if (!eb.getKey().equals(ea.getKey())) continue;
                                                    match = i + 1;
                                                }
                                                PathAddress resolvedAddress = base.append(address.subAddress(match));
                                                ControllerLogger.MGMT_OP_LOGGER.tracef("recording multi-target ModelAddressResolver response to %s at %s", fullAddress, resolvedAddress);
                                                nr.get("address").set(resolvedAddress.toModelNode());
                                                nr.get("outcome").set(rr.get("outcome"));
                                                nr.get("result").set(rr.get("result"));
                                                if (!rr.hasDefined("response-headers")) continue;
                                                ModelNode headers = rr.get("response-headers");
                                                ModelNode acc = headers.remove("access-control");
                                                if (headers.asInt() > 0) {
                                                    nr.get("response-headers").set(headers);
                                                }
                                                if (!acc.isDefined()) continue;
                                                filteredData.populate(acc, rbacPrefix);
                                                ControllerLogger.MGMT_OP_LOGGER.tracef("Populated local filtered data with remote access control headers %s from result item %s", acc, rr);
                                            }
                                            if (resultItem.hasDefined(new String[]{"response-headers", "access-control"})) {
                                                ModelNode acc = resultItem.get(new String[]{"response-headers", "access-control"});
                                                filteredData.populate(acc, PathAddress.EMPTY_ADDRESS);
                                            }
                                        }
                                    } else {
                                        ControllerLogger.MGMT_OP_LOGGER.tracef("recording non-multi-target ModelAddressResolver response to %s", fullAddress);
                                        ModelNode nr = result.add();
                                        nr.get("address").set(fullAddress.toModelNode());
                                        nr.get("outcome").set(resultItem.get("outcome"));
                                        nr.get("result").set(resultItem.get("result"));
                                        if (resultItem.hasDefined("response-headers")) {
                                            ModelNode headers = resultItem.get("response-headers");
                                            ModelNode acc = headers.remove("access-control");
                                            if (headers.asInt() > 0) {
                                                nr.get("response-headers").set(headers);
                                            }
                                            if (acc.isDefined()) {
                                                filteredData.populate(acc, PathAddress.EMPTY_ADDRESS);
                                                ControllerLogger.MGMT_OP_LOGGER.tracef("Populated local filtered data with remote access control headers %s from result item %s", acc, resultItem);
                                            }
                                        }
                                    }
                                }
                            });
                        }
                        catch (Resource.NoSuchResourceException noSuchResourceException) {
                            // empty catch block
                        }
                    }
                }, OperationContext.Stage.MODEL, true);
                return;
            }
            Resource resource = context.readResource(base, false);
            if (remaining.size() > 0) {
                PathElement element = remaining.getElement(0);
                PathAddress newRemaining = remaining.subAddress(1);
                if (element.isMultiTarget()) {
                    String childType;
                    String string = childType = element.getKey().equals("*") ? null : element.getKey();
                    if (registration.isRemote()) {
                        throw new IllegalStateException();
                    }
                    Map<String, Set<String>> resolved = GlobalOperationHandlers.getChildAddresses(context, base, registration, resource, childType);
                    for (Map.Entry<String, Set<String>> entry : resolved.entrySet()) {
                        String key = entry.getKey();
                        Set<String> children = entry.getValue();
                        if (children.isEmpty()) continue;
                        if (element.isWildcard()) {
                            for (String child : children) {
                                PathElement e = PathElement.pathElement(key, child);
                                PathAddress next = base.append(e);
                                ImmutableManagementResourceRegistration nr = context.getResourceRegistration().getSubModel(next);
                                if (!resource.hasChild(e) && (nr == null || !nr.isRemote())) continue;
                                this.safeExecute(next, newRemaining, context, nr, true);
                            }
                            continue;
                        }
                        String[] segments = element.getSegments();
                        boolean ignore = ignoreMissing || segments.length > 1;
                        for (String segment : element.getSegments()) {
                            if (!children.contains(segment)) continue;
                            PathElement e = PathElement.pathElement(key, segment);
                            PathAddress next = base.append(e);
                            ImmutableManagementResourceRegistration nr = context.getResourceRegistration().getSubModel(next);
                            if (!resource.hasChild(e) && (nr == null || !nr.isRemote())) continue;
                            this.safeExecute(next, newRemaining, context, nr, ignore);
                        }
                    }
                } else {
                    PathAddress next = base.append(element);
                    ImmutableManagementResourceRegistration nr = context.getResourceRegistration().getSubModel(next);
                    if (resource.hasChild(element) || nr != null && nr.isRemote()) {
                        this.safeExecute(next, newRemaining, context, nr, ignoreMissing);
                    }
                }
            } else {
                ModelNode newOp = this.operation.clone();
                newOp.get("address").set(base.toModelNode());
                final ModelNode resultItem = this.result.add();
                ControllerLogger.MGMT_OP_LOGGER.tracef("Added ModelAddressResolver result item for %s", base);
                final ModelNode resultAddress = resultItem.get("address");
                OperationStepHandler wrapper = new OperationStepHandler(){

                    @Override
                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        try {
                            handler.execute(context, operation);
                            context.completeStep(new OperationContext.ResultHandler(){

                                @Override
                                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                                    ControllerLogger.MGMT_OP_LOGGER.tracef("ModelAddressResolver result for %s is %s", base, resultItem);
                                    if (resultItem.hasDefined("result")) {
                                        resultAddress.set(base.toModelNode());
                                        if (resultItem.hasDefined(new String[]{"response-headers", "access-control"})) {
                                            ModelNode headers = resultItem.get("response-headers");
                                            ModelNode acc = headers.remove("access-control");
                                            if (headers.asInt() == 0) {
                                                resultItem.remove("response-headers");
                                            }
                                            filteredData.populate(acc, PathAddress.EMPTY_ADDRESS);
                                        }
                                    } else {
                                        resultItem.clear();
                                    }
                                }
                            });
                        }
                        catch (Resource.NoSuchResourceException noSuchResourceException) {
                            // empty catch block
                        }
                    }
                };
                context.addStep(resultItem, newOp, wrapper, OperationContext.Stage.MODEL, true);
            }
        }
    }

    public static abstract class AbstractMultiTargetHandler
    implements OperationStepHandler {
        public static final ModelNode FAKE_OPERATION;
        private final FilteredData filteredData;
        private final boolean ignoreMissingResource;

        protected AbstractMultiTargetHandler() {
            this(null, false);
        }

        protected AbstractMultiTargetHandler(FilteredData filteredData) {
            this(filteredData, false);
        }

        protected AbstractMultiTargetHandler(FilteredData filteredData, boolean ignoreMissingResource) {
            this.filteredData = filteredData;
            this.ignoreMissingResource = ignoreMissingResource;
        }

        protected FilteredData getFilteredData() {
            return this.filteredData;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = context.getCurrentAddress();
            if (address.isMultiTarget()) {
                final FilteredData localFilteredData = this.filteredData == null ? new FilteredData(PathAddress.EMPTY_ADDRESS) : this.filteredData;
                ModelNode result = context.getResult().setEmptyList();
                context.addStep(new ModelNode(), FAKE_OPERATION.clone(), new ModelAddressResolver(operation, result, localFilteredData, new OperationStepHandler(){

                    @Override
                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        this.doExecute(context, operation, localFilteredData, true);
                    }
                }), OperationContext.Stage.MODEL, true);
                context.completeStep(new OperationContext.ResultHandler(){

                    @Override
                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        if (resultAction == OperationContext.ResultAction.KEEP && localFilteredData.hasFilteredData()) {
                            context.getResponseHeaders().get("access-control").set(localFilteredData.toModelNode());
                        }
                    }
                });
            } else {
                this.doExecute(context, operation, this.filteredData, this.ignoreMissingResource);
            }
        }

        abstract void doExecute(OperationContext var1, ModelNode var2, FilteredData var3, boolean var4) throws OperationFailedException;

        static {
            ModelNode resolve = new ModelNode();
            resolve.get("operation").set("resolve");
            resolve.get("address").setEmptyList();
            resolve.protect();
            FAKE_OPERATION = resolve;
        }
    }
}

